/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.IOException;
import java.io.InputStream;

class CountingInputStream
extends InputStream {
    long streamPos = 0L;
    long markPos = 0L;
    InputStream inputStream = null;

    CountingInputStream(InputStream is) {
        this.inputStream = is;
    }

    long getStreamPosition() {
        return this.streamPos;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.markPos = this.streamPos;
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        int ret = this.inputStream.read();
        if (ret > -1) {
            ++this.streamPos;
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = this.inputStream.read(b);
        if (ret > 0) {
            this.streamPos += (long)ret;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.inputStream.read(b, off, len);
        if (ret > 0) {
            this.streamPos += (long)ret;
        }
        return ret;
    }

    @Override
    public void reset() throws IOException {
        this.streamPos = this.markPos;
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        long ret = this.inputStream.skip(n);
        this.streamPos += ret;
        return ret;
    }
}

