/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.dfs.client.HPCCRecord;
import org.hpccsystems.dfs.client.IRecordBuilder;

public class HPCCRecordBuilder
implements IRecordBuilder {
    private Object[] fields = null;
    private FieldDef fieldDef = null;
    private HPCCRecordBuilder[] childRecordBuilders = null;

    public HPCCRecordBuilder(FieldDef recordDef) {
        this.setRecordDefinition(recordDef);
    }

    @Override
    public void setRecordDefinition(FieldDef fieldDef) {
        this.fieldDef = fieldDef;
        this.childRecordBuilders = new HPCCRecordBuilder[this.fieldDef.getNumDefs()];
        for (int i = 0; i < this.fieldDef.getNumDefs(); ++i) {
            boolean needsChildRecordBuilder;
            FieldDef fd = this.fieldDef.getDef(i);
            boolean bl = needsChildRecordBuilder = fd.getFieldType() == FieldType.RECORD || fd.getFieldType() == FieldType.DATASET && fd.getDef(0).getFieldType() == FieldType.RECORD;
            if (needsChildRecordBuilder) {
                FieldDef subFd = fd;
                if (fd.getFieldType() == FieldType.DATASET) {
                    subFd = fd.getDef(0);
                }
                this.childRecordBuilders[i] = new HPCCRecordBuilder(subFd);
                continue;
            }
            this.childRecordBuilders[i] = null;
        }
    }

    @Override
    public FieldDef getRecordDefinition() {
        return this.fieldDef;
    }

    @Override
    public void startRecord() throws InstantiationException {
        this.fields = new Object[this.fieldDef.getNumDefs()];
    }

    @Override
    public Object finalizeRecord() throws InstantiationException {
        HPCCRecord row = new HPCCRecord(this.fields, this.fieldDef);
        this.fields = null;
        return row;
    }

    @Override
    public void setFieldValue(int index, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.fields[index] = value;
    }

    @Override
    public IRecordBuilder getChildRecordBuilder(int index) {
        return this.childRecordBuilders[index];
    }
}

