/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldFilter;
import org.hpccsystems.commons.ecl.FieldFilterRange;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.commons.ecl.FileFilter;
import org.hpccsystems.dfs.client.CompiledFieldFilter;
import org.hpccsystems.dfs.client.DataPartition;
import org.hpccsystems.dfs.client.HPCCRecord;
import org.hpccsystems.dfs.client.HPCCRecordBuilder;
import org.hpccsystems.dfs.client.HpccRemoteFileReader;

public class PartitionProcessor {
    private static final Logger log = LogManager.getLogger(PartitionProcessor.class);
    private DataPartition[] dataPartitions = null;
    private ArrayList<DataPartitionRecordRange> dataPartitionRanges = new ArrayList();
    private FieldDef recordDef = null;

    PartitionProcessor(FieldDef recDef, DataPartition[] partitions, DataPartition tlkPartition) throws Exception {
        this.dataPartitions = partitions;
        this.recordDef = recDef;
        if (tlkPartition == null) {
            log.warn("No TLK partition provided to partition processor; all partitions will be returned for all filters.");
            return;
        }
        boolean success = false;
        int numRetries = 0;
        Throwable readFailureException = null;
        HPCCRecordBuilder recordBuilder = new HPCCRecordBuilder(recDef);
        ArrayList<HPCCRecord> tlkRecords = new ArrayList<HPCCRecord>(partitions.length);
        while (numRetries < 3 && !success) {
            tlkRecords.clear();
            try {
                HpccRemoteFileReader fileReader = new HpccRemoteFileReader(tlkPartition, recDef, recordBuilder);
                while (fileReader.hasNext()) {
                    HPCCRecord record = (HPCCRecord)fileReader.next();
                    for (int i = 0; i < record.getNumFields(); ++i) {
                        Object field = record.getField(i);
                        FieldDef fd = this.recordDef.getDef(i);
                        if (fd.getFieldType() == FieldType.INTEGER) {
                            Long longVal = (Long)field;
                            long intBitLength = this.recordDef.getDef(i).getDataLen() * 8L;
                            if (fd.isUnsigned()) {
                                if (longVal < 0L) {
                                    longVal = Long.MAX_VALUE;
                                }
                            } else {
                                longVal = longVal & (1L << (int)(intBitLength - 1L) ^ 0xFFFFFFFFFFFFFFFFL);
                            }
                            record.setField(i, longVal);
                            continue;
                        }
                        if (fd.getFieldType() != FieldType.STRING) continue;
                        String strVal = (String)field;
                        strVal = strVal.replaceAll("\\s+$", "");
                        record.setField(i, strVal);
                    }
                    tlkRecords.add(record);
                }
                success = true;
                fileReader.close();
            }
            catch (Exception e) {
                log.error("Failed to read TLK file part retry: " + ++numRetries + " error: " + e.getMessage());
                readFailureException = e;
            }
        }
        if (!success) {
            throw new Exception("PartitionProcessor: Error while attempting to read TLK: " + readFailureException.getMessage());
        }
        if (tlkRecords.size() - 1 != this.dataPartitions.length) {
            throw new Exception("Mismatch between # of data partitions and records in TLK: " + (tlkRecords.size() - 1) + " # partitions: " + this.dataPartitions.length);
        }
        for (int i = 1; i < tlkRecords.size() - 1; ++i) {
            DataPartitionRecordRange range = new DataPartitionRecordRange();
            range.begin = (HPCCRecord)tlkRecords.get(i);
            range.end = (HPCCRecord)tlkRecords.get(i + 1);
            range.dataPartition = this.dataPartitions[i - 1];
            this.dataPartitionRanges.add(range);
        }
        DataPartitionRecordRange lastRange = new DataPartitionRecordRange();
        int lastTlkRecordIndex = tlkRecords.size() - 1;
        lastRange.begin = (HPCCRecord)tlkRecords.get(lastTlkRecordIndex - 1);
        lastRange.end = (HPCCRecord)tlkRecords.get(lastTlkRecordIndex);
        lastRange.dataPartition = this.dataPartitions[this.dataPartitions.length - 1];
        this.dataPartitionRanges.add(lastRange);
    }

    public List<DataPartition> findMatchingPartitions(FileFilter filter) {
        if (this.dataPartitionRanges.size() == 0 || filter == null) {
            return Arrays.asList(this.dataPartitions);
        }
        CompiledFileFilter compiledFileFilter = null;
        try {
            compiledFileFilter = new CompiledFileFilter(this.recordDef, filter);
        }
        catch (Exception e) {
            return Arrays.asList(this.dataPartitions);
        }
        ArrayList<DataPartition> matchingPartitions = new ArrayList<DataPartition>();
        for (int i = 0; i < this.dataPartitionRanges.size(); ++i) {
            DataPartitionRecordRange partitionRange = this.dataPartitionRanges.get(i);
            if (!compiledFileFilter.partitionMatchesFilter(partitionRange)) continue;
            matchingPartitions.add(partitionRange.dataPartition);
        }
        return matchingPartitions;
    }

    public int getNumPartitionRanges() {
        return this.dataPartitionRanges.size();
    }

    public String getPartitionRangeAsString(int index) {
        DataPartitionRecordRange range = this.dataPartitionRanges.get(index);
        String rangeStr = "[" + range.begin.toString() + "," + range.end.toString() + "]\n";
        return rangeStr;
    }

    public String toString() {
        String out = "[\n";
        for (int i = 0; i < this.dataPartitionRanges.size(); ++i) {
            DataPartitionRecordRange range = this.dataPartitionRanges.get(i);
            out = out + i + "\t[" + range.begin.toString() + "," + range.end.toString() + "]\n";
        }
        out = out + "]\n";
        return out;
    }

    private class DataPartitionRecordRange {
        public HPCCRecord begin = null;
        public HPCCRecord end = null;
        public DataPartition dataPartition = null;

        private DataPartitionRecordRange() {
        }
    }

    private class CompiledFileFilter {
        ArrayList<CompiledFieldFilterSet> filterSets = new ArrayList();

        CompiledFileFilter(FieldDef recordDef, FileFilter filter) throws Exception {
            CompiledFieldFilterSet filterSet = new CompiledFieldFilterSet();
            for (int i = 0; i < filter.getFieldFiltersCount(); ++i) {
                FieldFilter fieldFilter = filter.getFieldFilter(i);
                int fieldIndex = recordDef.getDefIndexWithFieldName(fieldFilter.getFieldName());
                if (fieldIndex < 0) {
                    throw new Exception("Unable to find field definition for field: " + fieldFilter.getFieldName());
                }
                FieldType type = recordDef.getDef(fieldIndex).getFieldType();
                for (FieldFilterRange filterRange : fieldFilter.getRanges()) {
                    filterSet.filters.add(new CompiledFieldFilter(fieldIndex, type, filterRange));
                }
            }
            this.filterSets.add(filterSet);
            List<FileFilter> andFileFilters = filter.getAndFileFilters();
            for (int i = 0; i < andFileFilters.size(); ++i) {
                filterSet = new CompiledFieldFilterSet();
                FileFilter andFilter = andFileFilters.get(i);
                for (int j = 0; j < andFilter.getFieldFiltersCount(); ++j) {
                    FieldFilter fieldFilter = andFilter.getFieldFilter(j);
                    int fieldIndex = recordDef.getDefIndexWithFieldName(fieldFilter.getFieldName());
                    if (fieldIndex < 0) {
                        throw new Exception("Unable to find field definition for field: " + fieldFilter.getFieldName());
                    }
                    FieldType type = recordDef.getDef(fieldIndex).getFieldType();
                    List<FieldFilterRange> ranges = fieldFilter.getRanges();
                    for (FieldFilterRange range : ranges) {
                        filterSet.filters.add(new CompiledFieldFilter(fieldIndex, type, range));
                    }
                }
                this.filterSets.add(filterSet);
            }
        }

        private boolean partitionMatchesFilter(DataPartitionRecordRange partRange) {
            boolean hasMatch = true;
            for (CompiledFieldFilterSet filterSet : this.filterSets) {
                CompiledFieldFilter filter;
                CompiledFieldFilter firstFilter = filterSet.filters.get(0);
                Object fieldRangeBegin = partRange.begin.getField(firstFilter.getFieldIndex());
                Object fieldRangeEnd = partRange.end.getField(firstFilter.getFieldIndex());
                boolean fieldWasMatched = false;
                Iterator<CompiledFieldFilter> iterator = filterSet.filters.iterator();
                while (iterator.hasNext() && !(fieldWasMatched = (filter = iterator.next()).matchesRange(fieldRangeBegin, fieldRangeEnd))) {
                }
                if (hasMatch = hasMatch && fieldWasMatched) continue;
                break;
            }
            return hasMatch;
        }

        public String toString() {
            String ret = "[\n";
            for (CompiledFieldFilterSet filterSet : this.filterSets) {
                ret = ret + "\t" + filterSet.toString() + "\n";
            }
            ret = ret + "]\n";
            return ret;
        }
    }

    private class CompiledFieldFilterSet {
        public ArrayList<CompiledFieldFilter> filters = new ArrayList();

        private CompiledFieldFilterSet() {
        }

        public String toString() {
            String ret = "{";
            for (CompiledFieldFilter filter : this.filters) {
                ret = ret + filter.toString() + " ";
            }
            ret = ret + "}";
            return ret;
        }
    }
}

