/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.dfs.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.RecordDefinitionTranslator;
import org.hpccsystems.dfs.client.CompressionAlgorithm;

public class RowServiceOutputStream
extends OutputStream {
    private static final Logger log = LogManager.getLogger(RowServiceOutputStream.class);
    public static final int DEFAULT_CONNECT_TIMEOUT_MILIS = 5000;
    private static int SCRATCH_BUFFER_LEN = 2048;
    private String rowServiceIP = null;
    private int rowServicePort = -1;
    private FieldDef recordDef = null;
    private String filePath = null;
    private int filePartIndex = -1;
    private String accessToken = null;
    private CompressionAlgorithm compressionAlgo = CompressionAlgorithm.NONE;
    private Socket socket = null;
    private long handle = -1L;
    private ByteBuffer scratchBuffer = ByteBuffer.allocate(SCRATCH_BUFFER_LEN);

    @Deprecated
    RowServiceOutputStream(String ip, int port, String accessToken, FieldDef recordDef, int filePartIndex, String filePartPath, CompressionAlgorithm fileCompression) throws Exception {
        this(ip, port, true, accessToken, recordDef, filePartIndex, filePartPath, fileCompression);
    }

    RowServiceOutputStream(String ip, int port, boolean useSSL, String accessToken, FieldDef recordDef, int filePartIndex, String filePartPath, CompressionAlgorithm fileCompression) throws Exception {
        this(ip, port, useSSL, accessToken, recordDef, filePartIndex, filePartPath, fileCompression, 5000);
    }

    RowServiceOutputStream(String ip, int port, boolean useSSL, String accessToken, FieldDef recordDef, int filePartIndex, String filePartPath, CompressionAlgorithm fileCompression, int connectTimeoutMs) throws Exception {
        this.rowServiceIP = ip;
        this.rowServicePort = port;
        this.recordDef = recordDef;
        this.filePartIndex = filePartIndex;
        this.filePath = filePartPath;
        this.accessToken = accessToken;
        this.compressionAlgo = fileCompression;
        try {
            if (useSSL) {
                SSLSocketFactory ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
                this.socket = (SSLSocket)ssf.createSocket();
                this.socket.setPerformancePreferences(0, 1, 2);
                this.socket.connect(new InetSocketAddress(this.rowServiceIP, this.rowServicePort), connectTimeoutMs);
                log.debug("Attempting SSL handshake...");
                ((SSLSocket)this.socket).startHandshake();
                log.debug("SSL handshake successful...");
                log.debug("   Remote address = " + this.socket.getInetAddress().toString() + " Remote port = " + this.socket.getPort());
            } else {
                SocketFactory sf = SocketFactory.getDefault();
                this.socket = sf.createSocket();
                this.socket.setPerformancePreferences(0, 1, 2);
                this.socket.connect(new InetSocketAddress(this.rowServiceIP, this.rowServicePort), 5000);
            }
        }
        catch (Exception e) {
            String errorMessage = "Exception occured while attempting to connect to row service (" + this.rowServiceIP + ":" + this.rowServicePort + "): " + e.getMessage();
            log.error(errorMessage);
            throw new Exception(errorMessage);
        }
        this.makeInitialWriteRequest();
    }

    private void makeInitialWriteRequest() throws Exception {
        String jsonRecordDef = RecordDefinitionTranslator.toJsonRecord(this.recordDef).toString();
        String initialRequest = "\n{\n    \"format\" : \"binary\",\n    \"replyLimit\" : " + SCRATCH_BUFFER_LEN + ",\n    \"node\" : {\n        \"kind\" : \"diskwrite\",\n        \"metaInfo\" : \"" + this.accessToken + "\",\n        \"fileName\" : \"" + this.filePath + "\",\n        \"filePart\" : \"" + this.filePartIndex + "\",\n        \"compressed\" : \"" + (Object)((Object)this.compressionAlgo) + "\",\n        \"input\" : " + jsonRecordDef + "\n    }\n}\n";
        byte[] jsonRequestData = initialRequest.getBytes("ISO-8859-1");
        ByteBuffer requestBuffer = ByteBuffer.allocate(jsonRequestData.length + 256);
        requestBuffer.mark();
        requestBuffer.putInt(0);
        requestBuffer.put((byte)45);
        requestBuffer.putInt(jsonRequestData.length);
        requestBuffer.put(jsonRequestData);
        int rowDataLen = 0;
        requestBuffer.putInt(rowDataLen);
        int headerLen = requestBuffer.position();
        int packetLen = headerLen + rowDataLen - 4;
        requestBuffer.reset();
        requestBuffer.putInt(packetLen);
        this.socket.getOutputStream().write(requestBuffer.array(), 0, headerLen);
        this.socket.getOutputStream().flush();
        this.readResponse();
    }

    private void readResponse() throws IOException {
        this.scratchBuffer.clear();
        this.socket.getInputStream().read(this.scratchBuffer.array(), 0, 4);
        int len = this.scratchBuffer.getInt() & Integer.MAX_VALUE;
        if (len < 8) {
            throw new IOException("Received short or truncated response from row service. Aborting.");
        }
        this.socket.getInputStream().read(this.scratchBuffer.array(), 4, len);
        int status = this.scratchBuffer.getInt();
        if (status != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Row service returned error code: '");
            sb.append(status);
            sb.append("'");
            if (len - 4 > 0) {
                byte[] bytes = new byte[this.scratchBuffer.remaining()];
                this.scratchBuffer.get(bytes);
                sb.append(" Message: '");
                sb.append(new String(bytes));
                sb.append("'");
            }
            sb.append(" - Aborting.");
            throw new IOException(sb.toString());
        }
        this.handle = this.scratchBuffer.getInt();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.socket.close();
    }

    @Override
    public void flush() throws IOException {
        this.socket.getOutputStream().flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        String request = "{ \"format\" : \"binary\", \"handle\" : \"" + this.handle + "\" }";
        byte[] jsonRequestData = request.getBytes("ISO-8859-1");
        this.scratchBuffer.clear();
        this.scratchBuffer.mark();
        this.scratchBuffer.putInt(0);
        this.scratchBuffer.put((byte)45);
        this.scratchBuffer.putInt(jsonRequestData.length);
        this.scratchBuffer.put(jsonRequestData);
        int rowDataLen = len;
        this.scratchBuffer.putInt(rowDataLen);
        int headerLen = this.scratchBuffer.position();
        int packetLen = headerLen + len - 4;
        this.scratchBuffer.reset();
        this.scratchBuffer.putInt(packetLen);
        this.socket.getOutputStream().write(this.scratchBuffer.array(), 0, headerLen);
        this.socket.getOutputStream().write(b, off, len);
        this.socket.getOutputStream().flush();
        this.readResponse();
    }

    @Override
    public void write(int b) throws IOException {
        this.scratchBuffer.array()[0] = (byte)b;
        this.write(this.scratchBuffer.array(), 0, 1);
    }
}

