/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.hpccsystems.commons.ecl.FieldFilter;
import org.hpccsystems.commons.ecl.FieldFilterRange;
import org.hpccsystems.commons.ecl.FileFilter;

public class FileFilterConverter {
    private static final Logger log = LogManager.getLogger(FileFilterConverter.class);
    private static final long serialVersionUID = 1L;

    public static FileFilter CovertToHPCCFileFilter(Filter[] sparkfilters) throws Exception {
        FileFilter hpccFilters = new FileFilter();
        for (Filter sparkfilter : sparkfilters) {
            hpccFilters.andFilter(FileFilterConverter.ConvertToHPCCFileFilterString(sparkfilter));
        }
        return hpccFilters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileFilter ConvertToHPCCFileFilterString(Filter sparkfilter) throws Exception {
        FileFilter hpccfilter = new FileFilter();
        if (sparkfilter instanceof EqualTo) {
            EqualTo eqtofilter = (EqualTo)sparkfilter;
            hpccfilter = new FileFilter(new FieldFilter(eqtofilter.attribute(), FieldFilterRange.makeEq(eqtofilter.value())));
        } else if (sparkfilter instanceof EqualNullSafe) {
            EqualNullSafe eqnullsafefilter = (EqualNullSafe)sparkfilter;
            hpccfilter = new FileFilter(new FieldFilter(eqnullsafefilter.attribute(), FieldFilterRange.makeEq(eqnullsafefilter.value())));
        } else if (sparkfilter instanceof And) {
            And andfilter = (And)sparkfilter;
            hpccfilter = new FileFilter(FileFilterConverter.ConvertToHPCCFileFilterString(andfilter.left()));
            hpccfilter.andFilter(FileFilterConverter.ConvertToHPCCFileFilterString(andfilter.right()));
        } else if (sparkfilter instanceof GreaterThan) {
            GreaterThan gtfilter = (GreaterThan)sparkfilter;
            hpccfilter = new FileFilter(new FieldFilter(gtfilter.attribute(), FieldFilterRange.makeGT(gtfilter.value())));
        } else if (sparkfilter instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual gtefilter = (GreaterThanOrEqual)sparkfilter;
            hpccfilter = new FileFilter(new FieldFilter(gtefilter.attribute(), FieldFilterRange.makeGE(gtefilter.value())));
        } else if (sparkfilter instanceof In) {
            In infilter = (In)sparkfilter;
            hpccfilter = new FileFilter(new FieldFilter(infilter.attribute(), FieldFilterRange.makeIn(infilter.values())));
        } else if (sparkfilter instanceof IsNotNull) {
            IsNotNull wildfilter = (IsNotNull)sparkfilter;
            hpccfilter = new FileFilter(new FieldFilter(wildfilter.attribute()));
            log.info("Filter 'IsNotNull' ignored -- No concept of NULL in HPCC/ECL");
        } else {
            if (sparkfilter instanceof IsNull) {
                throw new UnsupportedOperationException("Filter 'IsNull' not supported");
            }
            if (sparkfilter instanceof LessThan) {
                LessThan ltfilter = (LessThan)sparkfilter;
                hpccfilter = new FileFilter(new FieldFilter(ltfilter.attribute(), FieldFilterRange.makeLT(ltfilter.value())));
            } else if (sparkfilter instanceof LessThanOrEqual) {
                LessThan ltefilter = (LessThan)sparkfilter;
                hpccfilter = new FileFilter(new FieldFilter(ltefilter.attribute(), FieldFilterRange.makeLE(ltefilter.value())));
            } else if (sparkfilter instanceof Not) {
                Not notfilter = (Not)sparkfilter;
                Filter child = notfilter.child();
                if (child instanceof EqualTo) {
                    EqualTo eqfilter = (EqualTo)child;
                    hpccfilter = new FileFilter(new FieldFilter(eqfilter.attribute(), FieldFilterRange.makeNE(eqfilter.value())));
                } else if (child instanceof EqualNullSafe) {
                    EqualNullSafe filter = (EqualNullSafe)child;
                    hpccfilter = new FileFilter(new FieldFilter(filter.attribute(), FieldFilterRange.makeNE(filter.value())));
                } else if (child instanceof GreaterThan) {
                    GreaterThan filter = (GreaterThan)child;
                    hpccfilter = new FileFilter(new FieldFilter(filter.attribute(), FieldFilterRange.makeLE(filter.value())));
                } else if (child instanceof GreaterThanOrEqual) {
                    GreaterThanOrEqual filter = (GreaterThanOrEqual)child;
                    hpccfilter = new FileFilter(new FieldFilter(filter.attribute(), FieldFilterRange.makeLT(filter.value())));
                } else if (child instanceof LessThan) {
                    LessThan filter = (LessThan)child;
                    hpccfilter = new FileFilter(new FieldFilter(filter.attribute(), FieldFilterRange.makeGE(filter.value())));
                } else {
                    if (!(child instanceof LessThanOrEqual)) throw new UnsupportedOperationException("Filter 'Not' not supported");
                    LessThanOrEqual filter = (LessThanOrEqual)child;
                    hpccfilter = new FileFilter(new FieldFilter(filter.attribute(), FieldFilterRange.makeGT(filter.value())));
                }
            } else if (sparkfilter instanceof Or) {
                Or orfilter = (Or)sparkfilter;
                hpccfilter = new FileFilter(FileFilterConverter.ConvertToHPCCFileFilterString(orfilter.left()));
                hpccfilter.orFilter(FileFilterConverter.ConvertToHPCCFileFilterString(orfilter.right()));
            } else {
                if (sparkfilter instanceof StringContains) {
                    throw new UnsupportedOperationException("Filter 'StringContains' not supported");
                }
                if (sparkfilter instanceof StringEndsWith) {
                    throw new UnsupportedOperationException("Filter 'StringEndsWith' not supported");
                }
                if (sparkfilter instanceof StringStartsWith) {
                    StringStartsWith strstartswithfilter = (StringStartsWith)sparkfilter;
                    String value = strstartswithfilter.value();
                    FieldFilterRange substring = FieldFilterRange.makeStartsWith(value, (short)value.length());
                    hpccfilter = new FileFilter(new FieldFilter(strstartswithfilter.attribute(), new FieldFilterRange[]{substring}));
                }
            }
        }
        log.debug("Converted SPARK filter: '" + sparkfilter.toString() + "' to HPCC filter: '" + hpccfilter);
        return hpccfilter;
    }
}

