/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark;

import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.dfs.client.IRecordAccessor;
import org.hpccsystems.spark.SparkSchemaTranslator;

public class GenericRowRecordAccessor
implements IRecordAccessor {
    private GenericRowWithSchema row = null;
    private FieldDef fieldDef = null;
    private GenericRowRecordAccessor[] childRecordAccessors = null;

    public GenericRowRecordAccessor(StructType schema) throws IllegalArgumentException {
        try {
            this.fieldDef = SparkSchemaTranslator.toHPCCRecordDef(schema);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public GenericRowRecordAccessor(FieldDef fieldDef) {
        this.fieldDef = fieldDef;
        this.childRecordAccessors = new GenericRowRecordAccessor[this.fieldDef.getNumDefs()];
        for (int i = 0; i < this.fieldDef.getNumDefs(); ++i) {
            boolean needsChildRecordAccessor;
            FieldDef fd = this.fieldDef.getDef(i);
            boolean bl = needsChildRecordAccessor = fd.getFieldType() == FieldType.RECORD || fd.getFieldType() == FieldType.DATASET && fd.getDef(0).getFieldType() == FieldType.RECORD;
            if (needsChildRecordAccessor) {
                FieldDef subFd = fd;
                if (fd.getFieldType() == FieldType.DATASET) {
                    subFd = fd.getDef(0);
                }
                this.childRecordAccessors[i] = new GenericRowRecordAccessor(subFd);
                continue;
            }
            this.childRecordAccessors[i] = null;
        }
    }

    @Override
    public IRecordAccessor setRecord(Object rd) {
        this.row = (GenericRowWithSchema)rd;
        return this;
    }

    @Override
    public int getNumFields() {
        return this.fieldDef.getNumDefs();
    }

    @Override
    public Object getFieldValue(int index) {
        return this.row.get(index);
    }

    @Override
    public FieldDef getFieldDefinition(int index) {
        return this.fieldDef.getDef(index);
    }

    @Override
    public IRecordAccessor getChildRecordAccessor(int index) {
        return this.childRecordAccessors[index];
    }
}

