/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark;

import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.dfs.client.IRecordBuilder;
import org.hpccsystems.spark.SparkSchemaTranslator;

public class GenericRowRecordBuilder
implements IRecordBuilder {
    private Object[] fields = null;
    private FieldDef fieldDef = null;
    private StructType schema = null;
    private GenericRowRecordBuilder[] childRecordBuilders = null;

    public GenericRowRecordBuilder(FieldDef recordDef) throws IllegalArgumentException {
        this.setRecordDefinition(recordDef);
    }

    @Override
    public void setRecordDefinition(FieldDef fieldDef) throws IllegalArgumentException {
        this.fieldDef = fieldDef;
        try {
            this.schema = SparkSchemaTranslator.toSparkSchema(fieldDef);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.childRecordBuilders = new GenericRowRecordBuilder[this.fieldDef.getNumDefs()];
        for (int i = 0; i < this.fieldDef.getNumDefs(); ++i) {
            boolean needsChildRecordBuilder;
            FieldDef fd = this.fieldDef.getDef(i);
            boolean bl = needsChildRecordBuilder = fd.getFieldType() == FieldType.RECORD || fd.getFieldType() == FieldType.DATASET && fd.getDef(0).getFieldType() == FieldType.RECORD;
            if (needsChildRecordBuilder) {
                FieldDef subFd = fd;
                if (fd.getFieldType() == FieldType.DATASET) {
                    subFd = fd.getDef(0);
                }
                this.childRecordBuilders[i] = new GenericRowRecordBuilder(subFd);
                continue;
            }
            this.childRecordBuilders[i] = null;
        }
    }

    @Override
    public FieldDef getRecordDefinition() {
        return this.fieldDef;
    }

    @Override
    public void startRecord() throws InstantiationException {
        this.fields = new Object[this.fieldDef.getNumDefs()];
    }

    @Override
    public Object finalizeRecord() throws InstantiationException {
        GenericRowWithSchema row = new GenericRowWithSchema(this.fields, this.schema);
        this.fields = null;
        return row;
    }

    @Override
    public void setFieldValue(int index, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.fields[index] = value;
    }

    @Override
    public IRecordBuilder getChildRecordBuilder(int index) {
        return this.childRecordBuilders[index];
    }
}

