/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark;

import java.io.Serializable;
import java.net.MalformedURLException;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.python.EvaluatePython;
import org.apache.spark.sql.types.StructType;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.errors.HpccFileException;
import org.hpccsystems.dfs.client.DataPartition;
import org.hpccsystems.dfs.client.HPCCFile;
import org.hpccsystems.dfs.cluster.RemapInfo;
import org.hpccsystems.spark.HpccRDD;
import org.hpccsystems.spark.SparkSchemaTranslator;
import org.hpccsystems.ws.client.utils.Connection;

public class HpccFile
extends HPCCFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int recordLimit = -1;

    public HpccFile(String fileName, Connection espconninfo) throws HpccFileException {
        super(fileName, espconninfo);
    }

    public HpccFile(String fileName, String connectionString, String user, String pass) throws MalformedURLException, HpccFileException {
        super(fileName, connectionString, user, pass);
    }

    public HpccFile(String fileName, Connection espconninfo, String targetColumnList, String filter, RemapInfo remap_info, int maxParts, String targetfilecluster) throws HpccFileException {
        super(fileName, espconninfo, targetColumnList, filter, remap_info, maxParts, targetfilecluster);
    }

    public void setFilePartRecordLimit(int limit) {
        this.recordLimit = limit;
    }

    public int getFilePartRecordLimit() {
        return this.recordLimit;
    }

    public HpccRDD getRDD() throws HpccFileException {
        return this.getRDD(SparkContext.getOrCreate());
    }

    public HpccRDD getRDD(SparkContext sc) throws HpccFileException {
        return new HpccRDD(sc, this.getFileParts(), this.getRecordDefinition(), this.getProjectedRecordDefinition(), this.getFileAccessExpirySecs(), this.recordLimit);
    }

    public Dataset<Row> getDataframe(SparkSession session) throws HpccFileException {
        FieldDef originalRD = this.getRecordDefinition();
        FieldDef projectedRD = this.getProjectedRecordDefinition();
        DataPartition[] fp = this.getFileParts();
        JavaRDD rdd = new HpccRDD(session.sparkContext(), fp, originalRD, projectedRD, this.getFileAccessExpirySecs(), this.recordLimit).toJavaRDD();
        StructType schema = null;
        try {
            schema = SparkSchemaTranslator.toSparkSchema(projectedRD);
        }
        catch (Exception e) {
            throw new HpccFileException(e.getMessage());
        }
        return session.createDataFrame(rdd, schema);
    }

    static {
        EvaluatePython.registerPicklers();
    }
}

