/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark;

import java.io.Serializable;
import java.util.Arrays;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.Unpickler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.python.EvaluatePython;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.dfs.client.DataPartition;
import org.hpccsystems.dfs.client.HpccRemoteFileReader;
import org.hpccsystems.spark.GenericRowRecordBuilder;
import org.hpccsystems.spark.RowConstructor;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public class HpccRDD
extends RDD<Row>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(HpccRDD.class);
    private static final ClassTag<Row> CT_RECORD = ClassTag$.MODULE$.apply(Row.class);
    public static int DEFAULT_CONNECTION_TIMEOUT = 120;
    private InternalPartition[] parts;
    private FieldDef originalRecordDef = null;
    private FieldDef projectedRecordDef = null;
    private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private int recordLimit = -1;

    private static void registerPicklingFunctions() {
        EvaluatePython.registerPicklers();
        Unpickler.registerConstructor((String)"pyspark.sql.types", (String)"Row", (IObjectConstructor)new RowConstructor());
        Unpickler.registerConstructor((String)"pyspark.sql.types", (String)"_create_row", (IObjectConstructor)new RowConstructor());
    }

    public HpccRDD(SparkContext sc, DataPartition[] dataParts, FieldDef originalRD) {
        this(sc, dataParts, originalRD, originalRD);
    }

    public HpccRDD(SparkContext sc, DataPartition[] dataParts, FieldDef originalRD, FieldDef projectedRD) {
        this(sc, dataParts, originalRD, projectedRD, DEFAULT_CONNECTION_TIMEOUT, -1);
    }

    public HpccRDD(SparkContext sc, DataPartition[] dataParts, FieldDef originalRD, FieldDef projectedRD, int connectTimeout, int limit) {
        super(sc, (Seq)new ArrayBuffer(), CT_RECORD);
        this.parts = new InternalPartition[dataParts.length];
        for (int i = 0; i < dataParts.length; ++i) {
            this.parts[i] = new InternalPartition();
            this.parts[i].partition = dataParts[i];
        }
        this.originalRecordDef = originalRD;
        this.projectedRecordDef = projectedRD;
        this.connectionTimeout = connectTimeout;
        this.recordLimit = limit;
    }

    public JavaRDD<Row> asJavaRDD() {
        JavaRDD jRDD = new JavaRDD((RDD)this, CT_RECORD);
        return jRDD;
    }

    public InterruptibleIterator<Row> compute(Partition p_arg, TaskContext ctx) {
        HpccRDD.registerPicklingFunctions();
        InternalPartition this_part = (InternalPartition)p_arg;
        FieldDef originalRD = this.originalRecordDef;
        FieldDef projectedRD = this.projectedRecordDef;
        if (originalRD == null) {
            log.error("Original record defintion is null. Aborting.");
            return null;
        }
        if (projectedRD == null) {
            log.error("Projected record defintion is null. Aborting.");
            return null;
        }
        Iterator iter = null;
        try {
            HpccRemoteFileReader fileReader = new HpccRemoteFileReader(this_part.partition, originalRD, new GenericRowRecordBuilder(projectedRD), this.connectionTimeout, this.recordLimit);
            ctx.addTaskCompletionListener(taskContext -> {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            iter = (Iterator)JavaConverters.asScalaIteratorConverter(fileReader).asScala();
        }
        catch (Exception e) {
            log.error("Failed to create remote file reader with error: " + e.getMessage());
            return null;
        }
        return new InterruptibleIterator(ctx, iter);
    }

    public Seq<String> getPreferredLocations(Partition split) {
        InternalPartition part = (InternalPartition)split;
        return ((Buffer)JavaConverters.asScalaBufferConverter(Arrays.asList(part.partition.getCopyLocations()[0])).asScala()).seq();
    }

    public Partition[] getPartitions() {
        return this.parts;
    }

    private class InternalPartition
    implements Partition {
        private static final long serialVersionUID = 1L;
        public DataPartition partition;

        private InternalPartition() {
        }

        public int hashCode() {
            return this.index();
        }

        public int index() {
            return this.partition.index();
        }
    }
}

