/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark;

import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.hpccsystems.commons.ecl.FieldDef;
import org.hpccsystems.commons.ecl.FieldType;
import org.hpccsystems.commons.ecl.HpccSrcType;

public class SparkSchemaTranslator {
    private static StructField toSchemaElement(FieldDef field) throws Exception {
        Metadata empty = Metadata.empty();
        boolean nullable = false;
        DataType type = DataTypes.NullType;
        switch (field.getFieldType()) {
            case VAR_STRING: 
            case STRING: 
            case CHAR: {
                type = DataTypes.StringType;
                break;
            }
            case INTEGER: {
                type = DataTypes.LongType;
                break;
            }
            case BINARY: {
                type = DataTypes.BinaryType;
                break;
            }
            case BOOLEAN: {
                type = DataTypes.BooleanType;
                break;
            }
            case REAL: {
                type = DataTypes.DoubleType;
                break;
            }
            case DECIMAL: {
                int precision = field.getPrecision();
                int scale = field.getScale();
                if (precision > DecimalType.MAX_PRECISION()) {
                    if ((scale -= precision - DecimalType.MAX_PRECISION()) < 0) {
                        scale = 0;
                    }
                    precision = DecimalType.MAX_PRECISION();
                }
                type = DataTypes.createDecimalType((int)precision, (int)scale);
                break;
            }
            case SET: 
            case DATASET: {
                StructField childField = SparkSchemaTranslator.toSchemaElement(field.getDef(0));
                type = DataTypes.createArrayType((DataType)childField.dataType());
                nullable = true;
                break;
            }
            case RECORD: {
                StructField[] childFields = new StructField[field.getNumDefs()];
                for (int i = 0; i < field.getNumDefs(); ++i) {
                    childFields[i] = SparkSchemaTranslator.toSchemaElement(field.getDef(i));
                }
                type = DataTypes.createStructType((StructField[])childFields);
                break;
            }
            case UNKNOWN: {
                type = DataTypes.NullType;
                throw new Exception("Conversion from HPCC FieldDef to Spark StructField failed. Encountered unknown type.");
            }
        }
        return new StructField(field.getFieldName(), type, nullable, empty);
    }

    public static StructType toSparkSchema(FieldDef recordDef) throws Exception {
        if (recordDef.getFieldType() != FieldType.RECORD) {
            return null;
        }
        StructField[] fields = new StructField[recordDef.getNumDefs()];
        for (int i = 0; i < recordDef.getNumDefs(); ++i) {
            fields[i] = SparkSchemaTranslator.toSchemaElement(recordDef.getDef(i));
        }
        return DataTypes.createStructType((StructField[])fields);
    }

    private static FieldDef toFieldDef(StructField sparkField) throws Exception {
        DataType type = sparkField.dataType();
        if (type instanceof ArrayType) {
            ArrayType array = (ArrayType)sparkField.dataType();
            StructField tempField = new StructField(sparkField.name(), array.elementType(), false, Metadata.empty());
            FieldDef[] childDef = new FieldDef[]{SparkSchemaTranslator.toFieldDef(tempField)};
            if (array.elementType() instanceof StructType) {
                return new FieldDef(sparkField.name(), FieldType.DATASET, "DATASET", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, childDef);
            }
            return new FieldDef(sparkField.name(), FieldType.SET, "SET", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, childDef);
        }
        if (type instanceof BinaryType) {
            return new FieldDef(sparkField.name(), FieldType.BINARY, "BINARY", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
        }
        if (type instanceof BooleanType) {
            return new FieldDef(sparkField.name(), FieldType.BOOLEAN, "BOOL", 1L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
        }
        if (type instanceof ByteType) {
            return new FieldDef(sparkField.name(), FieldType.INTEGER, "INTEGER1", 1L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
        }
        if (type instanceof DecimalType) {
            FieldDef ret = new FieldDef(sparkField.name(), FieldType.DECIMAL, "DECIMAL", 1L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
            DecimalType decimal = (DecimalType)type;
            ret.setPrecision(decimal.precision());
            ret.setScale(decimal.scale());
            return ret;
        }
        if (type instanceof DoubleType) {
            return new FieldDef(sparkField.name(), FieldType.REAL, "REAL8", 8L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
        }
        if (type instanceof FloatType) {
            return new FieldDef(sparkField.name(), FieldType.REAL, "REAL4", 4L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
        }
        if (type instanceof IntegerType) {
            return new FieldDef(sparkField.name(), FieldType.INTEGER, "INTEGER4", 4L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
        }
        if (type instanceof LongType) {
            return new FieldDef(sparkField.name(), FieldType.INTEGER, "INTEGER8", 8L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
        }
        if (type instanceof ShortType) {
            return new FieldDef(sparkField.name(), FieldType.INTEGER, "INTEGER2", 2L, true, false, HpccSrcType.LITTLE_ENDIAN, new FieldDef[0]);
        }
        if (type instanceof StringType) {
            return new FieldDef(sparkField.name(), FieldType.STRING, "UTF8", 0L, false, false, HpccSrcType.UTF8, new FieldDef[0]);
        }
        if (type instanceof StructType) {
            StructType schema = (StructType)type;
            StructField[] schemaFields = schema.fields();
            FieldDef[] children = new FieldDef[schemaFields.length];
            for (int i = 0; i < schemaFields.length; ++i) {
                children[i] = SparkSchemaTranslator.toFieldDef(schemaFields[i]);
            }
            return new FieldDef(sparkField.name(), FieldType.RECORD, "RECORD", 0L, false, false, HpccSrcType.LITTLE_ENDIAN, children);
        }
        throw new Exception("Conversion from Spark StuctField to HPCC FieldDef failed. Encountered unexpected type: " + type);
    }

    public static FieldDef toHPCCRecordDef(StructType schema) throws Exception {
        StructField tempField = new StructField("RootRecord", (DataType)schema, false, Metadata.empty());
        return SparkSchemaTranslator.toFieldDef(tempField);
    }
}

