/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark.datasource;

import java.util.TreeMap;
import org.hpccsystems.dfs.client.CompressionAlgorithm;
import org.hpccsystems.ws.client.utils.Connection;

public class HpccOptions {
    public Connection connectionInfo = null;
    public String clusterName = null;
    public String fileName = null;
    public String projectList = null;
    public CompressionAlgorithm compression = CompressionAlgorithm.DEFAULT;
    public String filterString = null;
    public int expirySeconds = 120;
    public int filePartLimit = -1;

    public HpccOptions(TreeMap<String, String> parameters) throws Exception {
        String connectionString = null;
        if (parameters.containsKey("host")) {
            connectionString = parameters.get("host");
        }
        String username = null;
        if (parameters.containsKey("username")) {
            username = parameters.get("username");
        }
        String password = null;
        if (parameters.containsKey("password")) {
            password = parameters.get("password");
        }
        this.connectionInfo = new Connection(connectionString);
        this.connectionInfo.setUserName(username);
        this.connectionInfo.setPassword(password);
        if (parameters.containsKey("path")) {
            this.fileName = parameters.get("path");
        }
        if (parameters.containsKey("cluster")) {
            this.clusterName = parameters.get("cluster");
        }
        if (parameters.containsKey("fileaccesstimeout")) {
            String timeoutStr = parameters.get("fileaccesstimeout");
            this.expirySeconds = Integer.parseInt(timeoutStr);
        }
        if (parameters.containsKey("limitperfilepart")) {
            String limitStr = parameters.get("limitperfilepart");
            this.filePartLimit = Integer.parseInt(limitStr);
        }
        if (parameters.containsKey("projectlist")) {
            this.projectList = parameters.get("projectlist");
        }
        this.compression = CompressionAlgorithm.DEFAULT;
        if (parameters.containsKey("compression")) {
            String compressionStr = parameters.get("compression");
            switch (compressionStr = compressionStr.toLowerCase()) {
                case "none": {
                    this.compression = CompressionAlgorithm.NONE;
                    break;
                }
                case "lz4": {
                    this.compression = CompressionAlgorithm.LZ4;
                    break;
                }
                case "flz": {
                    this.compression = CompressionAlgorithm.FLZ;
                    break;
                }
                case "lzw": {
                    this.compression = CompressionAlgorithm.LZW;
                    break;
                }
                default: {
                    this.compression = CompressionAlgorithm.DEFAULT;
                }
            }
        }
        if (parameters.containsKey("filter")) {
            this.filterString = parameters.get("filter");
        }
    }

    public String toString() {
        String tostring = "[Connection: '" + this.connectionInfo + "', clusterName: '" + this.clusterName;
        tostring = tostring + "', fileName: '" + this.fileName + "', projectList: '" + this.projectList + "', compression: '" + (Object)((Object)this.compression) + "',";
        tostring = tostring + "filterString: '" + this.filterString + "', expirySeconds: '" + this.expirySeconds + "', filePartLimit: '" + this.filePartLimit + "']";
        return tostring;
    }
}

