/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark.datasource;

import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.PrunedFilteredScan;
import org.apache.spark.sql.types.StructType;
import org.hpccsystems.commons.ecl.FileFilter;
import org.hpccsystems.spark.FileFilterConverter;
import org.hpccsystems.spark.HpccFile;
import org.hpccsystems.spark.HpccRDD;
import org.hpccsystems.spark.SparkSchemaTranslator;
import org.hpccsystems.spark.datasource.HpccOptions;

public class HpccRelation
extends BaseRelation
implements PrunedFilteredScan {
    private static Logger log = LogManager.getLogger(HpccRelation.class);
    private HpccFile file = null;
    private SQLContext sqlContext = null;
    private HpccOptions options = null;

    public HpccRelation(SQLContext context, HpccOptions opts) {
        this.sqlContext = context;
        this.options = opts;
    }

    public boolean needConversion() {
        return true;
    }

    public StructType schema() {
        if (this.file == null) {
            try {
                this.file = new HpccFile(this.options.fileName, this.options.connectionInfo);
                this.file.setFileAccessExpirySecs(this.options.expirySeconds);
                if (this.options.projectList != null) {
                    this.file.setProjectList(this.options.projectList);
                }
            }
            catch (Exception e) {
                String error = "Unable to create HpccRDD with error: " + e.getMessage();
                log.error(error);
                throw new RuntimeException(error);
            }
        }
        StructType schema = null;
        try {
            schema = SparkSchemaTranslator.toSparkSchema(this.file.getProjectedRecordDefinition());
        }
        catch (Exception e) {
            String error = "Unable to translate HPCC record defintion to Spark schema:" + e.getMessage();
            log.error(error);
            throw new RuntimeException(error);
        }
        return schema;
    }

    public long sizeInBytes() {
        return super.sizeInBytes();
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public Filter[] unhandledFilters(Filter[] filters) {
        ArrayList<Filter> unhandledFilters = new ArrayList<Filter>();
        for (Filter filter : filters) {
            try {
                FileFilter filefilter = FileFilterConverter.ConvertToHPCCFileFilterString(filter);
                if (filefilter != null && !filefilter.isEmpty()) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            unhandledFilters.add(filter);
        }
        return unhandledFilters.toArray(new Filter[0]);
    }

    public RDD<Row> buildScan(String[] requiredColumns, Filter[] filters) {
        String projectList = String.join((CharSequence)", ", requiredColumns);
        HpccRDD ret = null;
        try {
            if (this.file == null) {
                this.file = new HpccFile(this.options.fileName, this.options.connectionInfo);
                this.file.setFileAccessExpirySecs(this.options.expirySeconds);
            }
            if (filters != null && filters.length != 0) {
                try {
                    FileFilter filefilter = FileFilterConverter.CovertToHPCCFileFilter(filters);
                    if (filefilter != null && !filefilter.isEmpty()) {
                        this.file.setFilter(filefilter);
                    }
                }
                catch (Exception e) {
                    log.error("Could not apply filter(s) to File '" + this.file.getFileName() + "': " + e.getLocalizedMessage());
                }
            }
            this.file.setFilePartRecordLimit(this.options.filePartLimit);
            if (this.options.projectList != null) {
                projectList = this.options.projectList;
            }
            this.file.setProjectList(projectList);
            if (this.options.filterString != null) {
                this.file.setFilter(this.options.filterString);
            }
            ret = this.file.getRDD(this.sqlContext.sparkContext());
        }
        catch (Exception e) {
            String error = "Unable to create HpccRDD with error: " + e.getMessage();
            log.error(error);
            throw new RuntimeException(error);
        }
        return ret;
    }
}

