/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.spark.datasource;

import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.hpccsystems.spark.HpccFileWriter;
import org.hpccsystems.spark.datasource.HpccOptions;
import org.hpccsystems.spark.datasource.HpccRelation;
import scala.collection.JavaConversions;

public class HpccRelationProvider
implements RelationProvider,
CreatableRelationProvider,
DataSourceRegister {
    private static Logger log = LogManager.getLogger(HpccRelationProvider.class);

    public String shortName() {
        return "hpcc";
    }

    public BaseRelation createRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters) {
        HpccOptions options = null;
        try {
            options = this.extractOptions(parameters);
        }
        catch (Exception e) {
            String error = "Error while attempting to extract HpccOptions: " + e.getMessage();
            log.error(error);
            throw new RuntimeException(error);
        }
        return new HpccRelation(sqlContext, options);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> data) {
        boolean overwrite = false;
        if (mode == SaveMode.Append) {
            String error = "Append mode is not supported in HPCC.";
            log.error(error);
            throw new RuntimeException(error);
        }
        if (mode == SaveMode.Overwrite) {
            overwrite = true;
        }
        HpccOptions options = null;
        try {
            options = this.extractOptions(parameters);
        }
        catch (Exception e) {
            String error = "Error while attempting to extract HpccOptions: " + e.getMessage();
            log.error(error);
            throw new RuntimeException(error);
        }
        try {
            HpccFileWriter fileWriter = new HpccFileWriter(options.connectionInfo);
            fileWriter.saveToHPCC(sqlContext.sparkContext(), data.schema(), (JavaRDD<Row>)data.rdd().toJavaRDD(), options.clusterName, options.fileName, options.compression, overwrite);
            return this.createRelation(sqlContext, parameters);
        }
        catch (Exception e) {
            String error = "Unable to save file to HPCC with error: " + e.getMessage();
            log.error(error);
            throw new RuntimeException(error);
        }
    }

    private HpccOptions extractOptions(scala.collection.immutable.Map<String, String> scalaParams) throws Exception {
        Map parameters = JavaConversions.mapAsJavaMap(scalaParams);
        TreeMap<String, String> paramTreeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        paramTreeMap.putAll(parameters);
        HpccOptions options = new HpccOptions(paramTreeMap);
        return options;
    }
}

