/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import javax.activation.DataHandler;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.CreateFileRequest;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.CreateFileResponse;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.EspSoapFault;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.ReadFileDataRequest;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.ReadFileDataResponse;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.WriteFileDataRequest;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.WriteFileDataResponse;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.WsFileIOPingRequest;
import org.hpccsystems.ws.client.gen.axis2.wsfileio.v1_00.WsFileIOStub;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.EspSoapFaultWrapper;

public class HPCCWsFileIOClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsFileIOClient.class);
    public static final String FILEIOWSDLURI = "/WsFileIO";
    private final int defaultUploadChunkSize = 5000000;
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsFileIOClient.getServiceWSDLURL(new WsFileIOStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getServiceURI() {
        return FILEIOWSDLURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsFileIOClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsFileIOClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsFileIOStub();
    }

    public static HPCCWsFileIOClient get(Connection connection) {
        return new HPCCWsFileIOClient(connection);
    }

    public static HPCCWsFileIOClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsFileIOClient(conn);
    }

    public static HPCCWsFileIOClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsFileIOClient(conn);
    }

    protected HPCCWsFileIOClient(Connection baseConnection) {
        this.initWSFileIOStub(baseConnection);
    }

    private void initWSFileIOStub(Connection connection) {
        block3: {
            try {
                this.setActiveConnectionInfo(connection);
                this.stub = HPCCWsFileIOClient.setStubOptions(new WsFileIOStub(connection.getBaseUrl() + FILEIOWSDLURI), connection);
            }
            catch (AxisFault e) {
                log.error("Could not initialize FileIOStub- Review all HPCC connection values");
                e.printStackTrace();
            }
            catch (Exception e) {
                log.error("Could not initialize FileIOStub- Review all HPCC connection values");
                if (e.getLocalizedMessage().isEmpty()) break block3;
                this.initErrMessage = e.getLocalizedMessage();
                log.error(e.getLocalizedMessage());
            }
        }
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        WsFileIOPingRequest request = new WsFileIOPingRequest();
        try {
            ((WsFileIOStub)this.stub).ping(request);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public boolean createHPCCFile(String fileName, String targetLandingZone, boolean overwritefile) throws Exception, ArrayOfEspExceptionWrapper {
        boolean success = false;
        log.debug("Attempting to create HPCC File: " + fileName);
        this.verifyStub();
        CreateFileRequest request = new CreateFileRequest();
        request.setDestDropZone(targetLandingZone);
        request.setDestRelativePath(fileName);
        request.setOverwrite(overwritefile);
        CreateFileResponse resp = null;
        try {
            resp = ((WsFileIOStub)this.stub).createFile(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.createHPCCFile(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not createHPCCFile");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not createHPCCFile");
        }
        String result = resp.getResult();
        log.info(result);
        if (!result.startsWith("Fail")) {
            success = true;
        }
        return success;
    }

    public boolean writeHPCCFileData(byte[] data, String fileName, String targetLandingZone, boolean append, long offset, int uploadchunksize) throws Exception, ArrayOfEspExceptionWrapper {
        boolean success = true;
        log.debug("Attempting to write data to HPCC File: " + fileName);
        this.verifyStub();
        WriteFileDataRequest request = new WriteFileDataRequest();
        request.setAppend(append);
        request.setDestDropZone(targetLandingZone);
        request.setDestRelativePath(fileName);
        request.setOffset(offset);
        int dataindex = 0;
        int limit = uploadchunksize <= 0 ? 5000000 : uploadchunksize;
        int payloadsize = 0;
        int bytesleft = data.length;
        byte[] subdata = null;
        while (bytesleft > 0) {
            payloadsize = bytesleft >= limit ? limit : bytesleft;
            log.trace("Writing offset: " + dataindex + "\t size: " + payloadsize);
            subdata = Arrays.copyOfRange(data, dataindex, dataindex + payloadsize);
            ByteArrayDataSource ds = new ByteArrayDataSource(subdata);
            request.setData(new DataHandler(ds));
            request.setAppend((dataindex += payloadsize) > 0);
            request.setOffset(dataindex);
            try {
                WriteFileDataResponse response = ((WsFileIOStub)this.stub).writeFileData(request);
                if (response.getExceptions() != null) {
                    this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Failed to Write file");
                }
                String result = response.getResult();
                log.debug(result);
                if (!result.startsWith("Failed")) {
                    success = true;
                    bytesleft -= subdata.length;
                    continue;
                }
                bytesleft = 0;
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage());
                return false;
            }
        }
        return success;
    }

    public String readFileData(String dropzone, String fileName, long datasize, long offset) throws Exception, ArrayOfEspExceptionWrapper {
        String result;
        ReadFileDataRequest readFileDataRequest = new ReadFileDataRequest();
        readFileDataRequest.setDestDropZone(dropzone);
        readFileDataRequest.setDestRelativePath(fileName);
        readFileDataRequest.setDataSize(datasize);
        readFileDataRequest.setOffset(offset);
        ReadFileDataResponse resp = null;
        try {
            resp = ((WsFileIOStub)this.stub).readFileData(readFileDataRequest);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.readFileData(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not ReadFiledata");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not ReadFiledata");
        }
        if ((result = resp.getResult()) != null && !result.isEmpty() && !result.equals("ReadFileData done.")) {
            throw new EspSoapFault("HPCCWsFileIOClient.readfiledata error received: " + result);
        }
        String data = null;
        DataHandler handler = resp.getData();
        if (handler != null) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            handler.writeTo(output);
            data = output.toString();
        }
        return data;
    }
}

