/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.ActivatePackageRequest;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.ActivatePackageResponse;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.AddPackageRequest;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.AddPackageResponse;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.ArrayOfPackageListMapData;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.DeletePackageRequest;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.DeletePackageResponse;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.EspSoapFault;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.GetPackageMapByIdRequest;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.GetPackageMapByIdResponse;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.GetPackageRequest;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.GetPackageResponse;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.ListPackagesRequest;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.ListPackagesResponse;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.RemovePartFromPackageMapRequest;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.RemovePartFromPackageMapResponse;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.WsPackageProcessPingRequest;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.WsPackageProcessStub;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.EspSoapFaultWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wspackageprocess.AddPackageRequestWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wspackageprocess.BasePackageStatusWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wspackageprocess.DeletePackageRequestWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wspackageprocess.PackageListMapDataWrapper;

public class HPCCWsPackageProcessClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsPackageProcessClient.class);
    public static final String PACKAGEPROCESSURI = "/WsPackageProcess";
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsPackageProcessClient.getServiceWSDLURL(new WsPackageProcessStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getServiceURI() {
        return PACKAGEPROCESSURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsPackageProcessClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsPackageProcessClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    public static HPCCWsPackageProcessClient get(Connection connection) {
        return new HPCCWsPackageProcessClient(connection);
    }

    protected HPCCWsPackageProcessClient(Connection baseConnection) {
        this.initWSPackageProcessStub(baseConnection);
    }

    protected HPCCWsPackageProcessClient(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        this.initWSPackageProcessStub(conn);
    }

    protected HPCCWsPackageProcessClient(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        this.initWSPackageProcessStub(conn);
    }

    private void initWSPackageProcessStub(Connection conn) {
        block2: {
            try {
                this.setActiveConnectionInfo(conn);
                this.stub = HPCCWsPackageProcessClient.setStubOptions(new WsPackageProcessStub(conn.getBaseUrl() + PACKAGEPROCESSURI), conn);
            }
            catch (Exception e) {
                log.error("Could not initialize WsPackageProcessStub - Review all HPCC connection values");
                if (e.getLocalizedMessage().isEmpty()) break block2;
                this.initErrMessage = e.getLocalizedMessage();
                log.error(e.getLocalizedMessage());
            }
        }
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        WsPackageProcessPingRequest request = new WsPackageProcessPingRequest();
        try {
            ((WsPackageProcessStub)this.stub).ping(request);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public AddPackageResponse addPackage(String packageMapID, String packageMapContent, String targetCluster, String daliip) throws Exception {
        return this.addPackage(packageMapID, packageMapContent, targetCluster, null, null, null, daliip, null, null, null, null, null, null, null, null);
    }

    public AddPackageResponse addPackage(String packageMapID, String packageMapContent, String targetCluster, String daliip, Boolean overwrite) throws Exception {
        return this.addPackage(packageMapID, packageMapContent, targetCluster, null, null, null, daliip, null, overwrite, null, null, null, null, null, null);
    }

    public AddPackageResponse addPackage(String packageMapID, String packageMapContent, String targetCluster, String daliip, Boolean overwrite, Boolean active) throws Exception {
        return this.addPackage(packageMapID, packageMapContent, targetCluster, active, null, null, daliip, null, overwrite, null, null, null, null, null, null);
    }

    public AddPackageResponse addPackage(String packageMapID, String packageMapContent, String targetCluster, Boolean active, Boolean allowforeignfiles, Boolean appendcluster, String daliip, Boolean globalscope, Boolean overwrite, Boolean preloadallpackages, String process, Boolean replacepackagemap, String sourceprocess, Boolean updateclonefrom, Boolean updatesuperfiles) throws Exception {
        this.verifyStub();
        AddPackageRequest req = new AddPackageRequest();
        if (packageMapID != null) {
            req.setPackageMap(packageMapID);
        }
        if (packageMapContent != null) {
            req.setInfo(packageMapContent);
        }
        if (targetCluster != null) {
            req.setTarget(targetCluster);
        }
        if (active != null) {
            req.setActivate(active);
        }
        if (allowforeignfiles != null) {
            req.setAllowForeignFiles(allowforeignfiles);
        }
        if (appendcluster != null) {
            req.setAppendCluster(appendcluster);
        }
        if (daliip != null) {
            req.setDaliIp(daliip);
        }
        if (globalscope != null) {
            req.setGlobalScope(globalscope);
        }
        if (overwrite != null) {
            req.setOverWrite(overwrite);
        }
        if (preloadallpackages != null) {
            req.setPreloadAllPackages(preloadallpackages);
        }
        AddPackageResponse resp = null;
        try {
            resp = ((WsPackageProcessStub)this.stub).addPackage(req);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.addPackage(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform addPackage");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not addPackage");
        }
        return resp;
    }

    public AddPackageResponse addPackage(AddPackageRequestWrapper reqwrapper) throws Exception {
        this.verifyStub();
        AddPackageRequest req = new AddPackageRequest();
        req.setActivate(reqwrapper.getActivate());
        req.setAllowForeignFiles(reqwrapper.getAllowForeignFiles());
        req.setAppendCluster(reqwrapper.getAppendCluster());
        req.setDaliIp(reqwrapper.getDaliIp());
        req.setGlobalScope(reqwrapper.getGlobalScope());
        req.setInfo(reqwrapper.getInfo());
        req.setOverWrite(reqwrapper.getOverWrite());
        req.setPackageMap(reqwrapper.getPackageMap());
        req.setPreloadAllPackages(reqwrapper.getPreloadAllPackages());
        req.setProcess(reqwrapper.getProcess());
        req.setReplacePackageMap(reqwrapper.getReplacePackageMap());
        req.setSourceProcess(reqwrapper.getSourceProcess());
        req.setTarget(reqwrapper.getTarget());
        req.setUpdateCloneFrom(reqwrapper.getUpdateCloneFrom());
        req.setUpdateSuperFiles(reqwrapper.getUpdateSuperFiles());
        AddPackageResponse resp = null;
        try {
            resp = ((WsPackageProcessStub)this.stub).addPackage(req);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.addPackage(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform addPackage");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not addPackage");
        }
        return resp;
    }

    public DeletePackageResponse deletePackage(String packageMapID, String targetcluster) throws Exception {
        return this.deletePackage(packageMapID, targetcluster, "*");
    }

    public DeletePackageResponse deletePackage(String packageMapID, String targetcluster, String process) throws Exception {
        return this.deletePackage(packageMapID, targetcluster, process, null);
    }

    public DeletePackageResponse deletePackage(String packageMapID, String targetcluster, String process, Boolean globalscope) throws Exception {
        this.verifyStub();
        DeletePackageRequest req = new DeletePackageRequest();
        if (packageMapID != null) {
            req.setPackageMap(packageMapID);
        }
        if (targetcluster != null) {
            req.setTarget(targetcluster);
        }
        if (process != null) {
            req.setProcess(process);
        }
        if (globalscope != null) {
            req.setGlobalScope(globalscope);
        }
        DeletePackageResponse resp = null;
        try {
            resp = ((WsPackageProcessStub)this.stub).deletePackage(req);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.deletePackage(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform deletePackage(" + req.getPackageMap() + ")");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not deletePackage");
        }
        return resp;
    }

    public DeletePackageResponse deletePackage(DeletePackageRequestWrapper reqwrapper) throws Exception {
        this.verifyStub();
        DeletePackageRequest req = new DeletePackageRequest();
        req.setPackageMap(reqwrapper.getPackageMap());
        req.setGlobalScope(reqwrapper.getGlobalScope());
        req.setProcess(reqwrapper.getProcess());
        req.setTarget(reqwrapper.getTarget());
        DeletePackageResponse resp = null;
        try {
            resp = ((WsPackageProcessStub)this.stub).deletePackage(req);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.deletePackage(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform deletePackage(" + req.getPackageMap() + ")");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not deletePackage");
        }
        return resp;
    }

    public String getPackageMapById(String packageMapName) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        GetPackageMapByIdRequest req = new GetPackageMapByIdRequest();
        req.setPackageMapId(packageMapName);
        GetPackageMapByIdResponse resp = null;
        try {
            resp = ((WsPackageProcessStub)this.stub).getPackageMapById(req);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.getPackageMapById(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getPackageMapById");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not get packagemap " + packageMapName);
        }
        return resp.getInfo();
    }

    public BasePackageStatusWrapper activatePackage(boolean globalScope, String packageMapName, String process, String target) throws Exception, ArrayOfEspExceptionWrapper {
        log.debug("Attempting to activate package: " + packageMapName);
        this.verifyStub();
        ActivatePackageRequest request = new ActivatePackageRequest();
        request.setGlobalScope(globalScope);
        request.setPackageMap(packageMapName);
        request.setProcess(process);
        request.setTarget(target);
        ActivatePackageResponse resp = null;
        try {
            resp = ((WsPackageProcessStub)this.stub).activatePackage(request);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.activatePackage(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform activatePackage");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not perform activatePackage");
        }
        if (resp.getStatus() != null) {
            return new BasePackageStatusWrapper(resp.getStatus());
        }
        return null;
    }

    public BasePackageStatusWrapper getPackage(String process, String target) throws Exception, ArrayOfEspExceptionWrapper {
        log.debug("Attempting to fetch package process: " + process + " target: " + target);
        this.verifyStub();
        GetPackageRequest request = new GetPackageRequest();
        request.setProcess(process);
        request.setTarget(target);
        GetPackageResponse resp = null;
        try {
            resp = ((WsPackageProcessStub)this.stub).getPackage(request);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.getPackage(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getPackage");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not get package");
        }
        log.debug("Get Package info: " + resp.getInfo());
        if (resp.getStatus() != null) {
            return new BasePackageStatusWrapper(resp.getStatus());
        }
        return null;
    }

    public BasePackageStatusWrapper removePartFromPackageMap(boolean globalScope, String partName, String target, String packageMap) throws Exception {
        log.debug("Attempting to remove package part.");
        this.verifyStub();
        RemovePartFromPackageMapRequest request = new RemovePartFromPackageMapRequest();
        request.setGlobalScope(globalScope);
        request.setPartName(partName);
        request.setPackageMap(packageMap);
        request.setTarget(target);
        RemovePartFromPackageMapResponse resp = null;
        try {
            resp = ((WsPackageProcessStub)this.stub).removePartFromPackageMap(request);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.removePartFromPackageMap() encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could not remove package part.");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not Remove package part");
        }
        if (resp.getStatus() != null) {
            return new BasePackageStatusWrapper(resp.getStatus());
        }
        return null;
    }

    public List<PackageListMapDataWrapper> listPackages(String process, String target, String processFilter) throws Exception, ArrayOfEspExceptionWrapper {
        ArrayOfPackageListMapData packageMapList;
        log.debug("Attempting to list packages");
        this.verifyStub();
        List result = null;
        ListPackagesRequest request = new ListPackagesRequest();
        request.setProcess(process);
        request.setProcessFilter(processFilter);
        request.setTarget(target);
        ListPackagesResponse response = null;
        try {
            response = ((WsPackageProcessStub)this.stub).listPackages(request);
        }
        catch (RemoteException e) {
            throw new Exception("WsPackageProcessStub.listPackages() encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform list packages");
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not List packages");
        }
        if ((packageMapList = response.getPackageMapList()) != null) {
            result = Arrays.stream(packageMapList.getPackageListMapData()).map(PackageListMapDataWrapper::new).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsPackageProcessStub();
    }
}

