/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.extended;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.axis2.databinding.ADBBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.ArrayOfCheckinAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.ArrayOfCheckoutAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.ArrayOfDeleteAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.ArrayOfECLAttribute;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.ArrayOfRenameAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.ArrayOfSaveAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CheckinAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CheckinAttributes;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CheckoutAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CheckoutAttributes;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CreateAttribute;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CreateAttributeResponse;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.DeleteAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.DeleteAttributes;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.DeleteModule;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.DeleteModuleResponse;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.ECLAttribute;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.EspSoapFault;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.EspStringArray;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.FindAttributes;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.FindAttributesResponse;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.GetAttribute;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.GetAttributeResponse;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.GetAttributes;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.GetAttributesResponse;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.RenameAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.RenameAttributes;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.SaveAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.SaveAttributes;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.UpdateAttributesResponse;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.WsAttributesStub;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.ECLAttributeWrapper;
import org.hpccsystems.ws.client.wrappers.EspSoapFaultWrapper;
import org.hpccsystems.ws.client.wrappers.GetAttributesResponseWrapper;
import org.hpccsystems.ws.client.wrappers.GetAttributesWrapper;

public class HPCCWsAttributesClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsAttributesClient.class);
    public static final String WSATTRIBUTESWSDLURI = "/WsAttributes";
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsAttributesClient.getServiceWSDLURL(new WsAttributesStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getServiceURI() {
        return WSATTRIBUTESWSDLURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsAttributesClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsAttributesClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    public static HPCCWsAttributesClient get(Connection connection) {
        return new HPCCWsAttributesClient(connection);
    }

    public static HPCCWsAttributesClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsAttributesClient(conn);
    }

    public static HPCCWsAttributesClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsAttributesClient(conn);
    }

    protected HPCCWsAttributesClient(Connection baseConnection) {
        this.initWsAttributesClientStub(baseConnection);
    }

    private void initWsAttributesClientStub(Connection connection) {
        block3: {
            try {
                this.setActiveConnectionInfo(connection);
                this.stub = HPCCWsAttributesClient.setStubOptions(new WsAttributesStub(connection.getBaseUrl() + WSATTRIBUTESWSDLURI), connection);
            }
            catch (AxisFault e) {
                log.error("Could not initialize WsAttributesStub - Review all HPCC connection values");
                e.printStackTrace();
            }
            catch (Exception e) {
                log.error("Could not initialize WsAttributesStub - Review all HPCC connection values");
                if (e.getLocalizedMessage().isEmpty()) break block3;
                this.initErrMessage = e.getLocalizedMessage();
                log.error(e.getLocalizedMessage());
            }
        }
    }

    public boolean attributeExists(String modulename, String attributename, String type) throws Exception, ArrayOfEspExceptionWrapper {
        List<ECLAttributeWrapper> items = this.findItems(modulename, attributename, type, null, null, null);
        return items.size() > 0;
    }

    public List<ECLAttributeWrapper> findItems(String modulename, String attributename, String type, String username, String anytext, String changedSince) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        if (modulename == null && attributename == null && username == null && type == null && anytext == null && changedSince == null) {
            throw new Exception("At least one find criteria is required.");
        }
        FindAttributes params = new FindAttributes();
        if (modulename != null) {
            params.setModuleName(modulename);
        }
        if (attributename != null) {
            params.setAttributeName(attributename);
        }
        if (username != null) {
            params.setUserName(username);
        }
        if (type != null) {
            String[] types = type.split(",");
            EspStringArray typelist = new EspStringArray();
            typelist.setItem(types);
            params.setTypeList(typelist);
        }
        if (anytext != null) {
            params.setPattern(anytext);
        }
        FindAttributesResponse resp = null;
        try {
            resp = ((WsAttributesStub)this.stub).findAttributes(params);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsAttributesClient findItems encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform findItems");
        }
        ArrayList<ECLAttributeWrapper> results = new ArrayList<ECLAttributeWrapper>();
        if (resp != null) {
            if (resp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not perform findItems");
            }
            if (resp.getOutAttributes() != null) {
                ECLAttribute[] eclAttribute = resp.getOutAttributes().getECLAttribute();
                for (int i = 0; i < eclAttribute.length; ++i) {
                    results.add(new ECLAttributeWrapper(eclAttribute[i]));
                }
            }
        }
        return results;
    }

    public String getAttributeText(String modulename, String attributename, String type) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        GetAttribute params = new GetAttribute();
        params.setAttributeName(attributename);
        params.setModuleName(modulename);
        params.setType(type);
        params.setGetText(true);
        GetAttributeResponse response = null;
        try {
            response = ((WsAttributesStub)this.stub).getAttribute(params);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsAttributesClient getAttributeTest encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getAttributeText");
        }
        if (response != null) {
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not perform getAttributeText");
            }
            if (response.getOutAttribute() != null) {
                return response.getOutAttribute().getText();
            }
        }
        return null;
    }

    public ECLAttribute renameAttribute(String modulename, String attributename, String newmodulename, String newattributename) throws Exception, ArrayOfEspExceptionWrapper {
        if (modulename == null && newmodulename != null || newmodulename == null && modulename != null) {
            throw new Exception("If modulename or newmodulename is specified, both must be specified");
        }
        if (attributename == null && newattributename != null || newattributename == null && attributename != null) {
            throw new Exception("If attributename or newattributename is specified, both must be specified");
        }
        this.verifyStub();
        RenameAttributeRequest req = new RenameAttributeRequest();
        req.setAttributeName(attributename);
        req.setModuleName(modulename);
        req.setNewAttributeName(newattributename);
        req.setNewModuleName(newmodulename);
        RenameAttributes request = new RenameAttributes();
        ArrayOfRenameAttributeRequest arrayofrenameattributes = new ArrayOfRenameAttributeRequest();
        RenameAttributeRequest[] param = new RenameAttributeRequest[1];
        arrayofrenameattributes.setRenameAttributeRequest(param);
        request.setAttributes(arrayofrenameattributes);
        UpdateAttributesResponse response = null;
        try {
            response = ((WsAttributesStub)this.stub).renameAttributes(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsAttributesClient renameAttribute encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform renameAttribute");
        }
        if (response != null) {
            ECLAttribute[] eclAttributes;
            ArrayOfECLAttribute outAttributes;
            if (response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not perform renameAttribute");
            }
            if ((outAttributes = response.getOutAttributes()) != null && (eclAttributes = outAttributes.getECLAttribute()) != null && eclAttributes.length == 1) {
                return eclAttributes[0];
            }
        }
        return null;
    }

    public List<ECLAttributeWrapper> createOrUpdateAttributes(List<ECLAttributeWrapper> in, boolean checkoutin, String checkindesc) throws Exception, ArrayOfEspExceptionWrapper {
        ADBBean params;
        ADBBean resp;
        ArrayList<ECLAttributeWrapper> result = new ArrayList<ECLAttributeWrapper>();
        if (in == null || in.size() == 0) {
            return result;
        }
        if (checkoutin && (checkindesc == null || checkindesc.trim().length() == 0)) {
            throw new Exception("Checkin comment is required if checking attribute out / in");
        }
        String allers = "";
        for (ECLAttributeWrapper item : in) {
            try {
                item.validate();
            }
            catch (Exception e) {
                allers = allers + e.getMessage() + "\n";
            }
        }
        if (!allers.isEmpty()) {
            throw new Exception(allers);
        }
        HashMap founditems = new HashMap();
        ArrayList<CreateAttribute> tocreate = new ArrayList<CreateAttribute>();
        SaveAttributeRequest[] toupdate = new SaveAttributeRequest[in.size()];
        CheckoutAttributeRequest[] tocheckout = new CheckoutAttributeRequest[in.size()];
        CheckinAttributeRequest[] tocheckin = new CheckinAttributeRequest[in.size()];
        for (int i = 0; i < in.size(); ++i) {
            ECLAttributeWrapper item = in.get(i);
            if (!founditems.containsKey(item.getModuleName().toLowerCase())) {
                List<ECLAttributeWrapper> found = this.findItems(item.getModuleName(), null, null, null, null, null);
                ArrayList<String> cache = new ArrayList<String>();
                for (ECLAttributeWrapper f : found) {
                    cache.add(f.getUniqueName());
                }
                founditems.put(item.getModuleName().toLowerCase(), cache);
            }
            if (!((List)founditems.get(item.getModuleName().toLowerCase())).contains(item.getUniqueName())) {
                tocreate.add(item.toCreateAttribute());
            }
            toupdate[i] = item.toSaveAttributeRequest();
            tocheckout[i] = item.toCheckoutAttributeRequest();
            tocheckin[i] = item.toCheckinAttributeRequest(checkindesc);
        }
        this.verifyStub();
        for (CreateAttribute req : tocreate) {
            resp = ((WsAttributesStub)this.stub).createAttribute(req);
            if (resp != null && ((CreateAttributeResponse)resp).getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(((CreateAttributeResponse)resp).getExceptions()), "Could not create attribute(s)");
            }
            log.trace("Created " + req.getType() + " attribute " + req.getModuleName() + "." + req.getAttributeName());
        }
        if (checkoutin) {
            params = new CheckoutAttributes();
            ArrayOfCheckoutAttributeRequest tocheckoutatts = new ArrayOfCheckoutAttributeRequest();
            tocheckoutatts.setCheckoutAttributeRequest(tocheckout);
            ((CheckoutAttributes)params).setAttributes(tocheckoutatts);
            resp = ((WsAttributesStub)this.stub).checkoutAttributes((CheckoutAttributes)params);
            if (resp != null && ((UpdateAttributesResponse)resp).getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(((UpdateAttributesResponse)resp).getExceptions()));
            }
        }
        params = new SaveAttributes();
        ArrayOfSaveAttributeRequest toupdateatts = new ArrayOfSaveAttributeRequest();
        toupdateatts.setSaveAttributeRequest(toupdate);
        ((SaveAttributes)params).setAttributes(toupdateatts);
        resp = ((WsAttributesStub)this.stub).saveAttributes((SaveAttributes)params);
        if (resp != null) {
            ArrayOfECLAttribute outAttributes;
            if (resp != null && ((UpdateAttributesResponse)resp).getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(((UpdateAttributesResponse)resp).getExceptions()));
            }
            if ((outAttributes = ((UpdateAttributesResponse)resp).getOutAttributes()) != null) {
                ECLAttribute[] eclAttributes = outAttributes.getECLAttribute();
                for (int i = 0; i < eclAttributes.length; ++i) {
                    result.add(new ECLAttributeWrapper(eclAttributes[i]));
                }
            }
        }
        if (checkoutin) {
            CheckinAttributes inparams = new CheckinAttributes();
            ArrayOfCheckinAttributeRequest tocheckinatts = new ArrayOfCheckinAttributeRequest();
            tocheckinatts.setCheckinAttributeRequest(tocheckin);
            inparams.setAttributes(tocheckinatts);
            UpdateAttributesResponse upresp = ((WsAttributesStub)this.stub).checkinAttributes(inparams);
            if (upresp != null && upresp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(upresp.getExceptions()));
            }
        }
        return result;
    }

    public ECLAttributeWrapper createOrUpdateAttribute(ECLAttributeWrapper item, boolean checkoutin, String checkindesc) throws Exception, ArrayOfEspExceptionWrapper {
        if (item == null) {
            return null;
        }
        item.validate();
        if (checkoutin && (checkindesc == null || checkindesc.trim().length() == 0)) {
            throw new Exception("Checkin comment is required if checking attribute out / in");
        }
        this.verifyStub();
        if (!this.attributeExists(item.getModuleName(), item.getName(), item.getType())) {
            CreateAttributeResponse response = ((WsAttributesStub)this.stub).createAttribute(item.toCreateAttribute());
            if (response != null && response.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()));
            }
            log.trace("Created " + item.getType() + " attribute " + item.getModuleName() + "." + item.getName());
        }
        if (checkoutin) {
            this.checkoutAttribute(item.getModuleName(), item.getName());
        }
        SaveAttributeRequest[] arr = new SaveAttributeRequest[]{item.toSaveAttributeRequest()};
        SaveAttributes params = new SaveAttributes();
        ArrayOfSaveAttributeRequest arrayofattributes = new ArrayOfSaveAttributeRequest();
        arrayofattributes.setSaveAttributeRequest(arr);
        params.setAttributes(arrayofattributes);
        UpdateAttributesResponse resp = ((WsAttributesStub)this.stub).saveAttributes(params);
        log.trace("Updated text of " + item.getType() + " attribute " + item.getModuleName() + "." + item.getName());
        if (resp != null) {
            ECLAttribute[] eclAttributes;
            if (resp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()));
            }
            if (checkoutin) {
                this.checkinAttribute(item.getModuleName(), item.getName(), checkindesc);
            }
            if (resp.getOutAttributes() != null && (eclAttributes = resp.getOutAttributes().getECLAttribute()) != null && eclAttributes.length > 0) {
                return new ECLAttributeWrapper(eclAttributes[0]);
            }
        }
        return null;
    }

    public ECLAttribute updateAttribute(String modulename, String attributename, String type, String text, Boolean checkoutin, String checkindesc) throws Exception, ArrayOfEspExceptionWrapper {
        if (checkoutin == null) {
            checkoutin = false;
        }
        if (modulename == null || attributename == null || text == null) {
            throw new Exception("Module name, attribute name and text are required");
        }
        if (checkoutin.booleanValue() && (checkindesc == null || checkindesc.trim().length() == 0)) {
            throw new Exception("Checkin comment is required if checking attribute out / in");
        }
        if (!this.attributeExists(modulename, attributename, type)) {
            throw new FileNotFoundException("Cannot update " + modulename + "." + attributename + ", attribute does not exist");
        }
        this.verifyStub();
        if (checkoutin.booleanValue()) {
            this.checkoutAttribute(modulename, attributename);
        }
        SaveAttributeRequest req = new SaveAttributeRequest();
        req.setModuleName(modulename);
        req.setAttributeName(attributename);
        req.setText(text);
        SaveAttributeRequest[] arr = new SaveAttributeRequest[]{req};
        ArrayOfSaveAttributeRequest arrayofatts = new ArrayOfSaveAttributeRequest();
        arrayofatts.setSaveAttributeRequest(arr);
        SaveAttributes saveattributes = new SaveAttributes();
        saveattributes.setAttributes(arrayofatts);
        UpdateAttributesResponse resp = ((WsAttributesStub)this.stub).saveAttributes(saveattributes);
        if (resp != null) {
            ECLAttribute[] eclAttributes;
            if (resp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()));
            }
            if (checkoutin.booleanValue()) {
                this.checkinAttribute(modulename, attributename, checkindesc);
            }
            if (resp.getOutAttributes() != null && (eclAttributes = resp.getOutAttributes().getECLAttribute()) != null && eclAttributes.length > 0) {
                return eclAttributes[0];
            }
        }
        return null;
    }

    public ECLAttribute checkinAttribute(String modulename, String attributename, String checkindesc) throws Exception, ArrayOfEspExceptionWrapper {
        ECLAttribute[] eclAttributes;
        if (modulename == null || attributename == null) {
            throw new Exception("Module name and attribute name are required");
        }
        if (checkindesc == null || checkindesc.trim().length() == 0) {
            throw new Exception("Checkin comment is required if checking attribute out / in");
        }
        this.verifyStub();
        CheckinAttributeRequest req = new CheckinAttributeRequest();
        req.setAttributeName(attributename);
        req.setModuleName(modulename);
        req.setDescription(checkindesc);
        CheckinAttributeRequest[] arr = new CheckinAttributeRequest[]{req};
        CheckinAttributes params = new CheckinAttributes();
        ArrayOfCheckinAttributeRequest arrayofcheckinatts = new ArrayOfCheckinAttributeRequest();
        arrayofcheckinatts.setCheckinAttributeRequest(arr);
        params.setAttributes(arrayofcheckinatts);
        UpdateAttributesResponse response = ((WsAttributesStub)this.stub).checkinAttributes(params);
        if (response == null) {
            return null;
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()));
        }
        if (response.getOutAttributes() != null && (eclAttributes = response.getOutAttributes().getECLAttribute()) != null && eclAttributes.length > 0) {
            return eclAttributes[0];
        }
        return null;
    }

    public ECLAttribute checkoutAttribute(String modulename, String attributename) throws Exception, ArrayOfEspExceptionWrapper {
        ECLAttribute[] eclAttributes;
        if (modulename == null || attributename == null) {
            throw new Exception("Module name and attribute name are required");
        }
        this.verifyStub();
        CheckoutAttributeRequest req = new CheckoutAttributeRequest();
        req.setAttributeName(attributename);
        req.setModuleName(modulename);
        CheckoutAttributeRequest[] arr = new CheckoutAttributeRequest[]{req};
        CheckoutAttributes params = new CheckoutAttributes();
        ArrayOfCheckoutAttributeRequest arrayofCheckoutAtts = new ArrayOfCheckoutAttributeRequest();
        arrayofCheckoutAtts.setCheckoutAttributeRequest(arr);
        params.setAttributes(arrayofCheckoutAtts);
        UpdateAttributesResponse response = ((WsAttributesStub)this.stub).checkoutAttributes(params);
        if (response == null) {
            return null;
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()));
        }
        if (response.getOutAttributes() != null && (eclAttributes = response.getOutAttributes().getECLAttribute()) != null && eclAttributes.length > 0) {
            return eclAttributes[0];
        }
        return null;
    }

    public ECLAttribute createAttribute(String modulename, String attributename, String type, String text, Boolean checkin, String checkindesc) throws Exception, ArrayOfEspExceptionWrapper {
        if (checkin == null) {
            checkin = false;
        }
        if (modulename == null || attributename == null || text == null) {
            throw new Exception("Module name, attribute name and text are required");
        }
        if (checkin.booleanValue() && (checkindesc == null || checkindesc.trim().length() == 0)) {
            throw new Exception("Checkin comment is required if checking attribute in");
        }
        if (this.attributeExists(modulename, attributename, type)) {
            throw new Exception(modulename + "." + attributename + " already exists");
        }
        this.verifyStub();
        CreateAttribute req = new CreateAttribute();
        req.setModuleName(modulename);
        req.setAttributeName(attributename);
        req.setType(type);
        CreateAttributeResponse response = ((WsAttributesStub)this.stub).createAttribute(req);
        if (response == null) {
            return null;
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()));
        }
        ECLAttribute attr = this.updateAttribute(modulename, attributename, type, text, checkin, checkindesc);
        return attr;
    }

    public void deleteModule(String modulename) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DeleteModule parameters = new DeleteModule();
        parameters.setModuleName(modulename);
        DeleteModuleResponse response = ((WsAttributesStub)this.stub).deleteModule(parameters);
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()));
        }
    }

    public List<ECLAttributeWrapper> deleteAttribute(String modulename, String attributename) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DeleteAttributeRequest dar = new DeleteAttributeRequest();
        DeleteAttributes parameters = new DeleteAttributes();
        dar.setAttributeName(attributename);
        dar.setModuleName(modulename);
        DeleteAttributeRequest[] arr = new DeleteAttributeRequest[]{dar};
        ArrayOfDeleteAttributeRequest arrayofdeleteatts = new ArrayOfDeleteAttributeRequest();
        arrayofdeleteatts.setDeleteAttributeRequest(arr);
        parameters.setAttributes(arrayofdeleteatts);
        UpdateAttributesResponse resp = ((WsAttributesStub)this.stub).deleteAttributes(parameters);
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()));
        }
        ArrayList<ECLAttributeWrapper> results = new ArrayList<ECLAttributeWrapper>();
        if (resp.getOutAttributes() != null) {
            ECLAttribute[] arrayOfECLAttribute = resp.getOutAttributes().getECLAttribute();
            for (int i = 0; i < arrayOfECLAttribute.length; ++i) {
                results.add(new ECLAttributeWrapper(arrayOfECLAttribute[i]));
            }
        }
        return results;
    }

    public GetAttributesResponseWrapper getAttributes(String label, String modulename, EspStringArray typelist) throws Exception {
        GetAttributes request = new GetAttributes();
        request.setLabel(label);
        request.setModuleName(modulename);
        request.setTypeList(typelist);
        return this.getAttributes(new GetAttributesWrapper(request));
    }

    public GetAttributesResponseWrapper getAttributes(GetAttributesWrapper request) throws Exception {
        this.verifyStub();
        GetAttributesResponse response = null;
        try {
            response = ((WsAttributesStub)this.stub).getAttributes(request.getRaw());
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsAttributes.getAttributes() encountered RemoteException.", e);
        }
        if (response != null && response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not get attributes");
        }
        return new GetAttributesResponseWrapper(response);
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsAttributesStub();
    }
}

