/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.hpccsystems.ws.client.HPCCWsWorkUnitsClient;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_81.ECLResult;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_81.WUResultResponse;
import org.hpccsystems.ws.client.platform.Workunit;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.DatasetParser;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.wrappers.WUState;
import org.xml.sax.InputSource;

public class Result
extends DataSingleton {
    private static Map<Integer, Result> Results = new HashMap<Integer, Result>();
    private Workunit workunit;
    private ECLResult info;
    ResultData data;

    public static synchronized Result get(Workunit workunit, Integer sequence) {
        Result result = new Result(workunit, sequence);
        if (Results.containsKey(result.hashCode())) {
            return Results.get(result.hashCode());
        }
        Results.put(result.hashCode(), result);
        return result;
    }

    private Result(Workunit workunit, Integer sequence) {
        this.workunit = workunit;
        this.info = new ECLResult();
        this.info.setSequence(sequence);
        this.data = new ResultData();
        this.setChanged();
    }

    public Workunit getWorkunit() {
        return this.workunit;
    }

    public String getWuid() {
        return this.workunit.getWuid();
    }

    public Integer getSequence() {
        return this.info.getSequence();
    }

    public String getResultName() {
        return this.info.getName();
    }

    public String getName() {
        return this.info.getName();
    }

    public String getValue() {
        return this.info.getValue();
    }

    public WUState getStateID() {
        if (this.info.getTotal() != -1L) {
            return WUState.COMPLETED;
        }
        return WUState.UNKNOWN;
    }

    public Long getTotal() {
        return this.info.getTotal();
    }

    public String[] getResultViews() {
        return this.workunit.getResultViews();
    }

    @Override
    public boolean isComplete() {
        return HPCCWsWorkUnitsClient.isWorkunitComplete(this.getStateID()) || this.workunit.isComplete();
    }

    public int getColumnCount() {
        if (this.info.getECLSchemas() == null) {
            return 0;
        }
        return this.info.getECLSchemas().getECLSchemaItem().length;
    }

    public String getColumnName(int i) {
        if (this.info.getECLSchemas() == null) {
            return "";
        }
        return this.info.getECLSchemas().getECLSchemaItem()[i].getColumnName();
    }

    public String getCell(int row, int col) {
        return this.data.GetCell(row, col);
    }

    @Override
    protected void fastRefresh() {
        this.fullRefresh();
    }

    @Override
    protected void fullRefresh() {
        this.workunit.getResults();
    }

    boolean update(ECLResult result) {
        boolean retVal = false;
        if (result != null && this.info.getSequence() == result.getSequence() && !this.info.equals(result) && this.UpdateState(result)) {
            retVal = true;
            this.notifyObservers((Object)Notification.RESULT);
        }
        this.monitor();
        return retVal;
    }

    synchronized boolean UpdateState(ECLResult result) {
        if (result != null && this.info.getSequence() == result.getSequence() && EqualsUtil.hasChanged(this.info, result)) {
            assert (result.getECLSchemas() != null);
            this.info = result;
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Result)) {
            return false;
        }
        Result that = (Result)aThat;
        return EqualsUtil.areEqual(this.workunit, that.workunit) && EqualsUtil.areEqual(this.info.getSequence(), that.info.getSequence());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.workunit);
        result = HashCodeUtil.hash(result, this.info.getSequence());
        return result;
    }

    class ResultData {
        final int PAGE_SIZE = 180;
        final int PAGE_BEFORE = 60;
        Map<Long, Map<Integer, String>> data = new HashMap<Long, Map<Integer, String>>();

        ResultData() {
        }

        String GetCell(long row, int col) {
            int count;
            if (this.data.containsKey(row)) {
                return this.data.get(row).get(col);
            }
            Long start = row;
            for (int i = 0; i < 60 && start - 1L >= 0L && !this.data.containsKey(start - 1L); ++i) {
                start = start - 1L;
            }
            for (int i = count = (int)(row - start); i < 180 && !this.data.containsKey(start + (long)count); ++i) {
                ++count;
            }
            try {
                HPCCWsWorkUnitsClient wsWorkunitsClient = Result.this.workunit.getPlatform().getWsClient().getWsWorkunitsClient();
                WUResultResponse response = wsWorkunitsClient.fetchRawResults(Result.this.workunit.getWuid(), true, Result.this.info.getSequence(), null, true, start, count);
                String resultString = response.getResult();
                if (resultString != null && !resultString.isEmpty()) {
                    int offset = resultString.indexOf("<Dataset");
                    resultString = resultString.substring(offset);
                    new DatasetParser(response.getStart(), new InputSource(new StringReader(resultString)), this.data);
                    return this.data.get(row).get(col);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.data.get(row).get(col);
        }
    }

    public static enum Notification {
        RESULT;

    }
}

