/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private String versionString = "";
    private String project = "";
    private int major = -1;
    private int minor = -1;
    private int point = -1;
    private long sequence = -1L;
    private String maturity = "";
    private String tag = "";
    final String regex = "(?:(?<project>[a-zA-Z-]*)_)?(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<point>\\d+)(?:\\-(?<presequence>\\d+)?(?:(?<maturity>(?i)rc|trunk|closedown)?(?<postsequence>\\d+)?))?(?<tag>\\[.+\\])?";
    final Pattern pattern = Pattern.compile("(?:(?<project>[a-zA-Z-]*)_)?(?<major>\\d+)\\.(?<minor>\\d+)\\.(?<point>\\d+)(?:\\-(?<presequence>\\d+)?(?:(?<maturity>(?i)rc|trunk|closedown)?(?<postsequence>\\d+)?))?(?<tag>\\[.+\\])?", 8);
    public static final int OTHER_VERSION_IS_OLDER = -1;
    public static final int EQUIVALENT_VERSIONS = 0;
    public static final int OTHER_VERSION_IS_NEWER = 1;
    public static final int DISTANCE_SUFFIXINT = 100;
    public static final int DISTANCE_SUFFIXSTR = 1000;
    public static final int DISTANCE_POINT = 100000;
    public static final int DISTANCE_MINOR = 100000000;

    public Version(int major, int minor, int point) {
        this.major = major;
        this.minor = minor;
        this.point = point;
    }

    public Version(String versionString) {
        this.versionString = versionString;
        Matcher matcher = this.pattern.matcher(versionString);
        if (matcher.find()) {
            this.project = matcher.group(1);
            if (matcher.group(2) != null) {
                this.major = Integer.parseInt(matcher.group(2));
            }
            if (matcher.group(3) != null) {
                this.minor = Integer.parseInt(matcher.group(3));
            }
            if (matcher.group(4) != null) {
                this.point = Integer.parseInt(matcher.group(4));
            }
            this.maturity = matcher.group("maturity");
            if (this.maturity != null) {
                this.maturity = this.maturity.toLowerCase();
            }
            if (matcher.group("presequence") != null) {
                this.sequence = Long.parseLong(matcher.group("presequence"));
            }
            if (matcher.group("postsequence") != null) {
                if (this.sequence != -1L) {
                    System.err.println("Version: Invalid sequence detected in version string: " + versionString);
                }
                this.sequence = Long.parseLong(matcher.group("postsequence"));
            }
            if (matcher.group("tag") != null) {
                this.tag = matcher.group("tag");
            }
        }
    }

    public String getOriginalVersionString() {
        return this.versionString;
    }

    public String toString() {
        String reconstructedVerString = "";
        if (this.project != null && !this.project.isEmpty()) {
            reconstructedVerString = reconstructedVerString + this.project + "_";
        }
        reconstructedVerString = reconstructedVerString + this.major + "." + this.minor + "." + this.point;
        if (this.sequence > 0L || this.maturity != null && !this.maturity.isEmpty()) {
            reconstructedVerString = reconstructedVerString + "-";
            if (this.maturity != null) {
                reconstructedVerString = reconstructedVerString + this.maturity;
            }
            reconstructedVerString = reconstructedVerString + this.sequence;
        }
        if (this.tag != null) {
            reconstructedVerString = reconstructedVerString + this.tag;
        }
        return reconstructedVerString;
    }

    public boolean isEquivalentTo(int othermajor, int otherminor, int otherpoint) {
        return this.compareTo(othermajor, otherminor, otherpoint) == 0;
    }

    public boolean isOlderThan(int othermajor, int otherminor, int otherpoint) {
        return this.compareTo(othermajor, otherminor, otherpoint) == 1;
    }

    public boolean isNewerThan(int othermajor, int otherminor, int otherpoint) {
        return this.compareTo(othermajor, otherminor, otherpoint) == -1;
    }

    public boolean isEqualOrNewerThan(int othermajor, int otherminor, int otherpoint) {
        return this.compareTo(othermajor, otherminor, otherpoint) <= 0;
    }

    public boolean isEqualOrOlderThan(int othermajor, int otherminor, int otherpoint) {
        return this.compareTo(othermajor, otherminor, otherpoint) >= 0;
    }

    public int compareTo(int othermajor, int otherminor, int otherpoint) {
        if (othermajor < this.major) {
            return -1;
        }
        if (othermajor > this.major) {
            return 1;
        }
        if (otherminor < this.minor) {
            return -1;
        }
        if (otherminor > this.minor) {
            return 1;
        }
        if (otherpoint < this.point) {
            return -1;
        }
        if (otherpoint > this.point) {
            return 1;
        }
        return 0;
    }

    public boolean isEquivalentTo(Version other) {
        return this.compareTo(other.major, other.minor, other.point) == 0;
    }

    public boolean isOlderThan(Version other) {
        return this.compareTo(other.major, other.minor, other.point) == 1;
    }

    public boolean isNewerThan(Version other) {
        return this.compareTo(other.major, other.minor, other.point) == -1;
    }

    public boolean isEqualOrNewerThan(Version other) {
        return this.compareTo(other.major, other.minor, other.point) <= 0;
    }

    public boolean isEqualOrOlderThan(Version other) {
        return this.compareTo(other.major, other.minor, other.point) >= 0;
    }

    @Override
    public int compareTo(Version other) {
        if (other.major < this.major) {
            return -1;
        }
        if (other.major > this.major) {
            return 1;
        }
        if (other.minor < this.minor) {
            return -1;
        }
        if (other.minor > this.minor) {
            return 1;
        }
        if (other.point < this.point) {
            return -1;
        }
        if (other.point > this.point) {
            return 1;
        }
        if (!other.isGold() && this.isGold()) {
            return -1;
        }
        if (other.isGold() && !this.isGold()) {
            return 1;
        }
        if (other.maturity != this.maturity && !other.maturity.equals(this.maturity)) {
            if (other.maturity.equalsIgnoreCase("trunk")) {
                return -1;
            }
            if (this.maturity.equalsIgnoreCase("trunk")) {
                return 1;
            }
            if (other.maturity.equalsIgnoreCase("rc")) {
                return -1;
            }
            if (this.maturity.equalsIgnoreCase("rc")) {
                return 1;
            }
            if (other.maturity.equalsIgnoreCase("closedown")) {
                return -1;
            }
            if (this.maturity.equalsIgnoreCase("closedown")) {
                return 1;
            }
        }
        if (other.sequence < this.sequence) {
            return -1;
        }
        if (other.sequence > this.sequence) {
            return 1;
        }
        return 0;
    }

    public boolean isGold() {
        return this.maturity == null || this.maturity.isEmpty();
    }

    public static long distance(Version l, Version r) {
        long retVal = 0L;
        retVal += Math.abs(r.sequence - l.sequence);
        retVal += (long)(Math.abs(r.maturity.compareTo(l.maturity)) * 100);
        retVal += (long)(Math.abs(r.point - l.point) * 1000);
        retVal += (long)(Math.abs(r.minor - l.minor) * 100000);
        return retVal += (long)(Math.abs(r.major - l.major) * 100000000);
    }

    public String getPrefix() {
        return this.project;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPoint() {
        return this.point;
    }

    public String getMaturity() {
        return this.maturity;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getProject() {
        return this.project;
    }

    public String getTag() {
        return this.tag;
    }
}

