/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XRefNodeWrapper {
    private static final String NAME_TAG = "name";
    private static final String STATUS_TAG = "status";
    private static final String MODIFIED_TAG = "modified";
    protected String name = null;
    protected String modified = null;
    protected String status = null;

    public XRefNodeWrapper(String name, String modified, String status) {
        this.name = name;
        this.modified = modified;
        this.status = status;
    }

    public XRefNodeWrapper(Node xrefnode) {
        this.populatenode(xrefnode);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return this.name;
    }

    public String getModified() {
        return this.modified;
    }

    public String getStatus() {
        return this.status;
    }

    private void populatenode(Node currentNode) {
        if (currentNode != null) {
            try {
                NodeList currentChildren = currentNode.getChildNodes();
                for (int childindex = 0; childindex < currentChildren.getLength(); ++childindex) {
                    Node childNode = currentChildren.item(childindex);
                    String tagName = childNode.getNodeName();
                    if (tagName.equalsIgnoreCase(NAME_TAG)) {
                        this.setName(childNode.getTextContent());
                        continue;
                    }
                    if (tagName.equalsIgnoreCase(STATUS_TAG)) {
                        this.setStatus(childNode.getTextContent());
                        continue;
                    }
                    if (!tagName.equalsIgnoreCase(MODIFIED_TAG)) continue;
                    this.setModified(childNode.getTextContent());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "Name: " + this.name + " Modified: " + this.modified + " Status: " + this.status;
    }
}

