/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers.gen.wspackageprocess;

import java.util.ArrayList;
import java.util.List;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.EspStringArray;
import org.hpccsystems.ws.client.gen.axis2.wspackageprocess.v1_04.ValidateResult;
import org.hpccsystems.ws.client.wrappers.gen.wspackageprocess.ValidatePackageFilesWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wspackageprocess.ValidatePackageInfoWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wspackageprocess.ValidatePackageQueriesWrapper;

public class ValidateResultWrapper {
    protected String local_target;
    protected String local_pMID;
    protected List<String> local_warnings = null;
    protected List<String> local_errors = null;
    protected ValidatePackageInfoWrapper local_packages;
    protected ValidatePackageQueriesWrapper local_queries;
    protected ValidatePackageFilesWrapper local_files;

    public ValidateResultWrapper() {
    }

    public ValidateResultWrapper(ValidateResult validateresult) {
        this.copy(validateresult);
    }

    public ValidateResultWrapper(String _target, String _pMID, List<String> _warnings, List<String> _errors, ValidatePackageInfoWrapper _packages, ValidatePackageQueriesWrapper _queries, ValidatePackageFilesWrapper _files) {
        this.local_target = _target;
        this.local_pMID = _pMID;
        this.local_warnings = _warnings;
        this.local_errors = _errors;
        this.local_packages = _packages;
        this.local_queries = _queries;
        this.local_files = _files;
    }

    private void copy(ValidateResult raw) {
        int i;
        if (raw == null) {
            return;
        }
        this.local_target = raw.getTarget();
        this.local_pMID = raw.getPMID();
        if (raw.getWarnings() != null) {
            this.local_warnings = new ArrayList<String>();
            for (i = 0; i < raw.getWarnings().getItem().length; ++i) {
                this.local_warnings.add(new String(raw.getWarnings().getItem()[i]));
            }
        }
        if (raw.getErrors() != null) {
            this.local_errors = new ArrayList<String>();
            for (i = 0; i < raw.getErrors().getItem().length; ++i) {
                this.local_errors.add(new String(raw.getErrors().getItem()[i]));
            }
        }
        if (raw.getPackages() != null) {
            this.local_packages = new ValidatePackageInfoWrapper(raw.getPackages());
        }
        if (raw.getQueries() != null) {
            this.local_queries = new ValidatePackageQueriesWrapper(raw.getQueries());
        }
        if (raw.getFiles() != null) {
            this.local_files = new ValidatePackageFilesWrapper(raw.getFiles());
        }
    }

    public String toString() {
        return "ValidateResultWrapper [target = " + this.local_target + ", pMID = " + this.local_pMID + ", warnings = " + this.local_warnings + ", errors = " + this.local_errors + ", packages = " + this.local_packages + ", queries = " + this.local_queries + ", files = " + this.local_files + "]";
    }

    public ValidateResult getRaw() {
        int i;
        EspStringArray arr;
        ValidateResult raw = new ValidateResult();
        raw.setTarget(this.local_target);
        raw.setPMID(this.local_pMID);
        if (this.local_warnings != null) {
            arr = new EspStringArray();
            for (i = 0; i < this.local_warnings.size(); ++i) {
                arr.addItem(this.local_warnings.get(i));
            }
            raw.setWarnings(arr);
        }
        if (this.local_errors != null) {
            arr = new EspStringArray();
            for (i = 0; i < this.local_errors.size(); ++i) {
                arr.addItem(this.local_errors.get(i));
            }
            raw.setErrors(arr);
        }
        return raw;
    }

    public void setTarget(String _target) {
        this.local_target = _target;
    }

    public String getTarget() {
        return this.local_target;
    }

    public void setPMID(String _pMID) {
        this.local_pMID = _pMID;
    }

    public String getPMID() {
        return this.local_pMID;
    }

    public void setWarnings(List<String> _warnings) {
        this.local_warnings = _warnings;
    }

    public List<String> getWarnings() {
        return this.local_warnings;
    }

    public void setErrors(List<String> _errors) {
        this.local_errors = _errors;
    }

    public List<String> getErrors() {
        return this.local_errors;
    }

    public void setPackages(ValidatePackageInfoWrapper _packages) {
        this.local_packages = _packages;
    }

    public ValidatePackageInfoWrapper getPackages() {
        return this.local_packages;
    }

    public void setQueries(ValidatePackageQueriesWrapper _queries) {
        this.local_queries = _queries;
    }

    public ValidatePackageQueriesWrapper getQueries() {
        return this.local_queries;
    }

    public void setFiles(ValidatePackageFilesWrapper _files) {
        this.local_files = _files;
    }

    public ValidatePackageFilesWrapper getFiles() {
        return this.local_files;
    }
}

