/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.Stub;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.HPCCWsSMCClient;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUFileAccessRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUFileAccessRequestBase;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUFileCreateRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.EspStringArray;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.FileAccessRole;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.SecAccessType;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.WsDfuStub;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.AddtoSuperfileResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.ArrayOfDFUActionInfo;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.ArrayOfDFULogicalFile;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUActionInfo;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUArrayActionRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUArrayActionResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUArrayActions;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUBrowseDataRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUBrowseDataResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUDataColumn;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUFileAccessResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUFileAccessV2Request;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUFileCreateResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUFileCreateV2Request;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUFilePublishRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUFilePublishResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUFileViewRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUFileViewResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUGetDataColumnsRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUGetDataColumnsResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUGetFileMetaDataRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUGetFileMetaDataResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUInfoRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUInfoResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFULogicalFile;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUQueryRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUQueryResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUSearchDataRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.DFUSearchDataResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.EspSoapFault;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.SuperfileActionRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.SuperfileActionResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.SuperfileListRequest;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.SuperfileListResponse;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuPingRequest;
import org.hpccsystems.ws.client.platform.Version;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.EclRecordWrapper;
import org.hpccsystems.ws.client.wrappers.EspSoapFaultWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wsdfu.AddtoSuperfileRequestWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wsdfu.AddtoSuperfileResponseWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUCreateFileWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUDataColumnWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileAccessInfoWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileDetailWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileTypeWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUInfoWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFULogicalFileWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUResultWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.WsDFUClientStubWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class HPCCWsDFUClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsDFUClient.class);
    public static final String WSDFUURI = "/WsDFU/";
    public static final String ROW_ELEMENT = "Row";
    public static final String DATASET_ELEMENT = "Dataset";
    private WsDFUClientStubWrapper stubwrapper = null;
    private Options stuboptions = null;
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsDFUClient.getServiceWSDLURL(new org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    public static String getServiceURI() {
        return WSDFUURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsDFUClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsDFUClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub();
    }

    public static HPCCWsDFUClient get(Connection connection) {
        return new HPCCWsDFUClient(connection);
    }

    public static HPCCWsDFUClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsDFUClient(conn);
    }

    public static HPCCWsDFUClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsDFUClient(conn);
    }

    protected HPCCWsDFUClient(Connection baseConnection) {
        this.initWsDFUClientStub(baseConnection);
    }

    protected void initWsDFUClientStub(Connection conn) {
        block3: {
            this.initErrMessage = "";
            try {
                HPCCWsSMCClient wssmc = HPCCWsSMCClient.get(conn);
                this.targetVersion = new Version(wssmc.getHPCCBuild());
                if (this.targetVersion == null) {
                    throw new Exception("Cannot initialize HPCCWsDFUStub without valid HPCC version object");
                }
                this.stubwrapper = new WsDFUClientStubWrapper(conn.getBaseUrl() + WSDFUURI, this.targetVersion);
                this.stub = this.stubwrapper.get1_51Stub(null);
                this.stub = HPCCWsDFUClient.setStubOptions(this.stub, conn);
            }
            catch (Exception e) {
                log.error("HPCCWsDFUClient: Could not initialize WsDFU Stub - Review all HPCC connection values");
                if (e.getLocalizedMessage().isEmpty()) break block3;
                this.initErrMessage = e.getLocalizedMessage();
                log.error("HPCCWsDFUClient: " + e.getLocalizedMessage());
            }
        }
    }

    public DFUInfoWrapper getFileInfo(String logicalname, String clustername) throws Exception, ArrayOfEspExceptionWrapper {
        return this.getFileInfo(logicalname, clustername, false, false);
    }

    public DFUInfoWrapper getFileInfo(String logicalname, String clustername, boolean jsonTypeInfo, boolean binTypeInfo) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DFUInfoRequest request = new DFUInfoRequest();
        request.setName(logicalname);
        request.setIncludeBinTypeInfo(binTypeInfo);
        request.setIncludeJsonTypeInfo(jsonTypeInfo);
        if (clustername != null) {
            request.setCluster(clustername);
        }
        DFUInfoResponse response = null;
        try {
            response = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUInfo(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.getFileInfo(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getFileInfo");
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not ListFiles");
        }
        return new DFUInfoWrapper(response);
    }

    public NodeList getFileData(String logicalname, Long beginrow, Integer numrows, String clustername) throws Exception, ArrayOfEspExceptionWrapper {
        String xmlresult;
        this.verifyStub();
        DFUBrowseDataRequest request = new DFUBrowseDataRequest();
        request.setLogicalName(logicalname);
        if (clustername != null) {
            request.setCluster(clustername);
        }
        if (beginrow == null) {
            beginrow = 0L;
        }
        if (numrows == null) {
            numrows = 1;
        }
        request.setStart(beginrow);
        request.setCount(numrows);
        DFUBrowseDataResponse response = null;
        try {
            response = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUBrowseData(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.getFileData(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getFileData");
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not getFileData");
        }
        if (!(xmlresult = response.getResult()).contains("<Dataset")) {
            return null;
        }
        xmlresult = xmlresult.substring(xmlresult.indexOf("<Dataset"));
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(new ByteArrayInputStream(xmlresult.getBytes()));
            NodeList ds = dom.getDocumentElement().getChildNodes();
            if (ds != null && ds.getLength() > 0) {
                return ds;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public List<DFULogicalFileWrapper> getFiles(String scope) throws Exception, ArrayOfEspExceptionWrapper {
        ArrayOfDFULogicalFile filesarray;
        this.verifyStub();
        ArrayList<DFULogicalFileWrapper> result = new ArrayList<DFULogicalFileWrapper>();
        DFUFileViewRequest request = new DFUFileViewRequest();
        request.setScope(scope);
        DFUFileViewResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUFileView(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.getFiles(" + scope + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getFiles");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not getFiles");
        }
        if ((filesarray = resp.getDFULogicalFiles()) != null) {
            DFULogicalFile[] files = filesarray.getDFULogicalFile();
            result = new ArrayList();
            for (int i = 0; i < files.length; ++i) {
                result.add(new DFULogicalFileWrapper(files[i]));
            }
        }
        return result;
    }

    private void checkSuperfileLayouts(String[] subfiles, String cluster) throws Exception, ArrayOfEspExceptionWrapper {
        String eclrecord = null;
        String basefile = null;
        if (subfiles == null) {
            return;
        }
        for (int i = 0; i < subfiles.length; ++i) {
            String thisecl;
            DFUInfoWrapper details = this.getFileInfo(subfiles[i], cluster);
            if (details == null || details.getFileDetail() == null) continue;
            String string = thisecl = details.getFileDetail().getEcl() == null ? "" : details.getFileDetail().getEcl();
            if (eclrecord == null) {
                basefile = subfiles[i];
                eclrecord = thisecl;
            }
            if (thisecl.equals(eclrecord)) continue;
            throw new Exception(basefile + " and " + subfiles[i] + " have different ecl layouts in the same superfile");
        }
    }

    public AddtoSuperfileResponseWrapper createSuperfile(String superfilename, String[] subfiles) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        AddtoSuperfileRequestWrapper request = new AddtoSuperfileRequestWrapper();
        request.setSuperfile(superfilename);
        request.setExistingFile(false);
        String comadelimitedsubfiles = "";
        for (int i = 0; i < subfiles.length; ++i) {
            if (i > 0) {
                comadelimitedsubfiles = comadelimitedsubfiles + ", ";
            }
            comadelimitedsubfiles = comadelimitedsubfiles + subfiles[i];
        }
        if (!comadelimitedsubfiles.isEmpty()) {
            request.setSubfiles(comadelimitedsubfiles);
        }
        if (subfiles != null && subfiles.length > 0) {
            request.setNames(Arrays.asList(subfiles));
        }
        return this.addToSuperFile(request);
    }

    public AddtoSuperfileResponseWrapper addToSuperFile(AddtoSuperfileRequestWrapper request) throws Exception, ArrayOfEspExceptionWrapper {
        if (request == null) {
            throw new Exception("HPCCWsDFUClient.createSuperfile: request cannot be null");
        }
        this.verifyStub();
        AddtoSuperfileResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).addtoSuperfile(request.getRaw());
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.createSuperfile(" + request.getSuperfile() + ", subfiles) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform createSuperfile");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not perform createSuperfile");
        }
        return new AddtoSuperfileResponseWrapper(resp);
    }

    public String[] getSuperFileSubfiles(String filename) throws Exception, ArrayOfEspExceptionWrapper {
        SuperfileListRequest request = new SuperfileListRequest();
        request.setSuperfile(filename);
        SuperfileListResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).superfileList(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.getSuperFile(" + filename + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not get getSuperFileList");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not get superfilelist");
        }
        String[] result = new String[]{""};
        org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.EspStringArray subfilesarray = resp.getSubfiles();
        if (subfilesarray != null) {
            result = subfilesarray.getItem();
        }
        return result;
    }

    public List<DFUDataColumnWrapper> getFileMetaData(String logicalname, String clustername) throws Exception, ArrayOfEspExceptionWrapper {
        String eclrecord;
        ArrayList<DFUDataColumnWrapper> cols;
        block18: {
            this.verifyStub();
            cols = new ArrayList<DFUDataColumnWrapper>();
            eclrecord = null;
            try {
                DFUInfoWrapper details = this.getFileInfo(logicalname, clustername);
                if (details == null || details.getFileDetail() == null) break block18;
                eclrecord = details.getFileDetail().getEcl();
                if (!details.getFileDetail().getIsSuperfile()) break block18;
                String[] subfiles = null;
                try {
                    subfiles = this.getSuperFileSubfiles(logicalname);
                }
                catch (Exception e) {
                    log.info("Failure while verifying superfile list for '" + logicalname + "'");
                }
                this.checkSuperfileLayouts(subfiles, clustername);
                if (subfiles != null && subfiles.length != 0) {
                    logicalname = subfiles[0];
                    break block18;
                }
                throw new Exception(logicalname + " is a superfile with no subfiles, cannot determine file structure");
            }
            catch (Exception e) {
                String msg = "Error calling DFUInfo for " + logicalname + ":" + e.getMessage();
                log.error(msg);
                throw new Exception(msg, e);
            }
        }
        DFUGetFileMetaDataRequest request = new DFUGetFileMetaDataRequest();
        request.setLogicalFileName(logicalname);
        if (clustername != null) {
            request.setClusterName(clustername);
        }
        DFUGetFileMetaDataResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUGetFileMetaData(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.getFileMetaDataInfo(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getFileMetaDataInfo");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not getFileMetaDataInfo");
        }
        if (resp == null || resp.getDataColumns() == null) {
            return cols;
        }
        DFUDataColumn[] datacolumns = resp.getDataColumns().getDFUDataColumn();
        for (int i = 0; i < datacolumns.length; ++i) {
            cols.add(new DFUDataColumnWrapper(datacolumns[i]));
        }
        try {
            if (eclrecord != null && !StringUtils.isEmpty((CharSequence)eclrecord)) {
                EclRecordWrapper recinfo = DFUFileDetailWrapper.getRecordEcl(eclrecord);
                if (recinfo.getParseErrors().size() > 0) {
                    throw new Exception(StringUtils.join(recinfo.getParseErrors(), (String)"\n"));
                }
                if (recinfo.getRecordsets().size() > 0 && recinfo.getRecordsets().containsKey(EclRecordWrapper.UNNAMED) && recinfo.getRecordsets().get(EclRecordWrapper.UNNAMED).getChildColumns().size() == cols.size()) {
                    for (int i = 0; i < cols.size(); ++i) {
                        DFUDataColumnWrapper base = (DFUDataColumnWrapper)cols.get(i);
                        DFUDataColumnWrapper extra = recinfo.getRecordsets().get(EclRecordWrapper.UNNAMED).getChildColumns().get(i);
                        if (!base.getColumnLabel().equals(extra.getColumnLabel())) continue;
                        base.setAnnotations(extra.getAnnotations());
                        base.setBlob(extra.isBlob());
                        base.setMaxlength(extra.getMaxlength());
                        base.setMaxcount(extra.getMaxcount());
                        base.setMaxSize(extra.getMaxSize());
                        base.setXmlDefaultVal(extra.getXmlDefaultVal());
                        base.setXpath(extra.getXpath());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Could not parse ecl for " + logicalname + ", returning base metadata. Ecl:" + eclrecord);
        }
        return cols;
    }

    public List<DFUDataColumnWrapper> getFileDataColumns(String logicalname, String clustername) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DFUGetDataColumnsRequest request = new DFUGetDataColumnsRequest();
        request.setOpenLogicalName(logicalname);
        if (clustername != null) {
            request.setCluster(clustername);
        }
        DFUGetDataColumnsResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUGetDataColumns(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.getFileDataColumns(" + logicalname + "," + clustername + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getFileDataColumns");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not perform getFileDataColumns");
        }
        ArrayList<DFUDataColumnWrapper> cols = new ArrayList<DFUDataColumnWrapper>();
        for (Method m : resp.getClass().getMethods()) {
            DFUDataColumn[] thesecols;
            Object r;
            if (m.getName().startsWith("getDFUDataKeyedColumns") && m.getParameterTypes().length == 0 && (r = m.invoke((Object)resp, new Object[0])) != null) {
                thesecols = (DFUDataColumn[])r;
                for (DFUDataColumn col : Arrays.asList(thesecols)) {
                    cols.add(new DFUDataColumnWrapper(col));
                }
            }
            if (!m.getName().startsWith("getDFUDataNonKeyedColumns") || m.getParameterTypes().length != 0 || (r = m.invoke((Object)resp, new Object[0])) == null) continue;
            thesecols = (DFUDataColumn[])r;
            for (DFUDataColumn col : Arrays.asList(thesecols)) {
                cols.add(new DFUDataColumnWrapper(col));
            }
        }
        return cols;
    }

    public EclRecordWrapper getDatasetFields(String datasetname, String clusterName, String fieldSeparator) throws Exception, ArrayOfEspExceptionWrapper {
        DFUFileDetailWrapper info = this.getFileDetails(datasetname, clusterName);
        if (fieldSeparator != null) {
            info.setCsvSeparate(fieldSeparator);
        }
        return info.deduceFields();
    }

    public String getFirstRow(String datasetname, String clustername) throws Exception, ArrayOfEspExceptionWrapper {
        NodeList rowdata = this.getFileData(datasetname, 0L, 1, clustername);
        if (rowdata != null && rowdata.getLength() > 0) {
            if (rowdata.item(0).hasChildNodes()) {
                return rowdata.item(0).getFirstChild().getTextContent();
            }
            return rowdata.item(0).getTextContent();
        }
        return null;
    }

    public List<DFULogicalFileWrapper> getLogicalFiles(String filename, String cluster, int firstN, int pageStartFrom, int pageSize) throws Exception, ArrayOfEspExceptionWrapper {
        ArrayOfDFULogicalFile logicalfilesarray;
        this.verifyStub();
        DFUQueryRequest request = new DFUQueryRequest();
        if (filename != null) {
            request.setLogicalName(filename);
        }
        request.setFirstN(firstN);
        request.setPageStartFrom(pageStartFrom);
        request.setPageSize(pageSize);
        DFUQueryResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.getLogicalFiles(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getLogicalFiles");
        }
        ArrayList<DFULogicalFileWrapper> logicalfiles = new ArrayList<DFULogicalFileWrapper>();
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not getLogicalFiles");
        }
        if ((logicalfilesarray = resp.getDFULogicalFiles()) != null) {
            DFULogicalFile[] dfulogicalfilesarray = logicalfilesarray.getDFULogicalFile();
            for (int i = 0; i < dfulogicalfilesarray.length; ++i) {
                logicalfiles.add(new DFULogicalFileWrapper(dfulogicalfilesarray[i]));
            }
        }
        return logicalfiles;
    }

    public DFUSearchDataResponse getDFUData(String openLogicalName, String cluster, boolean roxieSelections, int chooseFile, int count, boolean schemaOnly, long startIndex) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DFUSearchDataRequest request = new DFUSearchDataRequest();
        request.setOpenLogicalName(openLogicalName);
        request.setCluster(cluster);
        request.setRoxieSelections(roxieSelections);
        request.setChooseFile(chooseFile);
        request.setCount(count);
        request.setSchemaOnly(schemaOnly);
        request.setStartIndex(startIndex);
        DFUSearchDataResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUSearchData(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.getDFUData(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform getDFUData");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not getDFUData");
        }
        return resp;
    }

    public void deleteSuperFileSubfiles(String superfile, List<String> subfiles) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        SuperfileActionRequest request = new SuperfileActionRequest();
        request.setAction("remove");
        request.setSuperfile(superfile);
        org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.EspStringArray espsubfiles = new org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.EspStringArray();
        for (String subfile : subfiles) {
            espsubfiles.addItem(subfile);
        }
        request.setSubfiles(espsubfiles);
        SuperfileActionResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).superfileAction(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.deleteSuperFileSubfiles(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not perform deleteSuperFileSubfiles");
        }
        if (resp != null && resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not deleteSuperFileSubfiles");
        }
    }

    public List<DFUResultWrapper> deleteFiles(Set<String> files, String cluster) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DFUArrayActionRequest request = new DFUArrayActionRequest();
        request.setType(DFUArrayActions.Factory.fromValue("Delete"));
        org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.EspStringArray logicalfilesarray = new org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.EspStringArray();
        String[] filesarray = files.toArray(new String[files.size()]);
        if (cluster != null && !cluster.isEmpty()) {
            for (int i = 0; i < filesarray.length; ++i) {
                String fullfile = filesarray[i];
                String[] split = fullfile.split("::");
                String file = split[split.length - 1];
                int atIndex = file.indexOf(64);
                if (atIndex >= 0 && atIndex < file.length()) {
                    throw new Exception("Do not provide filename@cluster and cluster parameter: " + file + ", " + cluster);
                }
                filesarray[i] = fullfile + "@" + cluster;
            }
        }
        logicalfilesarray.setItem(filesarray);
        request.setLogicalFiles(logicalfilesarray);
        DFUArrayActionResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUArrayAction(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.deleteFiles(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not deleteFiles");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not deleteFiles");
        }
        ArrayList<DFUResultWrapper> results = new ArrayList<DFUResultWrapper>();
        ArrayOfDFUActionInfo actioninfoarray = resp.getActionResults();
        if (actioninfoarray != null) {
            DFUActionInfo[] actionresp = actioninfoarray.getDFUActionInfo();
            for (int i = 0; i < actionresp.length; ++i) {
                results.add(new DFUResultWrapper(actionresp[i]));
            }
        }
        return results;
    }

    public List<DFULogicalFileWrapper> searchFiles(String logicalFilename, String cluster) throws Exception, ArrayOfEspExceptionWrapper {
        return this.searchFiles(logicalFilename, cluster, null, null);
    }

    public List<DFULogicalFileWrapper> searchFiles(String logicalFilename, String cluster, Integer pagesize, Integer pageStartFrom) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        if (logicalFilename != null && logicalFilename.startsWith("~")) {
            logicalFilename = logicalFilename.substring(1);
        }
        DFUQueryRequest request = new DFUQueryRequest();
        request.setNodeGroup(cluster);
        request.setLogicalName(logicalFilename);
        if (pagesize != null) {
            request.setPageSize(pagesize);
        }
        if (pageStartFrom != null) {
            request.setPageStartFrom(pageStartFrom);
        }
        DFUQueryResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.searchFiles(" + logicalFilename + "," + cluster + ") encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Could Not SearchFiles");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Could Not SearchFiles");
        }
        ArrayList<DFULogicalFileWrapper> result = new ArrayList<DFULogicalFileWrapper>();
        ArrayOfDFULogicalFile logicalfilearray = resp.getDFULogicalFiles();
        if (logicalfilearray != null) {
            DFULogicalFile[] dfulogicalfilearray = resp.getDFULogicalFiles().getDFULogicalFile();
            for (int i = 0; i < dfulogicalfilearray.length; ++i) {
                result.add(new DFULogicalFileWrapper(dfulogicalfilearray[i]));
            }
        }
        return result;
    }

    public String getFileAccessBlob(SecAccessType accesstype, String filename, String clustername, int expiryseconds, String jobid) throws Exception, ArrayOfEspExceptionWrapper {
        if (this.targetVersion == null || this.stub == null) {
            throw new Exception("WSDFU client not available" + (this.hasInitError() ? " - " + this.initErrMessage : ""));
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor == 0) {
            DFUFileAccessInfoWrapper fileaccessinfo = this.getFileAccess(accesstype, filename, clustername, expiryseconds, jobid, false, false, false);
            if (fileaccessinfo == null) {
                throw new Exception("Could not acquire file access for '" + filename + "' on cluster: '" + clustername + "'");
            }
            return fileaccessinfo.getFileAccessInfoBlob();
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor > 0) {
            return this.getFileAccessBlob(filename, clustername, expiryseconds, jobid);
        }
        throw new Exception("File access not supported in HPCC version: " + this.targetVersion.major + "." + this.targetVersion.minor + ".x");
    }

    public String getFileAccessBlob(String filename, String clustername, int expiryseconds, String jobid) throws Exception, ArrayOfEspExceptionWrapper {
        if (this.targetVersion == null || this.stub == null) {
            throw new Exception("WSDFU client not available" + (this.hasInitError() ? " - " + this.initErrMessage : ""));
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor > 0) {
            DFUFileAccessInfoWrapper fileaccessinfo = this.getFileAccess(filename, clustername, expiryseconds, jobid);
            if (fileaccessinfo == null) {
                throw new Exception("Could not acquire file access for '" + filename + "' on cluster: '" + clustername + "'");
            }
            return fileaccessinfo.getFileAccessInfoBlob();
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor == 0) {
            return this.getFileAccessBlob(SecAccessType.Full, filename, clustername, expiryseconds, jobid);
        }
        throw new Exception("File access blob not supported in HPCC version: " + this.targetVersion.major + "." + this.targetVersion.minor + ".x");
    }

    public DFUFileAccessInfoWrapper getFileAccess(SecAccessType accesstype, String filename, String clustername, int expiryseconds, String jobid, boolean includejsonTypeInfo, boolean includebinTypeInfo, boolean requestfileinfo) throws Exception, ArrayOfEspExceptionWrapper {
        if (this.targetVersion == null || this.stub == null) {
            throw new Exception("WSDFU client not available" + (this.hasInitError() ? " - " + this.initErrMessage : ""));
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor == 0) {
            WsDfuStub stub1_39 = this.stubwrapper.get1_39Stub(this.stuboptions);
            DFUFileAccessRequest request = new DFUFileAccessRequest();
            DFUFileAccessRequestBase requestbase = new DFUFileAccessRequestBase();
            requestbase.setAccessRole(requestfileinfo ? FileAccessRole.External : FileAccessRole.Token);
            requestbase.setAccessType(accesstype);
            requestbase.setCluster(clustername);
            requestbase.setExpirySeconds(expiryseconds);
            requestbase.setJobId(jobid);
            requestbase.setName(filename);
            requestbase.setReturnBinTypeInfo(includebinTypeInfo);
            requestbase.setReturnJsonTypeInfo(includejsonTypeInfo);
            request.setRequestBase(requestbase);
            org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUFileAccessResponse resp = null;
            try {
                resp = stub1_39.dFUFileAccess(request);
            }
            catch (RemoteException e) {
                throw new Exception("HPCCWsDFUClient.getFileAccess(...) encountered RemoteException.", e);
            }
            if (resp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Error acquiring read access for: '" + clustername + "::" + filename + "'");
            }
            if (resp == null || resp.getAccessInfo() == null) {
                throw new Exception("Did not receive DFUFileAccess response");
            }
            return new DFUFileAccessInfoWrapper(resp.getAccessInfo());
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor > 0) {
            return this.getFileAccess(filename, clustername, expiryseconds, jobid);
        }
        throw new Exception("WSDFU getFileAccess not available on HPCC v" + this.targetVersion.major + "." + this.targetVersion.minor);
    }

    public DFUFileAccessInfoWrapper getFileAccess(String filename, String clustername, int expiryseconds, String jobid) throws Exception, ArrayOfEspExceptionWrapper {
        if (this.targetVersion == null || this.stub == null) {
            throw new Exception("WSDFU client not available" + (this.hasInitError() ? " - " + this.initErrMessage : ""));
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor > 0) {
            this.verifyStub();
            DFUFileAccessV2Request request = new DFUFileAccessV2Request();
            request.setCluster(clustername);
            request.setExpirySeconds(expiryseconds);
            request.setRequestId(jobid);
            request.setName(filename);
            request.setReturnTextResponse(true);
            DFUFileAccessResponse resp = null;
            try {
                resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUFileAccessV2(request);
            }
            catch (RemoteException e) {
                throw new Exception("Error acquiring read access for: '" + clustername + "::" + filename + "'", e);
            }
            catch (EspSoapFault e) {
                this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Error acquiring read access for: '" + clustername + "::" + filename + "'");
            }
            if (resp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Error acquiring read access for: '" + clustername + "::" + filename + "'");
            }
            if (resp == null || resp.getAccessInfo() == null && (resp.getExceptions() == null || resp.getExceptions().getException().length == 0)) {
                throw new Exception("Did not receive DFUFileAccess response");
            }
            return new DFUFileAccessInfoWrapper(resp.getAccessInfo(), resp.getType());
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor == 0) {
            return this.getFileAccess(SecAccessType.Read, filename, clustername, expiryseconds, jobid, true, false, true);
        }
        throw new Exception("WSDFU getFileAccess not available on HPCC v" + this.targetVersion.major + "." + this.targetVersion.minor);
    }

    public DFUCreateFileWrapper createFile(String fileName, String cluster, String eclRecordDefinition, String[] partitionHostMap, int expirySeconds) throws Exception, ArrayOfEspExceptionWrapper {
        return this.createFileAndAcquireAccess(fileName, cluster, eclRecordDefinition, partitionHostMap, expirySeconds, false, false, FileAccessRole.External, SecAccessType.Write);
    }

    public DFUCreateFileWrapper createFileAndAcquireAccess(String fileName, String cluster, String eclRecordDefinition, String[] partitionHostMap, int expirySeconds, Boolean returnBinTypeInfo, Boolean returnJsonTypeInfo, FileAccessRole accessrole, SecAccessType accesstype) throws Exception, ArrayOfEspExceptionWrapper {
        if (this.targetVersion == null || this.stub == null) {
            throw new Exception("WSDFU client not available" + (this.hasInitError() ? " - " + this.initErrMessage : ""));
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor == 0) {
            WsDfuStub stub1_39 = this.stubwrapper.get1_39Stub(this.stuboptions);
            DFUFileCreateRequest request = new DFUFileCreateRequest();
            DFUFileAccessRequestBase requestbase = new DFUFileAccessRequestBase();
            request.setECLRecordDefinition(eclRecordDefinition);
            EspStringArray espStringArray = new EspStringArray();
            for (int i = 0; i < partitionHostMap.length; ++i) {
                espStringArray.addItem(partitionHostMap[i]);
            }
            request.setPartLocations(espStringArray);
            requestbase.setCluster(cluster);
            requestbase.setExpirySeconds(expirySeconds);
            requestbase.setName(fileName);
            if (returnBinTypeInfo != null) {
                requestbase.setReturnBinTypeInfo(returnBinTypeInfo);
            }
            if (returnJsonTypeInfo != null) {
                requestbase.setReturnJsonTypeInfo(returnJsonTypeInfo);
            }
            requestbase.setAccessRole(accessrole);
            requestbase.setAccessType(accesstype);
            request.setRequestBase(requestbase);
            org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUFileCreateResponse resp = null;
            try {
                resp = stub1_39.dFUFileCreate(request);
            }
            catch (RemoteException e) {
                throw new Exception("HPCCWsDFUClient.getFileAccess(...) encountered RemoteException.", e);
            }
            if (resp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Error creating DFU file: '" + cluster + "::" + fileName + "'");
            }
            if (resp == null || resp.getAccessInfo() == null) {
                throw new Exception("Did not receive DFUFileCreateResponse response");
            }
            return new DFUCreateFileWrapper(resp);
        }
        if (this.targetVersion.major > 7 || this.targetVersion.major == 7 && this.targetVersion.minor > 0) {
            return this.createFileAndAcquireAccess(fileName, cluster, eclRecordDefinition, expirySeconds, null, null, null);
        }
        throw new Exception("WSDFU File Create not available on HPCC v" + this.targetVersion.major + "." + this.targetVersion.minor);
    }

    public DFUCreateFileWrapper createFile(String fileName, String cluster, String eclRecordDefinition, int expirySeconds) throws Exception, ArrayOfEspExceptionWrapper {
        return this.createFileAndAcquireAccess(fileName, cluster, eclRecordDefinition, expirySeconds, false, null, null);
    }

    public DFUCreateFileWrapper createFile(String fileName, String cluster, String eclRecordDefinition, int expirySeconds, Boolean compressed) throws Exception, ArrayOfEspExceptionWrapper {
        return this.createFileAndAcquireAccess(fileName, cluster, eclRecordDefinition, expirySeconds, compressed, null, null);
    }

    public DFUCreateFileWrapper createFile(String fileName, String cluster, String eclRecordDefinition, int expirySeconds, Boolean compressed, DFUFileTypeWrapper filetype, String requestid) throws Exception, ArrayOfEspExceptionWrapper {
        return this.createFileAndAcquireAccess(fileName, cluster, eclRecordDefinition, expirySeconds, compressed, filetype, requestid);
    }

    public DFUCreateFileWrapper createFileAndAcquireAccess(String fileName, String cluster, String eclRecordDefinition, int expirySeconds, Boolean compressed, DFUFileTypeWrapper type, String requestId) throws Exception, ArrayOfEspExceptionWrapper {
        if (this.targetVersion == null || this.stub == null) {
            throw new Exception("WSDFU client not available" + (this.hasInitError() ? " - " + this.initErrMessage : ""));
        }
        if (this.targetVersion.major > 7 || this.targetVersion.major == 7 && this.targetVersion.minor > 0) {
            this.verifyStub();
            DFUFileCreateV2Request request = new DFUFileCreateV2Request();
            request.setECLRecordDefinition(eclRecordDefinition);
            request.setCluster(cluster);
            request.setExpirySeconds(expirySeconds);
            request.setName(fileName);
            request.setReturnTextResponse(true);
            if (compressed != null) {
                request.setCompressed(compressed);
            }
            if (type != null) {
                request.setType(type.getFUFileType());
            }
            if (requestId != null) {
                request.setRequestId(requestId);
            }
            DFUFileCreateResponse resp = null;
            try {
                resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUFileCreateV2(request);
            }
            catch (RemoteException e) {
                throw new Exception("HPCCWsDFUClient.createFileAndAcquireAccess(...) encountered RemoteException.", e);
            }
            catch (EspSoapFault e) {
                this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Error creating DFU file: '" + cluster + "::" + fileName + "'");
            }
            if (resp == null || resp.getAccessInfo() == null && (resp.getExceptions() == null || resp.getExceptions().getException().length == 0)) {
                throw new Exception("Did not receive DFUFileCreateResponse");
            }
            if (resp.getExceptions() != null) {
                this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Error creating DFU file: '" + cluster + "::" + fileName + "'");
            }
            if (resp.getFileId() == null) {
                throw new Exception("Invalid DFUFileCreateResponse. FildId is null.");
            }
            return new DFUCreateFileWrapper(resp);
        }
        if (this.targetVersion.major == 7 && this.targetVersion.minor == 0) {
            throw new Exception("Must provide filepart mapping via createFileAndAcquireAccess() when targeting HPCC v" + this.targetVersion.major + "." + this.targetVersion.minor);
        }
        throw new Exception("WSDFU File Create not available on HPCC v" + this.targetVersion.major + "." + this.targetVersion.minor);
    }

    public void publishFile(String fileId, String eclRecordDefinition, long totalRecords, long fileSize) throws Exception, ArrayOfEspExceptionWrapper {
        this.publishFile(fileId, eclRecordDefinition, totalRecords, fileSize, null);
    }

    public void publishFile(String fileId, String eclRecordDefinition, long totalRecords, long fileSize, Boolean overwrite) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        DFUFilePublishRequest request = new DFUFilePublishRequest();
        request.setECLRecordDefinition(eclRecordDefinition);
        request.setFileId(fileId);
        request.setFileSize(fileSize);
        request.setRecordCount(totalRecords);
        if (overwrite != null) {
            request.setOverwrite(overwrite);
        }
        DFUFilePublishResponse resp = null;
        try {
            resp = ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).dFUFilePublish(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsDFUClient.publishFile(...) encountered RemoteException.", e);
        }
        catch (EspSoapFault e) {
            this.handleEspSoapFaults(new EspSoapFaultWrapper(e), "Error publishing DFU file: '" + fileId + "' \n" + e.getMessage());
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(resp.getExceptions()), "Error publishing DFU file: '" + fileId + "'");
        }
    }

    public DFUFileDetailWrapper getFileDetails(String logicalname, String clustername) throws Exception, ArrayOfEspExceptionWrapper {
        return this.getFileDetails(logicalname, clustername, false, false);
    }

    public DFUFileDetailWrapper getFileDetails(String logicalname, String clustername, boolean jsonTypeInfo, boolean binTypeInfo) throws Exception, ArrayOfEspExceptionWrapper {
        String[] strings;
        DFUFileDetailWrapper subfile;
        DFUInfoWrapper resp = this.getFileInfo(logicalname, clustername, jsonTypeInfo, binTypeInfo);
        if (resp == null) {
            throw new FileNotFoundException(logicalname + " does not exist");
        }
        if (resp.getExceptions() != null) {
            this.handleEspExceptions(resp.getExceptions(), "Retrieving file details");
        }
        DFUFileDetailWrapper info = resp.getFileDetail();
        try {
            info.setFirstline(this.getFirstRow(logicalname, clustername));
        }
        catch (Exception e) {
            info.setFirstline("");
        }
        if (info.getFilename() != null) {
            try {
                info.setColumns(this.getFileMetaData(logicalname, clustername));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((info.getEcl() == null || info.getEcl().isEmpty()) && info.getIsSuperfile() && info.getSubfiles() != null && info.getSubfiles().getItem().length != 0 && (subfile = this.getFileDetails((strings = info.getSubfiles().getItem())[0], info.getNodeGroup())) != null) {
            info.setEcl(subfile.getEcl());
            info.setColumns(subfile.getColumns());
            info.setContentType(subfile.getContentType());
            info.setFormat(subfile.getFormat());
        }
        return info;
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        WsDfuPingRequest request = new WsDfuPingRequest();
        try {
            ((org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_51.WsDfuStub)this.stub).ping(request);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

