/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

public class Version
implements Comparable<Version> {
    public String versionString = "";
    public String prefix = "";
    public int major = 0;
    public int minor = 0;
    public int point = 0;
    public String postfix = "";
    public String postfixStr = "";
    public int postfixInt = 0;
    public static final int DISTANCE_SUFFIXINT = 100;
    public static final int DISTANCE_SUFFIXSTR = 1000;
    public static final int DISTANCE_POINT = 100000;
    public static final int DISTANCE_MINOR = 100000000;

    public Version(String versionString) {
        this.versionString = versionString;
        String[] parts = versionString.split("(_|-|\\[|\\])");
        if (parts.length == 1) {
            this.calcVersion(parts[0]);
        } else if (parts.length >= 3) {
            this.prefix = parts[0];
            this.calcVersion(parts[1]);
            this.calcPostfix(parts[2]);
        }
    }

    void calcVersion(String version) {
        this.major = 0;
        this.minor = 0;
        this.point = 0;
        try {
            String[] parts = version.split("\\.");
            if (parts.length >= 1) {
                this.major = new Integer(parts[0]);
            }
            if (parts.length >= 2) {
                this.minor = new Integer(parts[1]);
            }
            if (parts.length >= 3) {
                this.point = new Integer(parts[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void calcPostfix(String postfix) {
        this.postfix = postfix;
        if (postfix.isEmpty()) {
            return;
        }
        String postfixIntStr = "";
        for (char c : postfix.toCharArray()) {
            if (Character.isDigit(c)) {
                postfixIntStr = postfixIntStr + c;
                continue;
            }
            this.postfixStr = this.postfixStr + c;
        }
        try {
            this.postfixInt = new Integer(postfixIntStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.versionString;
    }

    @Override
    public int compareTo(Version other) {
        if (other.major < this.major) {
            return -1;
        }
        if (other.major > this.major) {
            return 1;
        }
        if (other.minor < this.minor) {
            return -1;
        }
        if (other.minor > this.minor) {
            return 1;
        }
        if (other.point < this.point) {
            return -1;
        }
        if (other.point > this.point) {
            return 1;
        }
        if (!other.postfixStr.isEmpty() && this.postfixStr.isEmpty()) {
            return -1;
        }
        if (other.postfixStr.isEmpty() && !this.postfixStr.isEmpty()) {
            return 1;
        }
        if (other.postfixInt < this.postfixInt) {
            return -1;
        }
        if (other.postfixInt > this.postfixInt) {
            return 1;
        }
        return other.prefix.compareTo(this.prefix);
    }

    public static long distance(Version l, Version r) {
        long retVal = 0L;
        retVal += (long)Math.abs(r.postfixInt - l.postfixInt);
        retVal += (long)(Math.abs(r.postfix.compareTo(l.postfix)) * 100);
        retVal += (long)(Math.abs(r.point - l.point) * 1000);
        retVal += (long)(Math.abs(r.minor - l.minor) * 100000);
        return retVal += (long)(Math.abs(r.major - l.major) * 100000000);
    }
}

