/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.utils;

import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StackHandler
extends DefaultHandler {
    protected Stack<Element> elementStack = new Stack();

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        assert (!this.elementStack.empty());
        this.elementStack.peek().appendContent(ch, start, length);
        super.characters(ch, start, length);
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.elementStack.push(new Element(qName, attributes));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elementStack.pop();
        super.endElement(uri, localName, qName);
    }

    public class Element {
        public String tag;
        public Attributes attributes;
        public StringBuilder content;

        Element(String tag, Attributes attributes) {
            this.tag = tag;
            this.attributes = attributes;
            this.content = new StringBuilder();
        }

        void appendContent(char[] ch, int start, int length) {
            this.content.append(new String(ch, start, length));
        }
    }
}

