/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CheckinAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CheckoutAttributeRequest;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.CreateAttribute;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.ECLAttribute;
import org.hpccsystems.ws.client.gen.axis2.wsattributes.v1_21.SaveAttributeRequest;

public class ECLAttributeWrapper {
    private Integer version;
    private String type;
    private String text;
    private Integer sandboxVersion;
    private Integer resultType;
    private String name;
    private String moduleName;
    private String modifiedDate;
    private String modifiedBy;
    private String lockedBy;
    private Integer latestVersion;
    private Boolean isSandbox;
    private Boolean isOrphaned;
    private Boolean isLocked;
    private Boolean isCheckedOut;
    private Integer flags;
    private String description;
    private String checksum;
    private Integer access;
    private List<String> validtypes = Arrays.asList("ecl", "cmp", "dud", "spc", "kel");

    public ECLAttributeWrapper() {
    }

    public ECLAttributeWrapper(String modulename, String attributename, String attributetype, String ecltext) {
        this.moduleName = modulename;
        this.name = attributename;
        this.type = attributetype;
        this.text = ecltext;
    }

    public ECLAttributeWrapper(ECLAttribute raw) {
        this.access = raw.getAccess();
        this.checksum = raw.getChecksum();
        this.description = raw.getDescription();
        this.flags = raw.getFlags();
        this.isCheckedOut = raw.getIsCheckedOut();
        this.isLocked = raw.getIsLocked();
        this.isOrphaned = raw.getIsOrphaned();
        this.isSandbox = raw.getIsSandbox();
        this.latestVersion = raw.getLatestVersion();
        this.lockedBy = raw.getLockedBy();
        this.modifiedBy = raw.getModifiedBy();
        this.modifiedDate = raw.getModifiedDate();
        this.moduleName = raw.getModuleName();
        this.name = raw.getName();
        this.resultType = raw.getResultType();
        this.sandboxVersion = raw.getSandboxVersion();
        this.text = raw.getText();
        this.type = raw.getType();
        this.version = raw.getVersion();
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Integer getSandboxVersion() {
        return this.sandboxVersion;
    }

    public void setSandboxVersion(Integer sandboxVersion) {
        this.sandboxVersion = sandboxVersion;
    }

    public Integer getResultType() {
        return this.resultType;
    }

    public void setResultType(Integer resultType) {
        this.resultType = resultType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(String modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public void setLockedBy(String lockedBy) {
        this.lockedBy = lockedBy;
    }

    public Integer getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(Integer latestVersion) {
        this.latestVersion = latestVersion;
    }

    public Boolean getIsSandbox() {
        return this.isSandbox;
    }

    public void setIsSandbox(Boolean isSandbox) {
        this.isSandbox = isSandbox;
    }

    public Boolean getIsOrphaned() {
        return this.isOrphaned;
    }

    public void setIsOrphaned(Boolean isOrphaned) {
        this.isOrphaned = isOrphaned;
    }

    public Boolean getIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public Boolean getIsCheckedOut() {
        return this.isCheckedOut;
    }

    public void setIsCheckedOut(Boolean isCheckedOut) {
        this.isCheckedOut = isCheckedOut;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public void setFlags(Integer flags) {
        this.flags = flags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public Integer getAccess() {
        return this.access;
    }

    public void setAccess(Integer access) {
        this.access = access;
    }

    public String getUniqueName() {
        String val = "";
        if (this.moduleName != null) {
            val = val + this.moduleName.toLowerCase();
        }
        if (this.name != null) {
            val = val + this.name.toLowerCase();
        }
        if (this.type != null) {
            val = val + this.type.toLowerCase();
        }
        return val;
    }

    public CreateAttribute toCreateAttribute() {
        CreateAttribute attr = new CreateAttribute();
        attr.setAttributeName(this.name);
        attr.setType(this.type);
        attr.setModuleName(this.moduleName);
        return attr;
    }

    public SaveAttributeRequest toSaveAttributeRequest() {
        SaveAttributeRequest attr = new SaveAttributeRequest();
        attr.setAttributeName(this.name);
        attr.setModuleName(this.moduleName);
        attr.setText(this.text);
        return attr;
    }

    public CheckinAttributeRequest toCheckinAttributeRequest(String checkinmsg) {
        CheckinAttributeRequest req = new CheckinAttributeRequest();
        req.setAttributeName(this.name);
        req.setModuleName(this.moduleName);
        req.setDescription(checkinmsg);
        return req;
    }

    public CheckoutAttributeRequest toCheckoutAttributeRequest() {
        CheckoutAttributeRequest req = new CheckoutAttributeRequest();
        req.setAttributeName(this.name);
        req.setModuleName(this.moduleName);
        return req;
    }

    private String checkitem(String val, String label) throws Exception {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return label + " is required";
        }
        if (!val.equals(val.replaceAll("[^0-9A-Za-z]", "_"))) {
            return label + "'" + val + "' is not a valid ecl " + label;
        }
        return null;
    }

    public void validate() throws Exception {
        ArrayList<String> errs = new ArrayList<String>();
        String res = this.checkitem(this.moduleName, "module name");
        if (res != null) {
            errs.add(res);
        }
        if ((res = this.checkitem(this.name, "attribute name")) != null) {
            errs.add(res);
        }
        if (StringUtils.isEmpty((CharSequence)this.text)) {
            errs.add("Ecl is required");
        }
        if (StringUtils.isEmpty((CharSequence)this.type)) {
            errs.add("attribute type is required");
        } else if (!this.validtypes.contains(this.type.toLowerCase())) {
            errs.add("attribute type " + this.type + " is not a valid attribute type for an legacy mysql ecl repo");
        }
        if (errs.size() > 0) {
            throw new Exception(StringUtils.join(errs, (String)"\n"));
        }
    }

    public String toString() {
        return "ECLAttributeInfo [ name=" + this.name + ", moduleName=" + this.moduleName + ", version=" + this.version + ", type=" + this.type + ", sandboxVersion=" + this.sandboxVersion + ", resultType=" + this.resultType + ", modifiedDate=" + this.modifiedDate + ", modifiedBy=" + this.modifiedBy + ", lockedBy=" + this.lockedBy + ", latestVersion=" + this.latestVersion + ", isSandbox=" + this.isSandbox + ", isOrphaned=" + this.isOrphaned + ", isLocked=" + this.isLocked + ", isCheckedOut=" + this.isCheckedOut + ", flags=" + this.flags + ", description=" + this.description + ", checksum=" + this.checksum + ", access=" + this.access + ", text=" + this.text + "]";
    }

    public ECLAttribute getRaw() {
        ECLAttribute raw = new ECLAttribute();
        raw.setModuleName(this.moduleName);
        raw.setName(this.name);
        raw.setType(this.type);
        raw.setVersion(this.version);
        raw.setLatestVersion(this.latestVersion);
        raw.setSandboxVersion(this.sandboxVersion);
        raw.setFlags(this.flags);
        raw.setAccess(this.access);
        raw.setIsLocked(this.isLocked);
        raw.setIsCheckedOut(this.isCheckedOut);
        raw.setIsSandbox(this.isSandbox);
        raw.setIsOrphaned(this.isOrphaned);
        raw.setResultType(this.resultType);
        raw.setLockedBy(this.lockedBy);
        raw.setModifiedBy(this.modifiedBy);
        raw.setModifiedDate(this.modifiedDate);
        raw.setDescription(this.description);
        raw.setChecksum(this.checksum);
        raw.setText(this.text);
        return raw;
    }
}

