/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wssmc.v1_21.Activity;
import org.hpccsystems.ws.client.gen.axis2.wssmc.v1_21.ActivityResponse;
import org.hpccsystems.ws.client.gen.axis2.wssmc.v1_21.EspException;
import org.hpccsystems.ws.client.gen.axis2.wssmc.v1_21.Ping;
import org.hpccsystems.ws.client.gen.axis2.wssmc.v1_21.WsSMCStub;
import org.hpccsystems.ws.client.utils.Connection;

public class HPCCWsSMCClient
extends BaseHPCCWsClient {
    public static final String WSSMCURI = "/WsSMC";
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsSMCClient.getServiceWSDLURL(new WsSMCStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    public static String getServiceURI() {
        return WSSMCURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsSMCClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsSMCClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    public static HPCCWsSMCClient get(Connection connection) {
        return new HPCCWsSMCClient(connection);
    }

    public static HPCCWsSMCClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsSMCClient(conn);
    }

    public static HPCCWsSMCClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsSMCClient(conn);
    }

    protected HPCCWsSMCClient(Connection conn) {
        this.initWsSMCSoapProxy(conn);
    }

    private void initWsSMCSoapProxy(Connection conn) {
        block2: {
            try {
                this.stub = HPCCWsSMCClient.setStubOptions(new WsSMCStub(conn.getUrl() + WSSMCURI), conn);
            }
            catch (Exception e) {
                log.error("Could not initialize WsSMCStub - Review all HPCC connection values");
                if (e.getLocalizedMessage().isEmpty()) break block2;
                this.initErrMessage = e.getLocalizedMessage();
                log.error(e.getLocalizedMessage());
            }
        }
    }

    public String getHPCCBuild() throws Exception {
        EspException[] exceptionarray;
        String build = null;
        this.verifyStub();
        Activity request = new Activity();
        ActivityResponse response = null;
        String errMessage = "Could not determine HPCC build version: ";
        try {
            response = ((WsSMCStub)this.stub).activity(request);
        }
        catch (Exception e) {
            if (!e.getLocalizedMessage().isEmpty() && e.getLocalizedMessage().indexOf("401") != -1) {
                throw new Exception("Could not determine HPCC build version: Received 401 Unauthorized response from ECLWatch.");
            }
            throw new Exception("Could not determine HPCC build version: " + e.getLocalizedMessage());
        }
        if (response.getExceptions() != null && (exceptionarray = response.getExceptions().getException()).length > 0) {
            throw new Exception("Could not determine HPCC build version: " + exceptionarray[0].getMessage());
        }
        build = response.getBuild();
        return build;
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        Ping request = new Ping();
        try {
            ((WsSMCStub)this.stub).ping(request);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsSMCStub();
    }
}

