/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.ArrayOfTpCluster;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.ArrayOfTpTargetCluster;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpCluster;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpClusterInfoRequest;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpClusterInfoResponse;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpDropZoneQueryRequest;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpDropZoneQueryResponse;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpLogicalClusterQueryRequest;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpLogicalClusterQueryResponse;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpServiceQueryRequest;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpServiceQueryResponse;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpTargetCluster;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpTargetClusterQueryRequest;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpTargetClusterQueryResponse;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.WsTopologyPingRequest;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.WsTopologyStub;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.ArrayOfTpDropZoneWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.ArrayOfTpLogicalClusterWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.ArrayOfTpTargetClusterWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpClusterInfoResponseWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpDropZoneWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpLogicalClusterWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpMachineWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpServicesWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpTargetClusterWrapper;

public class HPCCWsTopologyClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsTopologyClient.class);
    public static final String WSTOPOLOGYWSDLURI = "/WsTopology";
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsTopologyClient.getServiceWSDLURL(new WsTopologyStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    public static String getServiceURI() {
        return WSTOPOLOGYWSDLURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsTopologyClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsTopologyClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    public static HPCCWsTopologyClient get(Connection connection) {
        return new HPCCWsTopologyClient(connection);
    }

    public static HPCCWsTopologyClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsTopologyClient(conn);
    }

    public static HPCCWsTopologyClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsTopologyClient(conn);
    }

    protected HPCCWsTopologyClient(Connection baseConnection) {
        this.initWsTopologyStub(baseConnection);
    }

    private void initWsTopologyStub(Connection connection) {
        block3: {
            try {
                this.stub = HPCCWsTopologyClient.setStubOptions(new WsTopologyStub(connection.getBaseUrl() + WSTOPOLOGYWSDLURI), connection);
            }
            catch (AxisFault e) {
                log.error("Could not initialize WsTopologyStub - Review all HPCC connection values");
                e.printStackTrace();
            }
            catch (Exception e) {
                log.error("Could not initialize WsTopologyStub - Review all HPCC connection values");
                if (e.getLocalizedMessage().isEmpty()) break block3;
                this.initErrMessage = e.getLocalizedMessage();
                log.error(e.getLocalizedMessage());
            }
        }
    }

    public boolean printValidTargetClusters(PrintStream stream) throws Exception, ArrayOfEspExceptionWrapper {
        ArrayOfTpTargetCluster arrayOfTpTargetCluster;
        boolean success = false;
        this.verifyStub();
        TpTargetClusterQueryRequest request = new TpTargetClusterQueryRequest();
        request.setType("ROOT");
        request.setShowDetails(false);
        TpTargetClusterQueryResponse response = null;
        try {
            response = ((WsTopologyStub)this.stub).tpTargetClusterQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsTopologyClient.printValidTargetClusters(...) encountered RemoteException.", e);
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not fetch target groups.");
        }
        if ((arrayOfTpTargetCluster = response.getTpTargetClusters()) != null) {
            TpTargetCluster[] tpTargetClusters;
            for (TpTargetCluster tptargetcluster : tpTargetClusters = arrayOfTpTargetCluster.getTpTargetCluster()) {
                ArrayOfTpCluster tpClusters = tptargetcluster.getTpClusters();
                if (tpClusters == null) continue;
                for (TpCluster tpcluster : tpClusters.getTpCluster()) {
                    stream.println(" TPCluster Name: " + tpcluster.getName());
                }
            }
            success = true;
        }
        return success;
    }

    public List<TpTargetClusterWrapper> getValidTargetGroups() throws Exception, ArrayOfEspExceptionWrapper {
        ArrayOfTpTargetClusterWrapper arrayOfTpTargetCluster;
        List<TpTargetClusterWrapper> tpTargetClusters = null;
        this.verifyStub();
        TpTargetClusterQueryRequest request = new TpTargetClusterQueryRequest();
        request.setType("ROOT");
        request.setShowDetails(false);
        TpTargetClusterQueryResponse response = null;
        try {
            response = ((WsTopologyStub)this.stub).tpTargetClusterQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsTopologyClient.getValidTargetGroups(...) encountered RemoteException.", e);
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not fetch target groups.");
        }
        if ((arrayOfTpTargetCluster = new ArrayOfTpTargetClusterWrapper(response.getTpTargetClusters())) != null) {
            tpTargetClusters = arrayOfTpTargetCluster.getTpTargetCluster();
        }
        return tpTargetClusters;
    }

    public String[] getValidTargetGroupNames() throws Exception, ArrayOfEspExceptionWrapper {
        String[] tpTargetClusterNames = null;
        this.verifyStub();
        TpTargetClusterQueryRequest request = new TpTargetClusterQueryRequest();
        request.setType("ROOT");
        request.setShowDetails(false);
        TpTargetClusterQueryResponse response = null;
        try {
            response = ((WsTopologyStub)this.stub).tpTargetClusterQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsTopologyClient.getValidTargetGroupNames(...) encountered RemoteException.", e);
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not fetch target groups.");
        }
        ArrayOfTpTargetCluster arrayOfTpTargetCluster = response.getTpTargetClusters();
        TpTargetCluster[] tpTargetClusters = arrayOfTpTargetCluster.getTpTargetCluster();
        tpTargetClusterNames = new String[tpTargetClusters.length];
        for (int i = 0; i < tpTargetClusters.length; ++i) {
            tpTargetClusterNames[i] = tpTargetClusters[i].getName();
        }
        return tpTargetClusterNames;
    }

    public TpDropZoneWrapper queryDropzone(String name) throws Exception, ArrayOfEspExceptionWrapper {
        List<TpDropZoneWrapper> dropZones = this.queryDropzones(name);
        if (dropZones.size() != 1) {
            throw new Exception("Could not query Dropzone: '" + name + "'");
        }
        return dropZones.get(0);
    }

    public List<TpDropZoneWrapper> queryDropzones(String namefilter) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        TpDropZoneQueryRequest request = new TpDropZoneQueryRequest();
        request.setName(namefilter);
        TpDropZoneQueryResponse response = null;
        try {
            response = ((WsTopologyStub)this.stub).tpDropZoneQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsTopologyClient.queryDropzones(...) encountered RemoteException.", e);
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Error fetching dropzone info");
        }
        ArrayOfTpDropZoneWrapper arrayoftpdz = new ArrayOfTpDropZoneWrapper(response.getTpDropZones());
        return arrayoftpdz.getTpDropZone();
    }

    public List<TpMachineWrapper> queryDropzoneMachines(String name) throws Exception, ArrayOfEspExceptionWrapper {
        return this.queryDropzone(name).getTpMachines().getTpMachine();
    }

    private String[] extractClusterNames(String clusterGroupType, boolean targetClusterNamesOnly) throws Exception {
        ArrayOfTpTargetCluster arrayOfTpTargetCluster;
        ArrayList<String> tpClusterNames = new ArrayList<String>();
        this.verifyStub();
        TpTargetClusterQueryRequest request = new TpTargetClusterQueryRequest();
        request.setType("ROOT");
        request.setShowDetails(false);
        TpTargetClusterQueryResponse response = null;
        try {
            response = ((WsTopologyStub)this.stub).tpTargetClusterQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsTopologyClient.getValidClusterNames(...) encountered RemoteException.", e);
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not fetch valid cluster names.");
        }
        if ((arrayOfTpTargetCluster = response.getTpTargetClusters()) != null) {
            TpTargetCluster[] tpTargetClusters = arrayOfTpTargetCluster.getTpTargetCluster();
            for (int i = 0; i < tpTargetClusters.length; ++i) {
                TpCluster[] tpClusters;
                ArrayOfTpCluster arrayOfTpCluster;
                if (clusterGroupType != null && !clusterGroupType.isEmpty() && !tpTargetClusters[i].getType().equalsIgnoreCase(clusterGroupType + "cluster") || (arrayOfTpCluster = tpTargetClusters[i].getTpClusters()) == null || (tpClusters = arrayOfTpCluster.getTpCluster()) == null) continue;
                for (int k = 0; k < tpClusters.length; ++k) {
                    if (clusterGroupType != null && !clusterGroupType.isEmpty() && !tpClusters[k].getType().equalsIgnoreCase(clusterGroupType + "cluster")) continue;
                    if (targetClusterNamesOnly) {
                        if (tpClusterNames.contains(tpTargetClusters[i].getName())) continue;
                        tpClusterNames.add(tpTargetClusters[i].getName());
                        continue;
                    }
                    if (tpClusterNames.contains(tpClusters[k].getName())) continue;
                    tpClusterNames.add(tpClusters[k].getName());
                }
            }
        }
        return tpClusterNames.toArray(new String[0]);
    }

    public String[] getValidClusterNames(String clusterGroupType) throws Exception {
        return this.extractClusterNames(clusterGroupType, false);
    }

    public String[] getValidTargetClusterNames(String clusterGroupType) throws Exception, ArrayOfEspExceptionWrapper {
        return this.extractClusterNames(clusterGroupType, true);
    }

    public String[] getValidTargetClusterNamesArray() throws Exception, ArrayOfEspExceptionWrapper {
        return this.getValidTargetClusterNames("");
    }

    public List<String> getValidTargetClusterNames() throws Exception, ArrayOfEspExceptionWrapper {
        ArrayList<String> names = new ArrayList<String>();
        String[] validTargetClusterNames = this.getValidTargetClusterNamesArray();
        for (int i = 0; i < validTargetClusterNames.length; ++i) {
            names.add(validTargetClusterNames[i]);
        }
        return names;
    }

    public TpServicesWrapper getServices() throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        TpServiceQueryRequest request = new TpServiceQueryRequest();
        request.setType("ALLSERVICES");
        TpServiceQueryResponse response = null;
        try {
            response = ((WsTopologyStub)this.stub).tpServiceQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsTopologyClient.getServices(...) encountered RemoteException.", e);
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could Not fetch target services.");
        }
        return new TpServicesWrapper(response.getServiceList());
    }

    public TpClusterInfoResponseWrapper getClusterInfo(String clusterName) throws Exception, ArrayOfEspExceptionWrapper {
        this.verifyStub();
        TpClusterInfoRequest request = new TpClusterInfoRequest();
        request.setName(clusterName);
        TpClusterInfoResponse response = null;
        try {
            response = ((WsTopologyStub)this.stub).tpClusterInfo(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsTopologyClient.getClusterInfo(" + clusterName + ") encountered RemoteException.", e);
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not get getClusterInfo for cluster: '" + clusterName + "'");
        }
        return new TpClusterInfoResponseWrapper(response);
    }

    public List<TpLogicalClusterWrapper> getLogicalClusters() throws Exception, ArrayOfEspExceptionWrapper {
        ArrayOfTpLogicalClusterWrapper tpLogicalClusters;
        this.verifyStub();
        List<TpLogicalClusterWrapper> tplogclusters = null;
        TpLogicalClusterQueryRequest request = new TpLogicalClusterQueryRequest();
        TpLogicalClusterQueryResponse response = null;
        try {
            response = ((WsTopologyStub)this.stub).tpLogicalClusterQuery(request);
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWsTopologyClient.getLogicalClusters() encountered RemoteException.", e);
        }
        if (response.getExceptions() != null) {
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(response.getExceptions()), "Could not get getLogicalClusters");
        }
        if ((tpLogicalClusters = new ArrayOfTpLogicalClusterWrapper(response.getTpLogicalClusters())) != null) {
            tplogclusters = tpLogicalClusters.getTpLogicalCluster();
        }
        return tplogclusters;
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        WsTopologyPingRequest request = new WsTopologyPingRequest();
        try {
            ((WsTopologyStub)this.stub).ping(request);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsTopologyStub();
    }
}

