/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.util.HashMap;
import java.util.Map;
import org.hpccsystems.ws.client.HPCCWsTopologyClient;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpClusterInfoResponse;
import org.hpccsystems.ws.client.gen.axis2.wstopology.v1_28.TpTargetCluster;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpClusterInfoResponseWrapper;

public class Cluster
extends DataSingleton {
    private static Map<Integer, Cluster> Clusters = new HashMap<Integer, Cluster>();
    private Platform platform;
    private TpTargetCluster info;
    private TpClusterInfoResponse info2;

    public static synchronized Cluster get(Platform platform, String name) {
        Cluster cluster = new Cluster(platform, name);
        if (Clusters.containsKey(cluster.hashCode())) {
            return Clusters.get(cluster.hashCode());
        }
        Clusters.put(cluster.hashCode(), cluster);
        return cluster;
    }

    Cluster(Platform platform, String name) {
        this.platform = platform;
        this.info = new TpTargetCluster();
        this.info.setName(name);
        this.info2 = new TpClusterInfoResponse();
        this.info2.setName(name);
    }

    public String getName() {
        return this.info.getName();
    }

    @Override
    protected boolean isComplete() {
        return true;
    }

    @Override
    protected void fastRefresh() {
        this.fullRefresh();
    }

    @Override
    protected void fullRefresh() {
        try {
            HPCCWsTopologyClient wsTopologyClient = this.platform.getWsClient().getWsTopologyClient();
            TpClusterInfoResponseWrapper respsone = wsTopologyClient.getClusterInfo(this.info.getName());
            this.Update(respsone);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void Update(TpClusterInfoResponseWrapper ci) {
        if (this.info2.getName().equals(ci.getName())) {
            this.info2 = ci.getRaw();
            this.setChanged();
        }
    }

    public void Update(TpTargetCluster tc) {
        if (this.info.getName().equals(tc.getName())) {
            this.info = tc;
            this.setChanged();
        }
    }

    void Update(TpClusterInfoResponse ci) {
        if (this.info2.getName().equals(ci.getName())) {
            this.info2 = ci;
            this.setChanged();
        }
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Cluster)) {
            return false;
        }
        Cluster that = (Cluster)aThat;
        return EqualsUtil.areEqual(this.platform, that.platform) && EqualsUtil.areEqual(this.info.getName(), that.info.getName());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.platform);
        result = HashCodeUtil.hash(result, this.info.getName());
        return result;
    }
}

