/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hpccsystems.ws.client.HPCCWsWorkUnitsClient;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ApplicationValue;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ECLGraph;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ECLQuery;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ECLResult;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ECLSourceFile;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.v1_75.ECLWorkunit;
import org.hpccsystems.ws.client.platform.Graph;
import org.hpccsystems.ws.client.platform.LogicalFile;
import org.hpccsystems.ws.client.platform.Platform;
import org.hpccsystems.ws.client.platform.Result;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.DataSingletonCollection;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.wrappers.WUState;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUQueryWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WorkunitWrapper;

public class Workunit
extends DataSingleton {
    public static DataSingletonCollection All = new DataSingletonCollection();
    private Platform platform;
    private WorkunitWrapper info;
    private Collection<String> resultViews;
    private Collection<Result> results;
    private Collection<Graph> graphs;
    private Collection<LogicalFile> sourceFiles;
    private Map<String, String> applicationValues;
    private static Map<String, WUState> WuStateNameMap = new HashMap<String, WUState>();

    public static Workunit get(Platform platform, String wuid) {
        if (wuid == null || wuid.isEmpty()) {
            return null;
        }
        return (Workunit)All.get(new Workunit(platform, wuid));
    }

    private Workunit(Platform platform, String wuid) {
        this.platform = platform;
        this.info = new WorkunitWrapper();
        this.info.setWuid(wuid);
        this.resultViews = new ArrayList<String>();
        this.results = new ArrayList<Result>();
        this.graphs = new ArrayList<Graph>();
        this.sourceFiles = new ArrayList<LogicalFile>();
        this.applicationValues = new HashMap<String, String>();
        this.setChanged();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getWuid() {
        return this.info.getWuid();
    }

    public String getQueryText() {
        if (this.info.getQuery() == null) {
            this.fullRefresh(false, false, false, false);
        }
        if (this.info.getQuery() != null && this.info.getQuery().getText() != null) {
            return this.info.getQuery().getText();
        }
        return "";
    }

    public Object getClusterName() {
        if (this.info.getCluster() == null) {
            this.fullRefresh(false, false, false, false);
        }
        return this.info.getCluster();
    }

    public WUState getStateID() {
        if (this.info.getStateID() != null) {
            switch (this.info.getStateID()) {
                case 1: {
                    return WUState.COMPILED;
                }
                case 2: {
                    return WUState.RUNNING;
                }
                case 3: {
                    return WUState.COMPLETED;
                }
                case 4: {
                    return WUState.FAILED;
                }
                case 5: {
                    return WUState.ARCHIVED;
                }
                case 6: {
                    return WUState.ABORTING;
                }
                case 7: {
                    return WUState.ABORTED;
                }
                case 8: {
                    return WUState.BLOCKED;
                }
                case 9: {
                    return WUState.SUBMITTED;
                }
                case 10: {
                    return WUState.SCHEDULED;
                }
                case 11: {
                    return WUState.COMPILING;
                }
                case 12: {
                    return WUState.WAIT;
                }
                case 13: {
                    return WUState.WAIT;
                }
                case 14: {
                    return WUState.WAIT;
                }
                case 15: {
                    return WUState.RUNNING;
                }
                case 999: {
                    return WUState.UNKNOWN_ONSERVER;
                }
            }
        }
        return WUState.UNKNOWN;
    }

    public static boolean isFailedState(String state) {
        WUState statecode = Workunit.translateWUState(state);
        switch (statecode) {
            case UNKNOWN_ONSERVER: 
            case FAILED: 
            case ABORTED: 
            case ABORTING: 
            case BLOCKED: 
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }

    public static WUState translateWUState(String state) {
        if (WuStateNameMap.containsKey(state.toUpperCase())) {
            return WuStateNameMap.get(state.toUpperCase());
        }
        return WUState.UNKNOWN;
    }

    public String getState() {
        if (this.info.getState() == null) {
            this.fastRefresh();
        }
        return this.info.getState() != null ? this.info.getState() : "Unknown";
    }

    public GregorianCalendar getDate() {
        String wuid = this.getWuid();
        int year = Integer.parseInt(wuid.substring(1, 5));
        int month = Integer.parseInt(wuid.substring(5, 7)) - 1;
        int date = Integer.parseInt(wuid.substring(7, 9));
        int hour = Integer.parseInt(wuid.substring(10, 12));
        int min = Integer.parseInt(wuid.substring(12, 14));
        int sec = Integer.parseInt(wuid.substring(14, 16));
        return new GregorianCalendar(year, month, date, hour, min, sec);
    }

    public String[] getResultViews() {
        if (this.resultViews == null) {
            this.fullRefresh(false, true, false, false);
        }
        return this.resultViews.toArray(new String[0]);
    }

    public boolean hasApplicationValue(String key) {
        if (this.applicationValues.isEmpty()) {
            this.fullRefresh(false, false, false, true);
        }
        return this.applicationValues.containsKey(key);
    }

    public String getApplicationValue(String key) {
        if (this.applicationValues.isEmpty()) {
            this.fullRefresh(false, false, false, true);
        }
        if (this.applicationValues.containsKey(key)) {
            return this.applicationValues.get(key);
        }
        return "";
    }

    public synchronized Result getResult(Integer sequence) {
        return Result.get(this, sequence);
    }

    public Result getResult(ECLResult r) {
        Result result = this.getResult(r.getSequence());
        result.update(r);
        return result;
    }

    public Result[] getResults() {
        this.fullRefresh(false, true, false, false);
        return this.results.toArray(new Result[0]);
    }

    synchronized Graph getGraph(String name) {
        return Graph.get(this, name);
    }

    Graph getGraph(ECLGraph g) {
        Graph graph = this.getGraph(g.getName());
        graph.update(g);
        return graph;
    }

    public Graph[] getGraphs() {
        this.fullRefresh(true, false, false, false);
        return this.graphs.toArray(new Graph[0]);
    }

    synchronized LogicalFile getSourceFile(String name) {
        return LogicalFile.get(this.platform, name);
    }

    LogicalFile getSourceFile(ECLSourceFile sf) {
        LogicalFile sourceFile = this.getSourceFile(sf.getName());
        sourceFile.Update(sf);
        return sourceFile;
    }

    public LogicalFile[] getSourceFiles() {
        this.fullRefresh(false, false, true, false);
        return this.sourceFiles.toArray(new LogicalFile[0]);
    }

    @Override
    public boolean isComplete() {
        return HPCCWsWorkUnitsClient.isWorkunitComplete(this.getStateID());
    }

    public String getJobname() {
        String retVal = this.info.getJobname();
        if (retVal == null) {
            return "";
        }
        return retVal;
    }

    public String getOwner() {
        String retVal = this.info.getOwner();
        if (retVal == null) {
            return "";
        }
        return retVal;
    }

    public void abort() {
        try {
            HPCCWsWorkUnitsClient wsWorkunitsClient = this.platform.getWsClient().getWsWorkunitsClient();
            try {
                wsWorkunitsClient.abortWU(this.info.getWuid());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void delete() {
        try {
            HPCCWsWorkUnitsClient wsWorkunitsClient = this.platform.getWsClient().getWsWorkunitsClient();
            try {
                wsWorkunitsClient.deleteWU(this.info.getWuid());
                this.refreshState();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void resubmit(boolean restart, boolean clone) {
        try {
            HPCCWsWorkUnitsClient wsWorkunitsClient = this.platform.getWsClient().getWsWorkunitsClient();
            try {
                wsWorkunitsClient.resubmitWU(this.info.getWuid(), restart, clone);
                this.refreshState();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void resubmit() {
        this.resubmit(false, false);
    }

    public void restart() {
        this.resubmit(true, false);
    }

    public void _clone() {
        this.resubmit(false, true);
    }

    public void publish() {
        try {
            HPCCWsWorkUnitsClient wsWorkunitsClient = this.platform.getWsClient().getWsWorkunitsClient();
            try {
                wsWorkunitsClient.publishWU(this.info.getWuid());
                this.refreshState();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void refreshState() {
        this.fullRefresh(false, false, false, false);
    }

    @Override
    protected void fastRefresh() {
        WUState previousState = this.getStateID();
        try {
            HPCCWsWorkUnitsClient wsWorkunitsClient = this.platform.getWsClient().getWsWorkunitsClient();
            List<WorkunitWrapper> response = wsWorkunitsClient.workUnitUQuery(new WUQueryWrapper().setWuid(this.info.getWuid()).setPageSize(new Long(1L)));
            if (response.size() == 1) {
                this.update(response.get(0).getEclWorkunit());
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (previousState != this.getStateID()) {
            this.fullRefresh();
        }
    }

    @Override
    protected void fullRefresh() {
        this.fullRefresh(true, true, true, true);
    }

    void fullRefresh(boolean includeGraphs, boolean includeResults, boolean includeSourceFiles, boolean includeApplicationValues) {
        try {
            HPCCWsWorkUnitsClient wsWorkunitsClient = this.platform.getWsClient().getWsWorkunitsClient();
            try {
                WorkunitWrapper wi = wsWorkunitsClient.getWUInfo(this.info.getWuid(), includeResults, includeGraphs, includeSourceFiles, includeApplicationValues, false, false, false, false, false);
                if (wi != null) {
                    this.update(wi.getEclWorkunit());
                    if (wi.getResultViews() != null) {
                        this.resultViews = Arrays.asList(wi.getResultViews());
                    }
                }
            }
            catch (Exception ex) {
                if (ex.getCause() != null) {
                    Throwable cause = ex.getCause();
                    System.out.println(cause.getLocalizedMessage());
                    this.setChanged();
                    this.notifyObservers((Object)Notification.WORKUNIT);
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public boolean update(ECLWorkunit wu) {
        boolean retVal = false;
        if (wu != null && this.info.getWuid().equals(wu.getWuid()) && !this.info.equals(wu)) {
            if (this.updateState(wu)) {
                retVal = true;
                this.notifyObservers((Object)Notification.WORKUNIT);
            }
            if (this.updateOwner(wu.getOwner())) {
                retVal = true;
                this.notifyObservers((Object)Notification.OWNER);
            }
            if (this.updateJobname(wu.getJobname())) {
                retVal = true;
                this.notifyObservers((Object)Notification.JOBNAME);
            }
            if (this.updateCluster(wu.getCluster())) {
                retVal = true;
                this.notifyObservers((Object)Notification.CLUSTER);
            }
            if (this.updateQuery(wu.getQuery())) {
                retVal = true;
                this.notifyObservers((Object)Notification.QUERY);
            }
            if (this.updateApplicationValues(wu.getApplicationValues().getApplicationValue())) {
                retVal = true;
                this.notifyObservers((Object)Notification.APPLICATIONVALUES);
            }
            if (this.updateResults(wu.getResults().getECLResult())) {
                retVal = true;
                this.notifyObservers((Object)Notification.RESULTS);
            }
            if (this.updateGraphs(wu.getGraphs().getECLGraph())) {
                retVal = true;
                this.notifyObservers((Object)Notification.GRAPHS);
            }
            if (this.updateSourceFiles(wu.getSourceFiles().getECLSourceFile())) {
                retVal = true;
                this.notifyObservers((Object)Notification.SOURCEFILES);
            }
        }
        this.monitor();
        return retVal;
    }

    synchronized boolean updateState(ECLWorkunit wu) {
        boolean retVal = false;
        if (wu != null && this.info.getWuid().equals(wu.getWuid()) && EqualsUtil.hasChanged(this.info.getStateID(), wu.getStateID())) {
            this.info.setStateID(wu.getStateID());
            this.info.setStateEx(wu.getStateEx());
            this.info.setState(wu.getState());
            this.setChanged();
            retVal = true;
        }
        return retVal;
    }

    synchronized boolean updateCluster(String cluster) {
        if (cluster != null && EqualsUtil.hasChanged(this.info.getCluster(), cluster)) {
            this.info.setCluster(cluster);
            this.setChanged();
            return true;
        }
        return false;
    }

    synchronized boolean updateOwner(String owner) {
        if (owner != null && EqualsUtil.hasChanged(this.info.getOwner(), owner)) {
            this.info.setOwner(owner);
            this.setChanged();
            return true;
        }
        return false;
    }

    synchronized boolean updateJobname(String jobname) {
        if (jobname != null && EqualsUtil.hasChanged(this.info.getJobname(), jobname)) {
            this.info.setJobname(jobname);
            this.setChanged();
            return true;
        }
        return false;
    }

    synchronized boolean updateQuery(ECLQuery q) {
        if (q != null && EqualsUtil.hasChanged(this.info.getQuery(), q)) {
            this.info.setQuery(q);
            this.setChanged();
            return true;
        }
        return false;
    }

    synchronized boolean updateApplicationValues(ApplicationValue[] rawAppVals) {
        if (rawAppVals != null) {
            int applicationValuesCount = this.applicationValues.size();
            this.applicationValues.clear();
            for (ApplicationValue av : rawAppVals) {
                if (av.getApplication().compareTo("org.hpccsystems.ws.client") != 0) continue;
                this.applicationValues.put(av.getName(), av.getValue());
            }
            if (applicationValuesCount != this.applicationValues.size()) {
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    synchronized boolean updateResults(ECLResult[] rawResults) {
        if (rawResults != null) {
            int resultCount = this.results.size();
            this.results.clear();
            for (ECLResult r : rawResults) {
                this.results.add(this.getResult(r));
            }
            if (resultCount != this.results.size()) {
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    synchronized boolean updateGraphs(ECLGraph[] rawGraphs) {
        if (rawGraphs != null) {
            int graphCount = this.graphs.size();
            this.graphs.clear();
            for (ECLGraph g : rawGraphs) {
                this.graphs.add(this.getGraph(g));
            }
            if (graphCount != this.graphs.size()) {
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    synchronized boolean updateSourceFiles(ECLSourceFile[] rawSourceFiles) {
        if (rawSourceFiles != null) {
            int sourceFileCount = this.sourceFiles.size();
            this.sourceFiles.clear();
            for (ECLSourceFile g : rawSourceFiles) {
                this.sourceFiles.add(this.getSourceFile(g));
            }
            if (sourceFileCount != this.sourceFiles.size()) {
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    static boolean isValidWUIDString(String wuid) {
        if (wuid.length() >= 16 && wuid.startsWith("W")) {
            for (int i = 1; i < 8; ++i) {
                if (Character.isDigit(wuid.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Workunit)) {
            return false;
        }
        Workunit that = (Workunit)aThat;
        return EqualsUtil.areEqual(this.platform, that.platform) && EqualsUtil.areEqual(this.info.getWuid(), that.info.getWuid());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.platform);
        result = HashCodeUtil.hash(result, this.info.getWuid());
        return result;
    }

    static {
        WuStateNameMap.put("COMPILED", WUState.COMPILED);
        WuStateNameMap.put("RUNNING", WUState.RUNNING);
        WuStateNameMap.put("COMPLETED", WUState.COMPLETED);
        WuStateNameMap.put("FAILED", WUState.FAILED);
        WuStateNameMap.put("ARCHIVED", WUState.ARCHIVED);
        WuStateNameMap.put("ABORTING", WUState.ABORTING);
        WuStateNameMap.put("ABORTED", WUState.ABORTED);
        WuStateNameMap.put("BLOCKED", WUState.BLOCKED);
        WuStateNameMap.put("SUBMITTED", WUState.SUBMITTED);
        WuStateNameMap.put("SCHEDULED", WUState.SCHEDULED);
        WuStateNameMap.put("COMPILING", WUState.COMPILING);
        WuStateNameMap.put("WAIT", WUState.WAIT);
        WuStateNameMap.put("RUNNING", WUState.RUNNING);
        WuStateNameMap.put("PAUSED", WUState.PAUSED);
    }

    public static enum Notification {
        WORKUNIT,
        CLUSTER,
        QUERY,
        APPLICATIONVALUES,
        RESULTS,
        GRAPHS,
        SOURCEFILES,
        JOBNAME,
        OWNER;

    }
}

