/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wscodesign.v1_01.ArrayOfEspException;
import org.hpccsystems.ws.client.gen.axis2.wscodesign.v1_01.ListUserIDsResponse;
import org.hpccsystems.ws.client.gen.axis2.wscodesign.v1_01.SignResponse;
import org.hpccsystems.ws.client.gen.axis2.wscodesign.v1_01.VerifyResponse;
import org.hpccsystems.ws.client.gen.axis2.wscodesign.v1_01.Ws_codesignPingRequest;
import org.hpccsystems.ws.client.gen.axis2.wscodesign.v1_01.Ws_codesignStub;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wscodesign.ListUserIDsRequestWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wscodesign.ListUserIDsResponseWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wscodesign.SignRequestWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wscodesign.SignResponseWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wscodesign.VerifyRequestWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wscodesign.VerifyResponseWrapper;

public class HPCCWsCodeSignClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsCodeSignClient.class);
    public static final String WSRESOURCESURI = "/ws_codesign";
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsCodeSignClient.getServiceWSDLURL(new Ws_codesignStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getServiceURI() {
        return WSRESOURCESURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsCodeSignClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsCodeSignClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new Ws_codesignStub();
    }

    public static HPCCWsCodeSignClient get(Connection connection) {
        return new HPCCWsCodeSignClient(connection);
    }

    public static HPCCWsCodeSignClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsCodeSignClient(conn);
    }

    public static HPCCWsCodeSignClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsCodeSignClient(conn);
    }

    protected HPCCWsCodeSignClient(Connection baseConnection) {
        this.initWsResourcesClientStub(baseConnection);
    }

    protected void initWsResourcesClientStub(Connection conn) {
        this.setActiveConnectionInfo(conn);
        try {
            this.stub = HPCCWsCodeSignClient.setStubOptions(new Ws_codesignStub(conn.getBaseUrl() + WSRESOURCESURI), conn);
        }
        catch (Exception e) {
            this.stub = null;
            this.initErrMessage = "Could not initialize WsCodeSignClient - Review all HPCC connection values";
            if (!e.getLocalizedMessage().isEmpty()) {
                this.initErrMessage = this.initErrMessage + "\n" + e.getLocalizedMessage();
            }
            log.error(this.initErrMessage);
        }
    }

    public ListUserIDsResponseWrapper listUserIDs(ListUserIDsRequestWrapper req) throws Exception {
        if (req == null) {
            throw new Exception("HPCCWsCodeSignClient.listUserIDs: Must provide valid ListUserIDsRequestWrapper!");
        }
        this.verifyStub();
        ListUserIDsResponse resp = null;
        try {
            resp = ((Ws_codesignStub)this.stub).listUserIDs(req.getRaw());
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWSRESOURCESClient.listUserIDs(ListUserIDsRequestWrapper) encountered RemoteException.", e);
        }
        if (resp.getExceptions() != null) {
            ArrayOfEspException exceptions = resp.getExceptions();
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(exceptions), "Error listing userids");
        }
        return new ListUserIDsResponseWrapper(resp);
    }

    public SignResponseWrapper sign(SignRequestWrapper req) throws Exception {
        if (req == null) {
            throw new Exception("HPCCWsCodeSignClient.sign: Must provide valid SignRequestWrapper!");
        }
        this.verifyStub();
        SignResponse resp = null;
        try {
            resp = ((Ws_codesignStub)this.stub).sign(req.getRaw());
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWSRESOURCESClient.sign(ServiceQueryRequestWrapper) encountered RemoteException.", e);
        }
        if (resp.getExceptions() != null) {
            ArrayOfEspException exceptions = resp.getExceptions();
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(exceptions), "Error signing");
        }
        return new SignResponseWrapper(resp);
    }

    public VerifyResponseWrapper verify(VerifyRequestWrapper req) throws Exception {
        if (req == null) {
            throw new Exception("HPCCWsCodeSignClient.verify: Must provide valid VerifyRequestWrapper!");
        }
        this.verifyStub();
        VerifyResponse resp = null;
        try {
            resp = ((Ws_codesignStub)this.stub).verify(req.getRaw());
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWSRESOURCESClient.serviceQuery(ServiceQueryRequestWrapper) encountered RemoteException.", e);
        }
        if (resp.getExceptions() != null) {
            ArrayOfEspException exceptions = resp.getExceptions();
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(exceptions), "Error processing service query");
        }
        return new VerifyResponseWrapper(resp);
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        try {
            ((Ws_codesignStub)this.stub).ping(new Ws_codesignPingRequest());
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

