/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.BaseHPCCWsClient;
import org.hpccsystems.ws.client.gen.axis2.wsresources.latest.ArrayOfEspException;
import org.hpccsystems.ws.client.gen.axis2.wsresources.latest.ServiceQueryResponse;
import org.hpccsystems.ws.client.gen.axis2.wsresources.latest.WsResourcesPingRequest;
import org.hpccsystems.ws.client.gen.axis2.wsresources.latest.WsResourcesStub;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wsresources.ServiceQueryRequestWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wsresources.ServiceQueryResponseWrapper;

public class HPCCWsResourcesClient
extends BaseHPCCWsClient {
    private static final Logger log = LogManager.getLogger(HPCCWsResourcesClient.class);
    public static final String WSRESOURCESURI = "/WsResources";
    private static int DEFAULTSERVICEPORT = -1;
    private static String WSDLURL = null;

    private static void loadWSDLURL() {
        try {
            WSDLURL = HPCCWsResourcesClient.getServiceWSDLURL(new WsResourcesStub());
            DEFAULTSERVICEPORT = new URL(WSDLURL).getPort();
        }
        catch (MalformedURLException | AxisFault e) {
            log.error("Unable to establish original WSDL URL");
            log.error(e.getLocalizedMessage());
        }
    }

    @Override
    public String getServiceURI() {
        return WSRESOURCESURI;
    }

    public static String getServiceWSDLURL() {
        if (WSDLURL == null) {
            HPCCWsResourcesClient.loadWSDLURL();
        }
        return WSDLURL;
    }

    public static int getServiceWSDLPort() {
        if (WSDLURL == null) {
            HPCCWsResourcesClient.loadWSDLURL();
        }
        return DEFAULTSERVICEPORT;
    }

    @Override
    public Stub getDefaultStub() throws AxisFault {
        return new WsResourcesStub();
    }

    public static HPCCWsResourcesClient get(Connection connection) {
        return new HPCCWsResourcesClient(connection);
    }

    public static HPCCWsResourcesClient get(String protocol, String targetHost, String targetPort, String user, String pass) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        return new HPCCWsResourcesClient(conn);
    }

    public static HPCCWsResourcesClient get(String protocol, String targetHost, String targetPort, String user, String pass, int timeout) {
        Connection conn = new Connection(protocol, targetHost, targetPort);
        conn.setCredentials(user, pass);
        conn.setConnectTimeoutMilli(timeout);
        conn.setSocketTimeoutMilli(timeout);
        return new HPCCWsResourcesClient(conn);
    }

    protected HPCCWsResourcesClient(Connection baseConnection) {
        this.initWsResourcesClientStub(baseConnection);
    }

    protected void initWsResourcesClientStub(Connection conn) {
        block3: {
            this.initBaseWsClient(conn, true);
            try {
                this.stub = HPCCWsResourcesClient.setStubOptions(new WsResourcesStub(conn.getBaseUrl() + WSRESOURCESURI), conn);
            }
            catch (AxisFault e) {
                this.stub = null;
                this.initErrMessage = "Could not initialize WsResources - Review all HPCC connection values";
                if (e.getLocalizedMessage().isEmpty()) break block3;
                this.initErrMessage = this.initErrMessage + "\n" + e.getLocalizedMessage();
            }
        }
        if (!this.initErrMessage.isEmpty()) {
            log.error(this.initErrMessage);
        }
    }

    public ServiceQueryResponseWrapper serviceQuery(ServiceQueryRequestWrapper req) throws Exception {
        if (req == null) {
            throw new Exception("");
        }
        this.verifyStub();
        ServiceQueryResponse resp = null;
        try {
            resp = ((WsResourcesStub)this.stub).serviceQuery(req.getRaw());
        }
        catch (RemoteException e) {
            throw new Exception("HPCCWSRESOURCESClient.serviceQuery(ServiceQueryRequestWrapper) encountered RemoteException.", e);
        }
        if (resp.getExceptions() != null) {
            ArrayOfEspException exceptions = resp.getExceptions();
            this.handleEspExceptions(new ArrayOfEspExceptionWrapper(exceptions), "Error processing service query");
        }
        return new ServiceQueryResponseWrapper(resp);
    }

    public boolean ping() throws Exception {
        this.verifyStub();
        try {
            ((WsResourcesStub)this.stub).ping(new WsResourcesPingRequest());
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
            return false;
        }
        return true;
    }
}

