/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.hpccsystems.ws.client.HPCCFileSprayClient;
import org.hpccsystems.ws.client.HPCCWsClient;
import org.hpccsystems.ws.client.HPCCWsClientPool;
import org.hpccsystems.ws.client.HPCCWsDFUClient;
import org.hpccsystems.ws.client.HPCCWsSMCClient;
import org.hpccsystems.ws.client.HPCCWsTopologyClient;
import org.hpccsystems.ws.client.HPCCWsWorkUnitsClient;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.latest.DFULogicalFile;
import org.hpccsystems.ws.client.gen.axis2.wstopology.latest.TpDropZone;
import org.hpccsystems.ws.client.gen.axis2.wstopology.latest.TpTargetCluster;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.latest.ECLSourceFile;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.latest.ECLWorkunit;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.latest.QuerySet;
import org.hpccsystems.ws.client.platform.Cluster;
import org.hpccsystems.ws.client.platform.DataQuerySet;
import org.hpccsystems.ws.client.platform.DropZone;
import org.hpccsystems.ws.client.platform.FileSprayWorkunit;
import org.hpccsystems.ws.client.platform.LogicalFile;
import org.hpccsystems.ws.client.platform.Version;
import org.hpccsystems.ws.client.platform.Workunit;
import org.hpccsystems.ws.client.utils.Connection;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.DataSingletonCollection;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.utils.Utils;
import org.hpccsystems.ws.client.wrappers.ApplicationValueWrapper;
import org.hpccsystems.ws.client.wrappers.ArrayOfEspExceptionWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.ArrayOfDFUWorkunitWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.DFUWorkunitWrapper;
import org.hpccsystems.ws.client.wrappers.gen.filespray.GetDFUWorkunitsResponseWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpDropZoneWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpLogicalClusterWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wstopology.TpServicesWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFULogicalFileWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WUQueryWrapper;
import org.hpccsystems.ws.client.wrappers.wsworkunits.WorkunitWrapper;

public class Platform
extends DataSingleton {
    public static final String API_ID = "org.hpccsystems.ws.client";
    public static DataSingletonCollection All = new DataSingletonCollection();
    public static final String P_DISABLED = "disabledConfig";
    public static final String P_SSL = "sslConfig";
    public static final boolean P_SSL_DEFAULT = false;
    public static final String P_IP = "ipLaunchConfig";
    public static final String P_IP_DEFAULT = "localhost";
    public static final String P_PORT = "portLaunchConfig";
    public static final int P_PORT_DEFAULT = 8010;
    public static final int P_SSLPORT_DEFAULT = 18010;
    public static final String P_PORT_DEFAULT_STR = "8010";
    public static final String P_SSLPORT_DEFAULT_STR = "18010";
    public static final String P_USER = "userLaunchConfig";
    public static final String P_PASSWORD = "passwordLaunchConfig";
    public static final String P_CLUSTER = "clusterLaunchConfig";
    public static final String P_COMPILEONLY = "compileOnly";
    protected HPCCWsClient platformHPCCClient = null;
    protected HPCCWsClientPool hpccClientPool = null;
    private SERVER_EXISTS serverExists = SERVER_EXISTS.UNKNOWN;
    protected boolean isDisabled;
    public boolean isTempDisabled;
    private String build = "";
    private Version version;
    private Collection<Cluster> clusters;
    private Collection<DropZone> dropZones;
    protected Collection<Workunit> workunits;
    private Collection<FileSprayWorkunit> fileSprayWorkunits;
    private Collection<DataQuerySet> dataQuerySets;
    private Collection<LogicalFile> logicalFiles;
    private Boolean isContainerized;
    static int LATENCY_TEST = 0;

    public static Platform get(Connection conn) {
        if (conn == null) {
            return null;
        }
        return (Platform)All.get(new Platform(conn));
    }

    public static Platform get(String protocol, String ip, int port, String user, String pass) {
        if (ip == null || ip.isEmpty() || port <= 0) {
            return null;
        }
        Connection conn = new Connection(protocol, ip, String.valueOf(port));
        conn.setCredentials(user, pass);
        return (Platform)All.get(new Platform(conn));
    }

    public static Platform get(String address, String user, String pass) {
        Connection conn;
        if (address == null || address.isEmpty()) {
            return null;
        }
        try {
            conn = new Connection(address);
            conn.setCredentials(user, pass);
        }
        catch (Exception e) {
            return null;
        }
        return (Platform)All.get(new Platform(conn));
    }

    @Deprecated
    public static Platform getNoCreate(String protocol, String ip, int port, String user, String pass) {
        return null;
    }

    public static void remove(Platform p) {
        All.remove(p);
    }

    protected Platform(Connection hpccconn) {
        this(hpccconn, 60000L);
    }

    protected Platform(Connection hpccconn, long pooltimeoutmillis) {
        this.hpccClientPool = new HPCCWsClientPool(hpccconn, pooltimeoutmillis);
        this.platformHPCCClient = (HPCCWsClient)this.hpccClientPool.checkOut();
        this.isDisabled = false;
        this.isTempDisabled = false;
        this.clusters = new HashSet<Cluster>();
        this.dropZones = new HashSet<DropZone>();
        this.workunits = new HashSet<Workunit>();
        this.fileSprayWorkunits = new HashSet<FileSprayWorkunit>();
        this.dataQuerySets = new HashSet<DataQuerySet>();
        this.logicalFiles = new HashSet<LogicalFile>();
        this.isContainerized = null;
    }

    protected synchronized void confirmDisable() {
    }

    public void clearTempDisabled() {
        this.isTempDisabled = false;
        this.serverExists = SERVER_EXISTS.UNKNOWN;
        this.build = "";
    }

    public synchronized boolean isContainerized() {
        if (this.isContainerized == null) {
            try {
                this.isContainerized = this.platformHPCCClient.isContainerized();
            }
            catch (Exception e) {
                this.isContainerized = null;
            }
        }
        return this.isContainerized;
    }

    protected synchronized void testServer() {
        if (this.serverExists == SERVER_EXISTS.UNKNOWN) {
            this.serverExists = SERVER_EXISTS.TESTING;
            if (this.pingServer()) {
                this.serverExists = SERVER_EXISTS.TRUE;
            } else {
                this.serverExists = SERVER_EXISTS.FALSE;
                this.isTempDisabled = true;
            }
        }
    }

    public boolean isDisabled() {
        this.testServer();
        return this.isDisabled || this.isTempDisabled;
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }

    public String getProtocol() {
        return this.platformHPCCClient.getProtocol();
    }

    public String getIP() {
        return this.platformHPCCClient.getHost();
    }

    public int getPort() {
        return this.platformHPCCClient.getPortInt();
    }

    public String getUser() {
        return this.platformHPCCClient.getUserName();
    }

    public String getPassword() {
        return this.platformHPCCClient.getPassword();
    }

    protected String getBuild() {
        if (this.isEnabled() && this.build.isEmpty()) {
            try {
                HPCCWsSMCClient wssmc = this.platformHPCCClient.getWsSMCClient();
                this.build = wssmc.getHPCCBuild();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.build;
    }

    public synchronized boolean pingServer() {
        boolean success = false;
        try {
            success = this.platformHPCCClient.pingServer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }

    public Version getBuildVersion() {
        return new Version(this.getBuild());
    }

    public Version getVersion() {
        if (this.version == null) {
            this.version = new Version(this.getBuild());
        }
        return this.version;
    }

    protected static String hackUnicodeInXMLForAxisOneAndESP(String src) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            int charVal = src.codePointAt(i);
            if (charVal > 127) {
                sb.append("&#x" + Integer.toString(charVal, 16) + ";");
                continue;
            }
            sb.append(src.charAt(i));
        }
        return sb.toString();
    }

    public Workunit submit(String cluster, String archiveOrEcl, boolean compileOnly) {
        return this.submit(cluster, archiveOrEcl, "", "", 0, compileOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workunit submit(String cluster, String archiveOrEcl, String jobname, String filePath, int inlineResultLimit, boolean compileOnly) {
        Workunit wu = null;
        try {
            Workunit.All.pushTransaction("Platform.submit");
            try {
                HPCCWsWorkUnitsClient wsWorkUnitsClient = this.platformHPCCClient.getWsWorkunitsClient();
                ArrayList<ApplicationValueWrapper> appVals = new ArrayList<ApplicationValueWrapper>();
                appVals.add(new ApplicationValueWrapper(API_ID, "path", filePath));
                WorkunitWrapper response = wsWorkUnitsClient.createWUFromECL(Platform.hackUnicodeInXMLForAxisOneAndESP(archiveOrEcl), inlineResultLimit, appVals, jobname, compileOnly);
                wu = this.getWorkunit(response.getWuid());
                if (response != null) {
                    this.workunits.add(wu);
                    wsWorkUnitsClient.submitWU(response.getWuid(), cluster);
                }
            }
            catch (RemoteException e) {
                this.confirmDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            Workunit.All.popTransaction();
        }
        return wu;
    }

    @Override
    protected boolean isComplete() {
        return true;
    }

    @Override
    protected void fastRefresh() {
    }

    @Override
    protected void fullRefresh() {
    }

    public Workunit getWorkunit(String wuid) {
        if (this.isEnabled()) {
            return Workunit.get(this, wuid);
        }
        return null;
    }

    public Workunit getWorkunit(ECLWorkunit wu) {
        Workunit workunit = this.getWorkunit(wu.getWuid());
        workunit.update(wu);
        return workunit;
    }

    Collection<Workunit> getWorkunits(boolean userOnly, String cluster, String startDate, String endDate) {
        return this.getWorkunits(userOnly, cluster, startDate, endDate, "", "", "");
    }

    Collection<Workunit> getWorkunits(boolean userOnly, String cluster, String startDate, String endDate, String jobname) {
        return this.getWorkunits(userOnly, cluster, startDate, endDate, jobname, "", "");
    }

    public Collection<Workunit> getWorkunits(boolean userOnly, String cluster, String startDate, String endDate, String jobname, String appKey, String appData) {
        if (this.isEnabled()) {
            Workunit.All.pushTransaction("platform.getWorkunits");
            try {
                HPCCWsWorkUnitsClient wsWorkUnitsClient = this.platformHPCCClient.getWsWorkunitsClient();
                WUQueryWrapper info = new WUQueryWrapper().setJobname(jobname).setCluster(cluster).setStartDate(Utils.UTCStringToDate(startDate)).setEndDate(Utils.UTCStringToDate(endDate)).setPageSize(100L).setOwner(userOnly ? this.getUser() : null);
                info.getApplicationValues().add(new ApplicationValueWrapper(API_ID, appKey, appData));
                List<WorkunitWrapper> response = wsWorkUnitsClient.workUnitUQuery(info);
                this.updateWorkunits(response);
            }
            catch (RemoteException e) {
                this.confirmDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Workunit.All.popTransaction();
            return new HashSet<Workunit>(this.workunits);
        }
        return new HashSet<Workunit>();
    }

    public static String toESPString(GregorianCalendar _calendar) {
        Calendar now = GregorianCalendar.getInstance();
        Calendar nowUTC = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
        int delta = nowUTC.get(11) - now.get(11);
        GregorianCalendar calendar = (GregorianCalendar)_calendar.clone();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        calendar.add(11, delta);
        return df.format(calendar.getTime());
    }

    public Collection<Workunit> getWorkunits(String owner, String cluster, GregorianCalendar startDate, GregorianCalendar endDate) {
        if (this.isEnabled()) {
            Workunit.All.pushTransaction("platform.getWorkunits");
            try {
                HPCCWsWorkUnitsClient wsWorkUnitsClient = this.platformHPCCClient.getWsWorkunitsClient();
                WUQueryWrapper info = new WUQueryWrapper();
                info.setCluster(cluster);
                info.setStartDate(startDate.getTime());
                info.setEndDate(endDate.getTime());
                info.setPageSize(100L);
                info.setOwner(owner);
                List<WorkunitWrapper> response = wsWorkUnitsClient.workUnitUQuery(info);
                this.updateWorkunits(response);
            }
            catch (RemoteException e) {
                this.confirmDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Workunit.All.popTransaction();
            return new HashSet<Workunit>(this.workunits);
        }
        return new HashSet<Workunit>();
    }

    public Collection<Workunit> getWorkunits(boolean userOnly, String cluster) {
        return this.getWorkunits(userOnly, cluster, "", "");
    }

    public Collection<Workunit> getWorkunits(boolean userOnly) {
        return this.getWorkunits(userOnly, "", "", "");
    }

    synchronized void updateWorkunits(List<WorkunitWrapper> response) {
        this.workunits.clear();
        if (response != null) {
            for (WorkunitWrapper wu : response) {
                if (!Workunit.isValidWUIDString(wu.getWuid())) continue;
                this.workunits.add(this.getWorkunit(wu.getEclWorkunit()));
            }
        }
    }

    public FileSprayWorkunit getFileSprayWorkunit(String id) {
        return FileSprayWorkunit.get(this, id);
    }

    public FileSprayWorkunit getFileSprayWorkunit(DFUWorkunitWrapper wu) {
        FileSprayWorkunit workunit = null;
        if (wu != null) {
            workunit = this.getFileSprayWorkunit(wu.getID());
            workunit.update(wu);
        }
        return workunit;
    }

    public FileSprayWorkunit[] getFileSprayWorkunits(String cluster) {
        if (this.isEnabled()) {
            try {
                ArrayOfDFUWorkunitWrapper results;
                HPCCFileSprayClient fileSprayClient = this.platformHPCCClient.getFileSprayClient();
                GetDFUWorkunitsResponseWrapper response = fileSprayClient.getDFUWorkunits(cluster, 100L);
                if (response != null && (results = response.getResults()).getDFUWorkunit() != null) {
                    this.updateFileSprayWorkunits(results.getDFUWorkunit());
                }
            }
            catch (RemoteException e) {
                this.confirmDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fileSprayWorkunits.toArray(new FileSprayWorkunit[0]);
    }

    public FileSprayWorkunit[] getFileSprayWorkunits() {
        return this.getFileSprayWorkunits("");
    }

    synchronized void updateFileSprayWorkunits(List<DFUWorkunitWrapper> list) {
        this.fileSprayWorkunits.clear();
        if (list != null) {
            for (DFUWorkunitWrapper wu : list) {
                this.fileSprayWorkunits.add(this.getFileSprayWorkunit(wu));
            }
        }
    }

    public DataQuerySet getDataQuerySet(String name) {
        return DataQuerySet.get(this, name);
    }

    public DataQuerySet getDataQuerySet(QuerySet qs) {
        DataQuerySet dataQuerySet = this.getDataQuerySet(qs.getQuerySetName());
        dataQuerySet.Update(qs);
        return dataQuerySet;
    }

    public DataQuerySet[] getDataQuerySets() {
        if (this.isEnabled()) {
            try {
                HPCCWsWorkUnitsClient wsWorkunitsClient = this.platformHPCCClient.getWsWorkunitsClient();
                QuerySet[] queryset = wsWorkunitsClient.getQuerySets();
                this.updateDataQuerySets(queryset);
            }
            catch (RemoteException e) {
                this.confirmDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.dataQuerySets.toArray(new DataQuerySet[0]);
    }

    synchronized void updateDataQuerySets(QuerySet[] rawQuerySets) {
        this.dataQuerySets.clear();
        if (rawQuerySets != null) {
            for (QuerySet qs : rawQuerySets) {
                this.dataQuerySets.add(this.getDataQuerySet(qs));
            }
        }
    }

    public LogicalFile getLogicalFile(String name) {
        return LogicalFile.get(this, name);
    }

    public LogicalFile getLogicalFile(DFULogicalFile lf) {
        LogicalFile logicalFile = this.getLogicalFile(lf.getName());
        logicalFile.update(lf);
        return logicalFile;
    }

    public LogicalFile getLogicalFile(ECLSourceFile sf) {
        LogicalFile logicalFile = this.getLogicalFile(sf.getName());
        logicalFile.Update(sf);
        return logicalFile;
    }

    public LogicalFile[] getLogicalFiles(String cluster) {
        if (this.isEnabled()) {
            try {
                HPCCWsDFUClient wsDfuClient = this.platformHPCCClient.getWsDFUClient();
                this.updateLogicalFiles(wsDfuClient.getLogicalFiles(null, cluster, 100, 0, 100));
            }
            catch (ArrayOfEspExceptionWrapper e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                this.confirmDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.logicalFiles.toArray(new LogicalFile[0]);
    }

    public LogicalFile[] getLogicalFiles() {
        return this.getLogicalFiles("");
    }

    synchronized void updateLogicalFiles(List<DFULogicalFileWrapper> rawLogicalFiles) {
        this.logicalFiles.clear();
        if (rawLogicalFiles != null) {
            for (DFULogicalFileWrapper lf : rawLogicalFiles) {
                this.logicalFiles.add(this.getLogicalFile(lf.getFileName()));
            }
        }
    }

    public Cluster getCluster(String name) {
        return Cluster.get(this, name);
    }

    public Cluster getCluster(TpTargetCluster tc) {
        Cluster cluster = this.getCluster(tc.getName());
        cluster.Update(tc);
        return cluster;
    }

    public Cluster[] getClusters() {
        if (this.isEnabled()) {
            try {
                HPCCWsTopologyClient wsTopologyClient = this.platformHPCCClient.getWsTopologyClient();
                this.updateClusters(wsTopologyClient.getLogicalClusters());
            }
            catch (ArrayOfEspExceptionWrapper e) {
                e.printStackTrace();
            }
            catch (RemoteException e) {
                this.confirmDisable();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.clusters.toArray(new Cluster[0]);
    }

    synchronized void updateClusters(List<TpLogicalClusterWrapper> tpLogicalClusters) {
        if (tpLogicalClusters != null) {
            for (TpLogicalClusterWrapper clusterwrapper : tpLogicalClusters) {
                this.clusters.add(this.getCluster(clusterwrapper.getName()));
            }
        }
    }

    public DropZone getDropZone(String name) {
        return DropZone.get(this, name);
    }

    public DropZone getDropZone(TpDropZone dz) {
        DropZone dropZone = this.getDropZone(dz.getName());
        dropZone.update(dz);
        return dropZone;
    }

    public DropZone getDropZone(TpDropZoneWrapper dz) {
        DropZone dropZone = this.getDropZone(dz.getName());
        dropZone.update(dz.getRaw());
        return dropZone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DropZone[] getDropZones() {
        if (this.isEnabled()) {
            HPCCWsClient hpccclient = null;
            try {
                hpccclient = (HPCCWsClient)this.hpccClientPool.checkOut();
                HPCCWsTopologyClient topclient = hpccclient.getWsTopologyClient();
                TpServicesWrapper services = topclient.getServices();
                if (services != null) {
                    this.updateServices(services);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.confirmDisable();
            }
            finally {
                this.hpccClientPool.checkIn(hpccclient);
            }
        }
        return this.dropZones.toArray(new DropZone[0]);
    }

    private void updateServices(TpServicesWrapper serviceList) {
        if (serviceList != null) {
            this.updateDropZones(serviceList.getTpDropZones().getTpDropZone());
        }
    }

    private void updateDropZones(List<TpDropZoneWrapper> rawDropZones) {
        if (rawDropZones != null) {
            for (TpDropZoneWrapper dz : rawDropZones) {
                this.dropZones.add(this.getDropZone(dz));
            }
        }
    }

    public URL getURL() throws MalformedURLException {
        return this.getURL("");
    }

    public URL getURL(String service) throws MalformedURLException {
        return new URL(this.getProtocol(), this.getIP(), this.getPort(), "/" + service);
    }

    public URL getURL(String service, String method) throws MalformedURLException {
        return this.getURL(service + "/" + method);
    }

    public URL getURL(String service, String method, String params) throws MalformedURLException {
        return this.getURL(service + "/" + method + "?" + params);
    }

    public URL getWidgetURL(String widget, String params) throws MalformedURLException {
        return this.getURL("esp/files/stub.htm?Widget=" + widget + (params.isEmpty() ? "" : "&" + params));
    }

    void latencyTest() {
        if (LATENCY_TEST == 0) {
            return;
        }
        try {
            Thread.sleep(LATENCY_TEST);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public HPCCWsClient getWsClient() throws Exception {
        this.latencyTest();
        return this.platformHPCCClient;
    }

    public HPCCWsClient checkOutHPCCWsClient() throws Exception {
        return (HPCCWsClient)this.hpccClientPool.checkOut();
    }

    public void checkInHPCCWsClient(HPCCWsClient client) throws Exception {
        this.hpccClientPool.checkIn(client);
    }

    public boolean validateHPCCWsClient(HPCCWsClient client) {
        return this.hpccClientPool.validate(client);
    }

    public void expireHPCCWsClient(HPCCWsClient client) {
        this.hpccClientPool.expire(client);
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Platform)) {
            return false;
        }
        Platform that = (Platform)aThat;
        return EqualsUtil.areEqual(this.platformHPCCClient, that.platformHPCCClient);
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.getProtocol());
        result = HashCodeUtil.hash(result, this.getIP());
        result = HashCodeUtil.hash(result, this.getPort());
        result = HashCodeUtil.hash(result, this.getUser());
        return result;
    }

    private static enum SERVER_EXISTS {
        UNKNOWN,
        TESTING,
        FALSE,
        TRUE;

    }
}

