/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XRefMessageWrapper {
    private static final String TEXT_TAG = "text";
    private static final String FILE_TAG = "file";
    protected String text = null;
    protected String file = null;
    protected String type = null;

    public XRefMessageWrapper(Node xrefnode) {
        this.populatemessage(xrefnode);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getText() {
        return this.text;
    }

    public String getFile() {
        return this.file;
    }

    public String getType() {
        return this.type;
    }

    private void populatemessage(Node currentNode) {
        if (currentNode != null) {
            try {
                NodeList currentChildren = currentNode.getChildNodes();
                this.setType(currentNode.getNodeName());
                for (int childindex = 0; childindex < currentChildren.getLength(); ++childindex) {
                    Node childNode = currentChildren.item(childindex);
                    String tagName = childNode.getNodeName();
                    if (tagName.equalsIgnoreCase(TEXT_TAG)) {
                        this.setText(childNode.getTextContent());
                        continue;
                    }
                    if (!tagName.equalsIgnoreCase(FILE_TAG)) continue;
                    this.setFile(childNode.getTextContent());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "Type: " + this.type + " File: " + this.file + " Text: " + this.text;
    }
}

