/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers.wsdfu;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.activation.DataHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.latest.ArrayOfDFUPartLocation;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.latest.DFUFileAccessInfo;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.latest.DFUFileType;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUFilePart;
import org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUPartLocation;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFilePartWrapper;
import org.hpccsystems.ws.client.wrappers.wsdfu.DFUFileTypeWrapper;

public class DFUFileAccessInfoWrapper {
    private String metaInfoBlob = null;
    private String expiryTime = null;
    private Integer numParts = null;
    private String recordTypeInfoJson = null;
    private Integer fileAccessPort = null;
    private Boolean fileAccessSSL = null;
    private byte[] recordTypeInfoBin = null;
    private DFUFilePartWrapper[] wrappedDFUFileParts;
    private String[] allFilePartCopyHosts;
    private DFUFileTypeWrapper fileType = null;
    private static final Logger log = LogManager.getLogger(DFUFileAccessInfoWrapper.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DFUFileAccessInfoWrapper(DFUFileAccessInfo accessInfo, DFUFileType filetype) throws Exception {
        if (accessInfo == null) throw new Exception("Could not construct DFUCreateFileWrapper: response or response.getAccessInfo is null");
        this.metaInfoBlob = accessInfo.getMetaInfoBlob();
        this.expiryTime = accessInfo.getExpiryTime();
        this.numParts = accessInfo.getNumParts();
        this.recordTypeInfoJson = accessInfo.getRecordTypeInfoJson();
        this.fileAccessPort = accessInfo.getFileAccessPort();
        this.fileAccessSSL = accessInfo.getFileAccessSSL();
        this.fileType = filetype != null ? DFUFileTypeWrapper.fromDfuFileType(filetype) : DFUFileTypeWrapper.Flat;
        ArrayOfDFUPartLocation fileLocations = accessInfo.getFileLocations();
        if (fileLocations == null) throw new Exception("Could not construct DFUCreateFileWrapper: empty file locations");
        org.hpccsystems.ws.client.gen.axis2.wsdfu.latest.DFUPartLocation[] dfufileLocations = fileLocations.getDFUPartLocation();
        this.wrappedDFUFileParts = this.wrapAndResolveFileParts(dfufileLocations, accessInfo.getFileParts().getDFUFilePart());
        this.allFilePartCopyHosts = new String[dfufileLocations.length];
        for (int i = 0; i < dfufileLocations.length; ++i) {
            String host = dfufileLocations[i].getHost();
            if (host.trim().isEmpty()) {
                throw new Exception("Error: DFUPartLocation contains empty 'host'");
            }
            this.allFilePartCopyHosts[i] = host;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DFUFileAccessInfoWrapper(org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUFileAccessInfo accessInfo) throws Exception {
        if (accessInfo == null) throw new Exception("Could not construct DFUCreateFileWrapper: response or response.getAccessInfo is null");
        this.metaInfoBlob = accessInfo.getMetaInfoBlob();
        this.expiryTime = accessInfo.getExpiryTime();
        this.numParts = accessInfo.getNumParts();
        this.recordTypeInfoJson = accessInfo.getRecordTypeInfoJson();
        this.fileAccessPort = accessInfo.getFileAccessPort();
        this.fileAccessSSL = accessInfo.getFileAccessSSL();
        try {
            DataHandler handler = accessInfo.getRecordTypeInfoBin();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            handler.writeTo((OutputStream)output);
            this.recordTypeInfoBin = output.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.ArrayOfDFUPartLocation fileLocations = accessInfo.getFileLocations();
        if (fileLocations == null) throw new Exception("Could not construct DFUCreateFileWrapper: empty file locations");
        DFUPartLocation[] dfufileLocations = fileLocations.getDFUPartLocation();
        this.wrappedDFUFileParts = this.wrapAndResolveFileParts(dfufileLocations, accessInfo.getFileParts().getDFUFilePart());
        this.allFilePartCopyHosts = new String[dfufileLocations.length];
        for (int i = 0; i < dfufileLocations.length; ++i) {
            this.allFilePartCopyHosts[i] = dfufileLocations[i].getHost();
        }
    }

    private DFUFilePartWrapper[] wrapAndResolveFileParts(org.hpccsystems.ws.client.gen.axis2.wsdfu.latest.DFUPartLocation[] fileLocations, org.hpccsystems.ws.client.gen.axis2.wsdfu.latest.DFUFilePart[] fileParts) throws Exception {
        if (fileLocations == null || fileLocations.length == 0) {
            throw new Exception("Encountered empty DFU Part Locations array");
        }
        if (fileParts == null || fileParts.length == 0) {
            throw new Exception("Encountered empty DFU Parts array");
        }
        Hashtable<Integer, String> availableLocations = new Hashtable<Integer, String>(fileLocations.length);
        for (int locationindex = 0; locationindex < fileLocations.length; ++locationindex) {
            availableLocations.put(fileLocations[locationindex].getLocationIndex(), fileLocations[locationindex].getHost());
        }
        int dataFilePartsCount = fileParts.length;
        DFUFilePartWrapper[] wrappedDFUFileParts = new DFUFilePartWrapper[dataFilePartsCount];
        for (int i = 0; i < dataFilePartsCount; ++i) {
            Integer filepartindex = fileParts[i].getPartIndex();
            if (filepartindex < 1 || filepartindex > dataFilePartsCount) {
                throw new IndexOutOfBoundsException("Encountered invalid Filepart index: '" + filepartindex + "'");
            }
            if (wrappedDFUFileParts[filepartindex - 1] != null) {
                throw new IndexOutOfBoundsException("Encountered duplicate Filepart copy index: '" + filepartindex + "'");
            }
            wrappedDFUFileParts[filepartindex.intValue() - 1] = new DFUFilePartWrapper(fileParts[i], availableLocations);
        }
        return wrappedDFUFileParts;
    }

    public DFUFileAccessInfoWrapper(DFUFileAccessInfo accessInfo) throws Exception {
        if (accessInfo != null) {
            this.metaInfoBlob = accessInfo.getMetaInfoBlob();
            this.expiryTime = accessInfo.getExpiryTime();
            this.numParts = accessInfo.getNumParts();
            this.recordTypeInfoJson = accessInfo.getRecordTypeInfoJson();
            this.fileAccessPort = accessInfo.getFileAccessPort();
            this.fileAccessSSL = accessInfo.getFileAccessSSL();
            org.hpccsystems.ws.client.gen.axis2.wsdfu.latest.DFUPartLocation[] fileLocations = accessInfo.getFileLocations().getDFUPartLocation();
            this.wrappedDFUFileParts = this.wrapAndResolveFileParts(fileLocations, accessInfo.getFileParts().getDFUFilePart());
            this.allFilePartCopyHosts = new String[fileLocations.length];
            for (int i = 0; i < fileLocations.length; ++i) {
                this.allFilePartCopyHosts[i] = fileLocations[i].getHost();
            }
        } else {
            throw new Exception("Could not construct DFUCreateFileWrapper: response or response.getAccessInfo is null");
        }
    }

    public DFUFileAccessInfoWrapper(org.hpccsystems.ws.client.gen.axis2.wsdfu.v1_39.DFUFileAccessInfo accessInfo, Object filetype) throws Exception {
        if (accessInfo != null) {
            this.metaInfoBlob = accessInfo.getMetaInfoBlob();
            this.expiryTime = accessInfo.getExpiryTime();
            this.numParts = accessInfo.getNumParts();
            this.recordTypeInfoJson = accessInfo.getRecordTypeInfoJson();
            this.fileAccessPort = accessInfo.getFileAccessPort();
            this.fileAccessSSL = accessInfo.getFileAccessSSL();
            try {
                DataHandler handler = accessInfo.getRecordTypeInfoBin();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                handler.writeTo((OutputStream)output);
                this.recordTypeInfoBin = output.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DFUPartLocation[] fileLocations = accessInfo.getFileLocations().getDFUPartLocation();
            this.wrappedDFUFileParts = this.wrapAndResolveFileParts(fileLocations, accessInfo.getFileParts().getDFUFilePart());
            this.allFilePartCopyHosts = new String[fileLocations.length];
            for (int i = 0; i < fileLocations.length; ++i) {
                this.allFilePartCopyHosts[i] = fileLocations[i].getHost();
            }
        } else {
            throw new Exception("Could not construct DFUCreateFileWrapper: response or response.getAccessInfo is null");
        }
    }

    private DFUFilePartWrapper[] wrapAndResolveFileParts(DFUPartLocation[] fileLocations, DFUFilePart[] fileParts) throws Exception {
        if (fileLocations == null || fileLocations.length == 0) {
            throw new Exception("Encountered empty DFU Part Locations array");
        }
        if (fileParts == null || fileParts.length == 0) {
            throw new Exception("Encountered empty DFU Parts array");
        }
        Hashtable<Integer, String> availableLocations = new Hashtable<Integer, String>(fileLocations.length);
        for (int locationindex = 0; locationindex < fileLocations.length; ++locationindex) {
            availableLocations.put(fileLocations[locationindex].getLocationIndex(), fileLocations[locationindex].getHost());
        }
        int dataFilePartsCount = fileParts.length;
        DFUFilePartWrapper[] wrappedDFUFileParts = new DFUFilePartWrapper[dataFilePartsCount];
        for (int i = 0; i < dataFilePartsCount; ++i) {
            Integer filepartindex = fileParts[i].getPartIndex();
            if (filepartindex < 1 || filepartindex > dataFilePartsCount) {
                throw new IndexOutOfBoundsException("Encountered invalid data filepart index: '" + filepartindex + "'");
            }
            if (wrappedDFUFileParts[filepartindex - 1] != null) {
                throw new IndexOutOfBoundsException("Encountered duplicate Filepart copy index: '" + filepartindex + "'");
            }
            wrappedDFUFileParts[filepartindex.intValue() - 1] = new DFUFilePartWrapper(fileParts[i], availableLocations);
        }
        return wrappedDFUFileParts;
    }

    public DFUFileTypeWrapper getFileType() {
        return this.fileType;
    }

    public String getFileAccessInfoBlob() {
        return this.metaInfoBlob;
    }

    public String getExpiryTime() {
        return this.expiryTime;
    }

    public int getNumParts() {
        return this.numParts;
    }

    public DFUFilePartWrapper[] getFileParts() {
        return this.wrappedDFUFileParts;
    }

    public byte[] getRecordTypeInfoBin() {
        return this.recordTypeInfoBin;
    }

    public String getRecordTypeInfoJson() {
        return this.recordTypeInfoJson;
    }

    public String[] getAllFilePartCopyLocations() {
        return this.allFilePartCopyHosts;
    }

    public Integer getFileAccessPort() {
        return this.fileAccessPort;
    }

    public Boolean getFileAccessSSL() {
        return this.fileAccessSSL;
    }
}

