/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.platform;

import java.util.HashMap;
import java.util.Map;
import org.hpccsystems.ws.client.HPCCWsWorkUnitsClient;
import org.hpccsystems.ws.client.gen.axis2.wsworkunits.latest.ECLGraph;
import org.hpccsystems.ws.client.platform.Workunit;
import org.hpccsystems.ws.client.utils.DataSingleton;
import org.hpccsystems.ws.client.utils.EqualsUtil;
import org.hpccsystems.ws.client.utils.HashCodeUtil;
import org.hpccsystems.ws.client.wrappers.WUState;

public class Graph
extends DataSingleton {
    private static Map<Integer, Graph> Graphs = new HashMap<Integer, Graph>();
    private Workunit workunit;
    private ECLGraph info;

    public static synchronized Graph get(Workunit workunit, String name) {
        Graph graph = new Graph(workunit, name);
        if (Graphs.containsKey(graph.hashCode())) {
            return Graphs.get(graph.hashCode());
        }
        Graphs.put(graph.hashCode(), graph);
        return graph;
    }

    private Graph(Workunit workunit, String name) {
        this.workunit = workunit;
        this.info = new ECLGraph();
        this.info.setName(name);
    }

    public Workunit getWorkunit() {
        return this.workunit;
    }

    public String getWuid() {
        return this.workunit.getWuid();
    }

    public String getName() {
        return this.info.getName();
    }

    public WUState getStateID() {
        if (this.info.getRunning()) {
            return WUState.RUNNING;
        }
        if (this.info.getComplete()) {
            return WUState.COMPLETED;
        }
        if (this.info.getFailed()) {
            return WUState.FAILED;
        }
        return WUState.UNKNOWN;
    }

    @Override
    public boolean isComplete() {
        return HPCCWsWorkUnitsClient.isWorkunitComplete(this.getStateID()) || this.workunit.isComplete();
    }

    @Override
    protected void fastRefresh() {
        this.fullRefresh();
    }

    @Override
    protected void fullRefresh() {
        this.workunit.getGraphs();
    }

    boolean update(ECLGraph graph) {
        boolean retVal = false;
        if (graph != null && this.info.getName().equals(graph.getName()) && !this.info.equals(graph) && this.UpdateState(graph)) {
            retVal = true;
            this.notifyObservers((Object)Notification.GRAPH);
        }
        this.monitor();
        return retVal;
    }

    boolean UpdateState(ECLGraph graph) {
        if (this.info.getName().equals(graph.getName()) && EqualsUtil.hasChanged(this.info, graph)) {
            this.info = graph;
            this.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof Graph)) {
            return false;
        }
        Graph that = (Graph)aThat;
        return EqualsUtil.areEqual(this.workunit, that.workunit) && EqualsUtil.areEqual(this.info.getName(), that.info.getName());
    }

    @Override
    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.workunit);
        result = HashCodeUtil.hash(result, this.info.getName());
        return result;
    }

    public static enum Notification {
        GRAPH;

    }
}

