/*
 * Decompiled with CFR 0.152.
 */
package org.hpccsystems.ws.client.wrappers.gen.wsresources;

import java.util.ArrayList;
import java.util.List;
import org.hpccsystems.ws.client.gen.axis2.wsresources.latest.EspStringArray;
import org.hpccsystems.ws.client.gen.axis2.wsresources.latest.ServiceConnection;
import org.hpccsystems.ws.client.wrappers.gen.wsresources.ArrayOfServicePortsWrapper;
import org.hpccsystems.ws.client.wrappers.gen.wsresources.ExternalIPStatusWrapper;

public class ServiceConnectionWrapper {
    protected String local_type;
    protected List<String> local_externalIPs = null;
    protected ExternalIPStatusWrapper local_externalIPStatus;
    protected ArrayOfServicePortsWrapper local_ports;

    public ServiceConnectionWrapper() {
    }

    public ServiceConnectionWrapper(ServiceConnection serviceconnection) {
        this.copy(serviceconnection);
    }

    public ServiceConnectionWrapper(String _type, List<String> _externalIPs, ExternalIPStatusWrapper _externalIPStatus, ArrayOfServicePortsWrapper _ports) {
        this.local_type = _type;
        this.local_externalIPs = _externalIPs;
        this.local_externalIPStatus = _externalIPStatus;
        this.local_ports = _ports;
    }

    private void copy(ServiceConnection raw) {
        if (raw == null) {
            return;
        }
        this.local_type = raw.getType();
        if (raw.getExternalIPs() != null && raw.getExternalIPs().getItem() != null) {
            this.local_externalIPs = new ArrayList<String>();
            for (int i = 0; i < raw.getExternalIPs().getItem().length; ++i) {
                this.local_externalIPs.add(new String(raw.getExternalIPs().getItem()[i]));
            }
        }
        if (raw.getExternalIPStatus() != null) {
            this.local_externalIPStatus = new ExternalIPStatusWrapper(raw.getExternalIPStatus());
        }
        if (raw.getPorts() != null) {
            this.local_ports = new ArrayOfServicePortsWrapper(raw.getPorts());
        }
    }

    public String toString() {
        return "ServiceConnectionWrapper [type = " + this.local_type + ", externalIPs = " + this.local_externalIPs + ", externalIPStatus = " + this.local_externalIPStatus + ", ports = " + this.local_ports + "]";
    }

    public ServiceConnection getRaw() {
        ServiceConnection raw = new ServiceConnection();
        raw.setType(this.local_type);
        if (this.local_externalIPs != null) {
            EspStringArray arr = new EspStringArray();
            for (int i = 0; i < this.local_externalIPs.size(); ++i) {
                arr.addItem(this.local_externalIPs.get(i));
            }
            raw.setExternalIPs(arr);
        }
        if (this.local_externalIPStatus != null) {
            raw.setExternalIPStatus(this.local_externalIPStatus.getRaw());
        }
        if (this.local_ports != null) {
            raw.setPorts(this.local_ports.getRaw());
        }
        return raw;
    }

    public void setType(String _type) {
        this.local_type = _type;
    }

    public String getType() {
        return this.local_type;
    }

    public void setExternalIPs(List<String> _externalIPs) {
        this.local_externalIPs = _externalIPs;
    }

    public List<String> getExternalIPs() {
        return this.local_externalIPs;
    }

    public void setExternalIPStatus(ExternalIPStatusWrapper _externalIPStatus) {
        this.local_externalIPStatus = _externalIPStatus;
    }

    public ExternalIPStatusWrapper getExternalIPStatus() {
        return this.local_externalIPStatus;
    }

    public void setPorts(ArrayOfServicePortsWrapper _ports) {
        this.local_ports = _ports;
    }

    public ArrayOfServicePortsWrapper getPorts() {
        return this.local_ports;
    }
}

