/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.fhir;

import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import java.time.LocalDate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.beans.factory.annotation.Value;

public class RelativeDateTransformerInterceptor
extends InterceptorAdapter {
    @Value(value="${hspc.platform.api.fhir.relativeDateTransformerEnabled:false}")
    private String enabled;
    private LocalDate baselineDate = null;

    public RelativeDateTransformerInterceptor(LocalDate baselineDate) {
        this.baselineDate = baselineDate;
    }

    public void incomingRequestPreHandled(RestOperationTypeEnum theOperation, IServerInterceptor.ActionRequestDetails theProcessedRequest) {
        boolean isEnabled = Boolean.valueOf(this.enabled);
        if (isEnabled && this.baselineDate != null) {
            switch (theOperation) {
                case CREATE: 
                case DELETE: 
                case UPDATE: {
                    IBaseResource resource = theProcessedRequest.getResource();
                    break;
                }
            }
            super.incomingRequestPreHandled(theOperation, theProcessedRequest);
        } else {
            super.incomingRequestPreHandled(theOperation, theProcessedRequest);
        }
    }
}

