/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import org.hspconsortium.platform.api.proxy.LoggingObject;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.RequestCallback;

public class DefaultRequestCallback
extends LoggingObject
implements RequestCallback {
    private HttpServletRequest httpRequest;
    private String[] headerNamesToCopy;

    public DefaultRequestCallback(HttpServletRequest httpRequest, String ... headerNamesToCopy) {
        this.httpRequest = httpRequest;
        this.headerNamesToCopy = headerNamesToCopy;
    }

    public void doWithRequest(ClientHttpRequest request) throws IOException {
        this.copyHeaders(this.httpRequest, request);
        FileCopyUtils.copy((InputStream)this.httpRequest.getInputStream(), (OutputStream)request.getBody());
    }

    protected void copyHeaders(HttpServletRequest httpRequest, ClientHttpRequest request) {
        if (this.headerNamesToCopy != null) {
            for (String name : this.headerNamesToCopy) {
                String value = httpRequest.getHeader(name);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.format("Setting client HTTP header '%s' to '%s'", name, value));
                }
                request.getHeaders().set(name, value);
            }
        }
    }

    public void setHeaderNamesToCopy(String[] headerNamesToInclude) {
        this.headerNamesToCopy = headerNamesToInclude;
    }
}

