/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.hspconsortium.platform.api.proxy.LoggingObject;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.ResponseExtractor;

public class DefaultResponseExtractor
extends LoggingObject
implements ResponseExtractor<Void> {
    private HttpServletResponse httpResponse;
    private String[] headerNamesToCopy;

    public DefaultResponseExtractor(HttpServletResponse httpResponse, String ... headerNamesToCopy) {
        this.httpResponse = httpResponse;
        this.headerNamesToCopy = headerNamesToCopy;
    }

    public Void extractData(ClientHttpResponse response) throws IOException {
        this.copyHeaders(this.httpResponse, response);
        InputStream body = response.getBody();
        if (body != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Copying the client HTTP response body to the servlet HTTP response");
            }
            FileCopyUtils.copy((InputStream)response.getBody(), (OutputStream)this.httpResponse.getOutputStream());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("No body in the client HTTP response, so not copying anything to the servlet HTTP response");
        }
        this.httpResponse.setStatus(response.getRawStatusCode());
        return null;
    }

    protected void copyHeaders(HttpServletResponse httpResponse, ClientHttpResponse response) {
        if (this.headerNamesToCopy != null) {
            for (String name : this.headerNamesToCopy) {
                List values = response.getHeaders().get((Object)name);
                if (values == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.format("Setting servlet HTTP header '%s' to '%s'", name, values));
                }
                for (String value : values) {
                    httpResponse.addHeader(name, value);
                }
            }
        }
    }
}

