/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.proxy;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hspconsortium.platform.api.proxy.DefaultRequestCallback;
import org.hspconsortium.platform.api.proxy.DefaultResponseExtractor;
import org.hspconsortium.platform.api.proxy.LoggingObject;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestOperations;

public class HttpProxy
extends LoggingObject {
    private RestOperations restOperations;
    private String protocol;
    private String host;
    private Integer port;

    public HttpProxy(RestOperations restTemplate, String protocol, String host, Integer port) {
        this.restOperations = restTemplate;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public void proxy(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.proxy(httpRequest.getServletPath(), httpRequest, httpResponse, new String[0]);
    }

    public void proxy(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String ... headerNamesToCopy) {
        this.proxy(httpRequest.getServletPath(), httpRequest, httpResponse, new DefaultRequestCallback(httpRequest, headerNamesToCopy), new DefaultResponseExtractor(httpResponse, headerNamesToCopy));
    }

    public void proxy(String path, HttpServletRequest httpRequest, HttpServletResponse httpResponse, String ... headerNamesToCopy) {
        this.proxy(path, httpRequest, httpResponse, new DefaultRequestCallback(httpRequest, headerNamesToCopy), new DefaultResponseExtractor(httpResponse, headerNamesToCopy));
    }

    public <T> T proxy(String path, HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) {
        URI uri = this.buildUri(httpRequest, this.protocol, this.host, this.port, path);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(this.format("Proxying to URI: %s", uri));
        }
        HttpMethod method = this.determineMethod(httpRequest);
        return (T)this.restOperations.execute(uri, method, requestCallback, responseExtractor);
    }

    protected HttpMethod determineMethod(HttpServletRequest request) {
        return HttpMethod.valueOf((String)request.getMethod());
    }

    protected URI buildUri(HttpServletRequest httpRequest, String protocol, String host, Integer port, String path) {
        try {
            if (port != null) {
                return new URI(protocol, null, host, port, path, httpRequest.getQueryString(), null);
            }
            return new URI(protocol, host, path, httpRequest.getQueryString(), null);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Unable to build URI, cause: " + ex.getMessage(), ex);
        }
    }
}

