/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.terminology;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@RestController
@RequestMapping(value={"/federated"})
public class FederatedRequestSender {
    @Value(value="${hspc.platform.api.fhir.federatedEndpointURL}")
    private String federatedEndpointURL;

    @RequestMapping(value={"/health"}, method={RequestMethod.GET})
    public String health() {
        return "OK";
    }

    @RequestMapping(method={RequestMethod.GET})
    public void handleFederatedRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpGet httpGetRequest;
        Map parameters = request.getParameterMap();
        try {
            httpGetRequest = new HttpGet(this.buildWithParameters(parameters, this.federatedEndpointURL).build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("There was an error creating the Http Request.\nError : %s .", e.getCause()));
        }
        httpGetRequest.addHeader("Accept", "application/json");
        this.sendRequest((HttpUriRequest)httpGetRequest, response);
    }

    protected URIBuilder buildWithParameters(Map parameters, String endpoint) {
        String[] params;
        String[] uri = (String[])parameters.get("uri");
        String[] pathAndQuery = uri[0].split("\\?");
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (String keyValuePair : params = pathAndQuery[1].split("&")) {
            String[] keyValuePairArray = keyValuePair.split("=");
            nameValuePairs.add((NameValuePair)new BasicNameValuePair(keyValuePairArray[0], keyValuePairArray[1]));
        }
        return this.configureBuilder("http", endpoint, pathAndQuery[0], nameValuePairs);
    }

    protected URIBuilder configureBuilder(String schema, String host, String path, List<NameValuePair> parameters) {
        return new URIBuilder().setScheme(schema).setHost(host).setPath(path).setParameters(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest(HttpUriRequest theRequest, HttpServletResponse response) {
        try (CloseableHttpClient httpClient = HttpClients.custom().build();
             CloseableHttpResponse closeableHttpResponse = httpClient.execute(theRequest);){
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                HttpEntity rEntity = closeableHttpResponse.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)rEntity, (Charset)StandardCharsets.UTF_8);
                throw new RuntimeException(String.format("There was a problem contacting the terminology server.\nResponse Status : %s .\nResponse Detail :%s.", closeableHttpResponse.getStatusLine(), responseString));
            }
            response.setHeader("Content-Type", "application/json;charset=utf-8");
            response.getWriter().write(EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity()));
        }
        catch (IOException io_ex) {
            throw new RuntimeException("Error sending request", io_ex);
        }
    }
}

