/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.oauth2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hspconsortium.platform.api.oauth2.HspcOAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;

public class HspcAccessTokenConverter
extends DefaultAccessTokenConverter {
    public OAuth2Authentication extractAuthentication(Map<String, ?> map) {
        Map newMap = HspcAccessTokenConverter.convertScopeStringToCollection(map);
        OAuth2Authentication oAuth2Authentication = super.extractAuthentication(newMap);
        HspcOAuth2Authentication hspcOAuth2Authentication = new HspcOAuth2Authentication(oAuth2Authentication.getOAuth2Request(), oAuth2Authentication.getUserAuthentication());
        hspcOAuth2Authentication.setLaunchContextParams(this.extractLaunchContextParams(map));
        return hspcOAuth2Authentication;
    }

    private Map<String, String> extractLaunchContextParams(Map<String, ?> map) {
        Object launchContext = map.get("launch_context");
        if (launchContext != null && String.class.isInstance(launchContext)) {
            String launchContextString = (String)launchContext;
            List<String> launchContextCollection = Arrays.asList(launchContextString.split(","));
            HashMap<String, String> launchContextParams = new HashMap<String, String>();
            for (String curParam : launchContextCollection) {
                int splitIndex = curParam.indexOf("=");
                String key = curParam.substring(0, splitIndex);
                String value = curParam.substring(splitIndex + 1);
                launchContextParams.put(key, value);
            }
            return launchContextParams;
        }
        return null;
    }

    public static Map convertScopeStringToCollection(Map map) {
        Object scopeObj = map.get("scope");
        if (scopeObj != null && scopeObj instanceof String) {
            HashMap<String, List<String>> newMap = new HashMap<String, List<String>>(map);
            String scopeStr = (String)scopeObj;
            List<String> scopeCollection = Arrays.asList(scopeStr.split(" "));
            newMap.put("scope", scopeCollection);
            return newMap;
        }
        return map;
    }
}

