/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.oauth2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.platform.api.oauth2.CorsFilter;
import org.hspconsortium.platform.api.oauth2.HspcAccessTokenConverter;
import org.hspconsortium.platform.api.oauth2.InvalidMediaTypeFilter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationProcessingFilter;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RegexRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableResourceServer
@Profile(value={"default"})
public class OAuth2ResourceConfig
extends ResourceServerConfigurerAdapter {
    public static final String SECURITY_MODE_OPEN = "open";
    public static final String SECURITY_MODE_SECURED = "secured";
    public static final String SECURITY_MODE_MOCK = "mock";
    public static final String NO_ENDPOINT = "none";
    @Value(value="${hspc.platform.api.security.mode}")
    private String securityMode;
    @Value(value="${hspc.platform.api.fhir.contextPath:data}")
    private String fhirContextPath;
    @Value(value="${hspc.platform.api.fhir.openContextPath:none}")
    private String openContextPath;
    @Value(value="${hspc.platform.api.fhir.additionalPermittedEndpointPairs:none}")
    private String[] additionalPermittedEndpointPairs;

    public String getSecurityMode() {
        return this.securityMode;
    }

    public String getFhirContextPath() {
        return this.fhirContextPath;
    }

    public String getOpenContextPath() {
        return this.openContextPath;
    }

    @Bean
    public AccessTokenConverter accessTokenConverter() {
        return new HspcAccessTokenConverter();
    }

    @Bean
    public ResourceServerTokenServices remoteTokenServices(@Value(value="${hspc.platform.authorization.tokenCheckUrl}") String tokenCheckUrl, @Value(value="${hspc.platform.api.oauth2.clientId}") String clientId, @Value(value="${hspc.platform.api.oauth2.clientSecret}") String clientSecret) {
        if (this.getSecurityMode().equalsIgnoreCase(SECURITY_MODE_MOCK)) {
            return null;
        }
        RemoteTokenServices remoteTokenServices = new RemoteTokenServices();
        remoteTokenServices.setCheckTokenEndpointUrl(tokenCheckUrl);
        remoteTokenServices.setClientId(clientId);
        remoteTokenServices.setClientSecret(clientSecret);
        remoteTokenServices.setAccessTokenConverter(this.accessTokenConverter());
        return remoteTokenServices;
    }

    @Bean
    SecurityFilterChainPostProcessor securityFilterChainPostProcessor() {
        return new SecurityFilterChainPostProcessor();
    }

    @Bean
    @Order(value=-2147483648)
    public InvalidMediaTypeFilter invalidMediaTypeFilter() {
        return new InvalidMediaTypeFilter();
    }

    @Bean
    @Order(value=-2147483647)
    public CorsFilter customCorsFilter() {
        return new CorsFilter();
    }

    public void configure(HttpSecurity http) throws Exception {
        Validate.isTrue((this.fhirContextPath != null ? 1 : 0) != 0, (String)"Fhir context path not specified", (Object[])new Object[0]);
        CorsFilter corsFilter = this.customCorsFilter();
        http.addFilterBefore((Filter)corsFilter, ChannelProcessingFilter.class);
        InvalidMediaTypeFilter invalidMediaTypeFilter = this.invalidMediaTypeFilter();
        http.addFilterBefore((Filter)invalidMediaTypeFilter, CorsFilter.class);
        this.configureHttpEndpoints(http);
    }

    protected void configureHttpEndpoints(HttpSecurity http) throws Exception {
        this.configureCustomPaths(http);
        this.configureSystemEndpoints(http);
        this.configureSandboxEndpoints(http);
        this.configureFhirContextPath(http);
        this.configureOpenContextPath(http);
        if (this.getSecurityMode().equalsIgnoreCase(SECURITY_MODE_MOCK)) {
            ArrayList<AntPathRequestMatcher> requestMatchers = new ArrayList<AntPathRequestMatcher>();
            requestMatchers.add(new AntPathRequestMatcher("/**"));
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.requestMatcher((RequestMatcher)new OrRequestMatcher(requestMatchers)).authorizeRequests().antMatchers(new String[]{"/**"})).permitAll();
        } else {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).authenticated();
        }
    }

    protected void configureCustomPaths(HttpSecurity http) throws Exception {
    }

    protected void configureSystemEndpoints(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/", "/health"})).permitAll().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/system/**", null), new AntPathRequestMatcher("/terminology*", "GET"), new AntPathRequestMatcher("/terminology/**", "GET"), new AntPathRequestMatcher("/federated*", "GET"), new AntPathRequestMatcher("/test/.**", "GET")})).permitAll();
        if (this.additionalPermittedEndpointPairs != null && this.additionalPermittedEndpointPairs.length > 0 && !NO_ENDPOINT.equals(this.additionalPermittedEndpointPairs[0])) {
            block4: for (String endpointMethodPair : this.additionalPermittedEndpointPairs) {
                String[] endpointMethod = endpointMethodPair.split("\\|");
                switch (endpointMethod.length) {
                    case 1: {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{endpointMethod[0]})).permitAll();
                        continue block4;
                    }
                    case 2: {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(HttpMethod.valueOf((String)endpointMethod[1]), new String[]{endpointMethod[0]})).permitAll();
                        continue block4;
                    }
                    default: {
                        throw new RuntimeException("Value [" + endpointMethodPair + "] is not in the required format of [endpoint|HttpMethod] ex: [http://example.com|GET]");
                    }
                }
            }
        }
    }

    protected void configureSandboxEndpoints(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/sandbox/**"})).permitAll();
    }

    protected void configureFhirContextPath(HttpSecurity http) throws Exception {
        if (this.fhirContextPath != null && this.fhirContextPath.length() > 0) {
            switch (this.getSecurityMode()) {
                case "open": {
                    this.configureOpenFHIRServer(http, this.fhirContextPath);
                    break;
                }
                case "secured": {
                    this.configureSecuredFHIRServer(http, this.fhirContextPath);
                    break;
                }
                case "mock": {
                    this.configureOpenFHIRServer(http, this.fhirContextPath);
                    break;
                }
                default: {
                    throw new RuntimeException("Security mode must be either open or secured");
                }
            }
        }
    }

    protected void configureOpenContextPath(HttpSecurity http) throws Exception {
        if (this.openContextPath != null && this.openContextPath.length() > 0 && !NO_ENDPOINT.equals(this.openContextPath)) {
            this.configureOpenFHIRServer(http, this.openContextPath);
        }
    }

    protected void configureOpenFHIRServer(HttpSecurity http, String fhirPath) throws Exception {
        if (fhirPath != null) {
            this.permitRegex(http, "\\/" + fhirPath, null);
            this.permitRegex(http, "\\/" + fhirPath + "\\/.*", null);
        }
    }

    protected void configureSecuredFHIRServer(HttpSecurity http, String fhirPath) throws Exception {
        if (fhirPath != null && fhirPath.length() > 0) {
            this.permitRegex(http, "\\/" + fhirPath + "\\/metadata", "GET");
            this.permitRegex(http, "\\/" + fhirPath + "\\/metadata.*", "GET");
            this.permitRegex(http, "\\/" + fhirPath + "\\/_services\\/smart\\/.*", null);
        }
    }

    public void permitAntPath(HttpSecurity http, String antPath, String httpMethod) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher(antPath, httpMethod)})).permitAll();
    }

    public void permitRegex(HttpSecurity http, String pathExpression, String httpMethod) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().requestMatchers(new RequestMatcher[]{new RegexRequestMatcher(pathExpression, httpMethod)})).permitAll();
    }

    static class SecurityFilterChainPostProcessor
    implements BeanPostProcessor {
        private static final String SECURITY_MODE_MOCK = "mock";
        @Value(value="${hspc.platform.api.security.mode}")
        private String securityMode;

        SecurityFilterChainPostProcessor() {
        }

        private String getSecurityMode() {
            return this.securityMode;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (this.getSecurityMode().equalsIgnoreCase("mock") && beanName.equals("springSecurityFilterChain")) {
                FilterChainProxy proxy = (FilterChainProxy)bean;
                List chains = proxy.getFilterChains();
                for (SecurityFilterChain fc : chains) {
                    DefaultSecurityFilterChain dfc = (DefaultSecurityFilterChain)fc;
                    List filters = dfc.getFilters();
                    Iterator i = filters.iterator();
                    while (i.hasNext()) {
                        if (!(i.next() instanceof OAuth2AuthenticationProcessingFilter)) continue;
                        i.remove();
                    }
                }
            }
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

