/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.controller;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.jpa.dao.DaoConfig;
import ca.uhn.fhir.jpa.dao.IFhirSystemDao;
import ca.uhn.fhir.jpa.provider.JpaSystemProviderDstu2;
import ca.uhn.fhir.jpa.provider.dstu3.JpaSystemProviderDstu3;
import ca.uhn.fhir.jpa.provider.dstu3.TerminologyUploaderProviderDstu3;
import ca.uhn.fhir.jpa.provider.r4.JpaSystemProviderR4;
import ca.uhn.fhir.jpa.search.DatabaseBackedPagingProvider;
import ca.uhn.fhir.model.dstu2.composite.MetaDt;
import ca.uhn.fhir.narrative.DefaultThymeleafNarrativeGenerator;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Meta;
import org.hspconsortium.platform.api.conformance.HspcConformanceProviderDstu2;
import org.hspconsortium.platform.api.conformance.HspcConformanceProviderR4;
import org.hspconsortium.platform.api.conformance.HspcConformanceProviderStu3;
import org.hspconsortium.platform.api.controller.HapiFhirServletContextHolder;
import org.hspconsortium.platform.api.fhir.repository.MetadataRepositoryDstu2;
import org.hspconsortium.platform.api.fhir.repository.MetadataRepositoryDstu2Impl;
import org.hspconsortium.platform.api.fhir.repository.MetadataRepositoryR4;
import org.hspconsortium.platform.api.fhir.repository.MetadataRepositoryStu3;
import org.springframework.web.context.WebApplicationContext;

public class HapiFhirServlet
extends RestfulServer {
    private static final long serialVersionUID = 1L;
    private String fhirMappingPath;
    private String openMappingPath;

    protected void initialize() throws ServletException {
        Object confProvider;
        IFhirSystemDao systemDao;
        Object systemProvider;
        String resourceProviderBeanName;
        super.initialize();
        WebApplicationContext myAppCtx = HapiFhirServletContextHolder.getInstance().getMyAppCtx();
        this.fhirMappingPath = HapiFhirServletContextHolder.getInstance().getFhirMappingPath();
        this.openMappingPath = HapiFhirServletContextHolder.getInstance().getOpenMappingPath();
        FhirVersionEnum fhirVersionEnum = HapiFhirServletContextHolder.getInstance().getFhirVersionEnum();
        FhirContext fhirContext = (FhirContext)myAppCtx.getBean(FhirContext.class);
        this.setFhirContext(fhirContext);
        if (fhirVersionEnum == FhirVersionEnum.DSTU2) {
            resourceProviderBeanName = "myResourceProvidersDstu2";
        } else if (fhirVersionEnum == FhirVersionEnum.DSTU3) {
            resourceProviderBeanName = "myResourceProvidersDstu3";
        } else if (fhirVersionEnum == FhirVersionEnum.R4) {
            resourceProviderBeanName = "myResourceProvidersR4";
        } else {
            throw new IllegalStateException("Not a supported FHIR Version: " + fhirVersionEnum);
        }
        List beans = (List)myAppCtx.getBean(resourceProviderBeanName, List.class);
        this.setResourceProviders(beans);
        if (fhirVersionEnum == FhirVersionEnum.DSTU2) {
            systemProvider = myAppCtx.getBean("mySystemProviderDstu2", JpaSystemProviderDstu2.class);
        } else if (fhirVersionEnum == FhirVersionEnum.DSTU3) {
            systemProvider = myAppCtx.getBean("mySystemProviderDstu3", JpaSystemProviderDstu3.class);
        } else if (fhirVersionEnum == FhirVersionEnum.R4) {
            systemProvider = myAppCtx.getBean("mySystemProviderR4", JpaSystemProviderR4.class);
        } else {
            throw new IllegalStateException();
        }
        this.setPlainProviders(new Object[]{systemProvider});
        if (fhirVersionEnum == FhirVersionEnum.DSTU2) {
            systemDao = (IFhirSystemDao)myAppCtx.getBean("mySystemDaoDstu2", IFhirSystemDao.class);
            confProvider = new HspcConformanceProviderDstu2(this, (IFhirSystemDao<ca.uhn.fhir.model.dstu2.resource.Bundle, MetaDt>)systemDao, (DaoConfig)myAppCtx.getBean(DaoConfig.class), (MetadataRepositoryDstu2)myAppCtx.getBean(MetadataRepositoryDstu2Impl.class));
            confProvider.setImplementationDescription("HSPC Reference API Server - DSTU2");
            this.setServerConformanceProvider(confProvider);
        } else if (fhirVersionEnum == FhirVersionEnum.DSTU3) {
            systemDao = (IFhirSystemDao)myAppCtx.getBean("mySystemDaoDstu3", IFhirSystemDao.class);
            confProvider = new HspcConformanceProviderStu3(this, (IFhirSystemDao<org.hl7.fhir.dstu3.model.Bundle, org.hl7.fhir.dstu3.model.Meta>)systemDao, (DaoConfig)myAppCtx.getBean(DaoConfig.class), (MetadataRepositoryStu3)myAppCtx.getBean(MetadataRepositoryStu3.class));
            confProvider.setImplementationDescription("HSPC Reference API Server - STU3");
            this.setServerConformanceProvider(confProvider);
        } else if (fhirVersionEnum == FhirVersionEnum.R4) {
            systemDao = (IFhirSystemDao)myAppCtx.getBean("mySystemDaoR4", IFhirSystemDao.class);
            confProvider = new HspcConformanceProviderR4(this, (IFhirSystemDao<Bundle, Meta>)systemDao, (DaoConfig)myAppCtx.getBean(DaoConfig.class), (MetadataRepositoryR4)myAppCtx.getBean(MetadataRepositoryR4.class));
            confProvider.setImplementationDescription("HSPC Reference API Server - R4");
            this.setServerConformanceProvider(confProvider);
        } else {
            throw new IllegalStateException();
        }
        this.setETagSupport(ETagSupportEnum.ENABLED);
        FhirContext ctx = this.getFhirContext();
        ctx.setNarrativeGenerator((INarrativeGenerator)new DefaultThymeleafNarrativeGenerator());
        this.setDefaultPrettyPrint(true);
        this.setDefaultResponseEncoding(EncodingEnum.JSON);
        this.setPagingProvider((IPagingProvider)myAppCtx.getBean(DatabaseBackedPagingProvider.class));
        Collection interceptorBeans = myAppCtx.getBeansOfType(IServerInterceptor.class).values();
        for (IServerInterceptor interceptor : interceptorBeans) {
            this.registerInterceptor(interceptor);
        }
        if (fhirVersionEnum == FhirVersionEnum.DSTU3) {
            this.registerProvider(myAppCtx.getBean(TerminologyUploaderProviderDstu3.class));
        }
    }

    protected String getRequestPath(String requestFullPath, String servletContextPath, String servletPath) {
        String remainder = requestFullPath.substring(this.escapedLength(servletContextPath));
        if (remainder.length() > 0 && remainder.charAt(0) == '/') {
            remainder = remainder.substring(1);
        }
        String[] split = remainder.split("/", 3);
        StringBuffer stringBuffer = new StringBuffer();
        boolean foundFhirMappingPath = false;
        for (String part : split) {
            if (foundFhirMappingPath) {
                stringBuffer.append(part);
                stringBuffer.append("/");
                continue;
            }
            if (!part.equals(this.fhirMappingPath) && !part.equals(this.openMappingPath)) continue;
            foundFhirMappingPath = true;
        }
        return stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : "";
    }

    public String getServerBaseForRequest(HttpServletRequest theRequest) {
        String fhirServerBase = this.getServerAddressStrategy().determineServerBase(this.getServletContext(), theRequest);
        String[] split = fhirServerBase.split("/");
        StringBuffer result = new StringBuffer();
        for (String current : split) {
            result.append(current);
            if (current.equals(this.fhirMappingPath) || current.equals(this.openMappingPath)) {
                return result.toString();
            }
            result.append("/");
        }
        throw new RuntimeException("Something bad happened, only matched: " + result.toString());
    }
}

