/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.controller;

import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.platform.api.controller.ResourceNotFoundException;
import org.hspconsortium.platform.api.controller.SandboxReservedName;
import org.hspconsortium.platform.api.model.DataSet;
import org.hspconsortium.platform.api.model.ResetSandboxCommand;
import org.hspconsortium.platform.api.model.Sandbox;
import org.hspconsortium.platform.api.model.SnapshotSandboxCommand;
import org.hspconsortium.platform.api.service.SandboxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"${hspc.platform.api.sandboxPath:/sandbox}"})
@Profile(value={"default"})
public class SandboxController {
    @Value(value="${hspc.platform.api.sandbox.name}")
    private String sandboxName;
    private SandboxService sandboxService;

    @Autowired
    public SandboxController(SandboxService sandboxService) {
        this.sandboxService = sandboxService;
    }

    @RequestMapping(method={RequestMethod.PUT})
    public Sandbox save(@NotNull @RequestBody Sandbox sandbox, @RequestParam(value="dataSet", required=false) DataSet dataSet) {
        Validate.notNull((Object)sandbox);
        Validate.notNull((Object)sandbox.getTeamId());
        if (dataSet == null) {
            dataSet = DataSet.NONE;
        }
        return this.sandboxService.save(sandbox, dataSet);
    }

    @RequestMapping(method={RequestMethod.GET})
    public Sandbox get() {
        Sandbox existing = this.sandboxService.get(this.sandboxName);
        if (existing == null) {
            throw new ResourceNotFoundException("Sandbox [" + this.sandboxName + "] is not found");
        }
        return existing;
    }

    @RequestMapping(path={"/reset"}, method={RequestMethod.POST})
    public String reset(@RequestBody ResetSandboxCommand resetSandboxCommand) {
        this.sandboxService.reset(this.sandboxName, resetSandboxCommand.getDataSet());
        return "Success";
    }

    @RequestMapping(path={"/snapshot"}, method={RequestMethod.GET})
    public Set<String> getSnapshots() {
        return this.sandboxService.getSandboxSnapshots(this.sandboxName);
    }

    @RequestMapping(path={"/snapshot/{snapshotId}"}, method={RequestMethod.POST})
    public String snapshot(@PathVariable(value="snapshotId") String snapshotId, @RequestBody SnapshotSandboxCommand snapshotSandboxCommand) {
        Validate.notNull((Object)snapshotId);
        Validate.isTrue((boolean)snapshotId.matches("^[a-zA-Z0-9]+$"), (String)"Snapshot ID must only contain alphanumeric characters", (Object[])new Object[0]);
        Validate.isTrue((snapshotId.length() < 20 ? 1 : 0) != 0, (String)"Snapshot ID must be less than 20 characters", (Object[])new Object[0]);
        Validate.notNull((Object)snapshotSandboxCommand);
        Validate.notNull((Object)((Object)snapshotSandboxCommand.getAction()));
        switch (snapshotSandboxCommand.getAction()) {
            case Take: {
                return this.sandboxService.takeSnapshot(this.sandboxName, snapshotId);
            }
            case Restore: {
                return this.sandboxService.restoreSnapshot(this.sandboxName, snapshotId);
            }
            case Delete: {
                return this.sandboxService.deleteSnapshot(this.sandboxName, snapshotId);
            }
        }
        throw new RuntimeException("Unknown sandbox command action: " + (Object)((Object)snapshotSandboxCommand.getAction()));
    }

    private void validate(String teamId) {
        try {
            SandboxReservedName.valueOf(teamId);
            throw new ForbiddenOperationException("Sandbox [" + teamId + "] is not allowed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }
}

