/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.interceptor;

import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hspconsortium.platform.api.authorization.ScopeBasedAuthorizationParams;
import org.hspconsortium.platform.api.authorization.SmartScope;
import org.hspconsortium.platform.api.oauth2.HspcOAuth2Authentication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class ScopeBasedAuthorizationInterceptor
extends InterceptorAdapter {
    public static final String LAUNCH_CONTEXT_PATIENT_PARAM_NAME = "patient";
    @Autowired
    private ScopeBasedAuthorizationParams scopeBasedAuthorizationParams;

    public boolean incomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        if (theRequestDetails.getRestOperationType() != RestOperationTypeEnum.SEARCH_TYPE) {
            return true;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !(authentication instanceof HspcOAuth2Authentication)) {
            return true;
        }
        HspcOAuth2Authentication hspcOAuth2Authentication = (HspcOAuth2Authentication)authentication;
        Set<SmartScope> smartScopes = this.getSmartScopes(hspcOAuth2Authentication);
        for (SmartScope smartScope : smartScopes) {
            if (!smartScope.isUserScope()) continue;
            return true;
        }
        for (SmartScope smartScope : smartScopes) {
            if (!smartScope.isPatientScope()) continue;
            String patientId = (String)hspcOAuth2Authentication.getLaunchContextParams().get(LAUNCH_CONTEXT_PATIENT_PARAM_NAME);
            this.filterToPatientScope(patientId, theRequestDetails);
            return true;
        }
        return true;
    }

    private void filterToPatientScope(String patientId, RequestDetails requestDetails) {
        if (patientId == null) {
            throw new SecurityException("For patient scope, a launch_context parameter indicating the in-context patient is required, but none was found.");
        }
        String scopeParam = this.scopeBasedAuthorizationParams.getParamForResource(requestDetails.getResourceName());
        if (scopeParam == null) {
            return;
        }
        Map requestParams = requestDetails.getParameters();
        String[] existingScopeParamValue = (String[])requestParams.get(scopeParam);
        if (existingScopeParamValue == null) {
            requestParams.put(scopeParam, new String[]{patientId});
        } else if (!this.valueAlreadyInParameter(existingScopeParamValue, patientId)) {
            requestParams.put(scopeParam, this.addValueToStringArray(existingScopeParamValue, patientId));
        }
    }

    private String[] addValueToStringArray(String[] stringArray, String newValue) {
        String[] newArray = new String[stringArray.length + 1];
        for (int x = 0; x < newArray.length - 1; ++x) {
            newArray[x] = stringArray[x];
        }
        newArray[newArray.length - 1] = newValue;
        return newArray;
    }

    private boolean valueAlreadyInParameter(String[] existingScopeParamValue, String valueToSearch) {
        for (String anExistingScopeParamValue : existingScopeParamValue) {
            if (!valueToSearch.equals(anExistingScopeParamValue)) continue;
            return true;
        }
        return false;
    }

    private Set<SmartScope> getSmartScopes(HspcOAuth2Authentication hspcOAuth2Authentication) {
        HashSet<SmartScope> scopes = new HashSet<SmartScope>();
        for (String scope : hspcOAuth2Authentication.getOAuth2Request().getScope()) {
            scopes.add(new SmartScope(scope));
        }
        return scopes;
    }
}

