/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.persister;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hspconsortium.platform.api.fhir.DatabaseManager;
import org.hspconsortium.platform.api.fhir.model.TenantInfo;
import org.hspconsortium.platform.api.model.DataSet;
import org.hspconsortium.platform.api.model.Sandbox;
import org.hspconsortium.platform.api.persister.SchemaNotInitializedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class SandboxPersister {
    private static final Logger logger = LoggerFactory.getLogger(SandboxPersister.class);
    private static final String EMPTY_SCHEMA_PATH = "db/hspc_%s_schema_empty.sql";
    private static final String STARTER_SCHEMA_PATH = "db/hspc_%s_%s_%s_dataset.sql";
    private static String DEFAULT_OPEN_CONTEXT_PATH = "none";
    @Value(value="${spring.profiles.active}")
    private String profile;
    Function<Sandbox, String> toSchemaName = sandbox -> {
        try {
            return String.format("%s_%s_%s", "hspc", sandbox.getSchemaVersion(), sandbox.getTeamId());
        }
        catch (Exception e) {
            return null;
        }
    };
    Function<String, String> toTeamId = schemaName -> {
        try {
            return schemaName.split("_")[2];
        }
        catch (Exception e) {
            return null;
        }
    };
    Function<Sandbox, TenantInfo> toTenantInfo = sandbox -> {
        if (sandbox == null) {
            return null;
        }
        TenantInfo tenantInfo = new TenantInfo(sandbox.getTeamId(), sandbox.getSchemaVersion(), sandbox.isAllowOpenAccess());
        tenantInfo.setBaselineDate(sandbox.getBaselineDate());
        String properties = sandbox.getProperties();
        tenantInfo.setProperties(properties != null && properties.length() > 0 ? properties : null);
        return tenantInfo;
    };
    Function<TenantInfo, Sandbox> toSandbox = tenantInfo -> {
        if (tenantInfo == null) {
            return null;
        }
        Sandbox sandbox = new Sandbox(tenantInfo.getTenantId(), tenantInfo.getHspcSchemaVersion(), tenantInfo.isAllowOpenEndpoint());
        sandbox.setBaselineDate(tenantInfo.getBaselineDate());
        sandbox.setProperties(tenantInfo.getPropertiesAsString());
        return sandbox;
    };
    @Autowired
    private DatabaseManager databaseManager;

    @Value(value="${hspc.platform.api.fhir.openContextPath:none}")
    private SandboxPersister setOpenContextPath(String openContextPath) {
        DEFAULT_OPEN_CONTEXT_PATH = openContextPath;
        return this;
    }

    public static Sandbox sandboxTemplate() {
        return new Sandbox(null, "5", !"none".equals(DEFAULT_OPEN_CONTEXT_PATH));
    }

    public List<String> getSandboxes() {
        Set schemas = this.databaseManager.getSchemasLike("hspc_5_%", "%$%");
        if (!schemas.isEmpty()) {
            return schemas.parallelStream().map(this.toTeamId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public boolean isTeamIdUnique(String teamId) {
        Set schemasLike = this.databaseManager.getSchemasLike("%_" + teamId);
        return schemasLike.isEmpty();
    }

    public String findSchemaForTeam(String teamId) {
        Set schemasLike = this.databaseManager.getSchemasLike("hspc_5_" + teamId);
        switch (schemasLike.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (String)schemasLike.iterator().next();
            }
        }
        throw new RuntimeException("More than one schema matched the teamId: [" + teamId + "]");
    }

    public Sandbox findSandbox(String teamId) throws SchemaNotInitializedException {
        String schema = this.findSchemaForTeam(teamId);
        if (schema != null) {
            try {
                TenantInfo tenantInfo = this.databaseManager.getTenantInfo(schema);
                if (tenantInfo != null) {
                    return this.toSandbox.apply(tenantInfo);
                }
                throw new SchemaNotInitializedException().forTeam(teamId);
            }
            catch (Exception e) {
                throw new SchemaNotInitializedException().forTeam(teamId);
            }
        }
        return null;
    }

    public Sandbox saveSandbox(Sandbox sandbox) {
        String schemaName = this.toSchemaName.apply(sandbox);
        TenantInfo tenantInfo = this.toTenantInfo.apply(sandbox);
        TenantInfo saved = this.databaseManager.createAndInitializeSchema(schemaName, tenantInfo);
        return this.toSandbox.apply(saved);
    }

    public Set<String> getSnapshots(Sandbox sandbox) {
        String schemaName = this.toSchemaName.apply(sandbox);
        return this.databaseManager.getSnapshotsForSchema(schemaName);
    }

    public String takeSnapshot(Sandbox sandbox, String suffix) {
        String schemaName = this.toSchemaName.apply(sandbox);
        String snapshot = this.databaseManager.takeSnapshot(schemaName, suffix);
        return snapshot;
    }

    public String restoreSnapshot(Sandbox sandbox, String suffix) {
        String schemaName = this.toSchemaName.apply(sandbox);
        logger.info("schemaName: " + schemaName);
        return this.databaseManager.restoreSnapshot(schemaName, suffix);
    }

    public String deleteSnapshot(Sandbox sandbox, String suffix) {
        String schemaName = this.toSchemaName.apply(sandbox);
        return this.databaseManager.deleteSnapshot(schemaName, suffix);
    }

    public boolean loadInitialDataset(Sandbox sandbox, DataSet starterDataSet) {
        logger.info("loadInitialDataset [" + (Object)((Object)starterDataSet) + "] in sandbox [" + sandbox.toString() + "]");
        DataSet loadingDataSet = DataSet.NONE;
        if (starterDataSet != null) {
            loadingDataSet = starterDataSet;
        }
        String dataFileNameTemplate = loadingDataSet == DataSet.DEFAULT ? STARTER_SCHEMA_PATH : EMPTY_SCHEMA_PATH;
        String dataFileName = String.format(dataFileNameTemplate, sandbox.getSchemaVersion(), this.returnActiveFhirVersion(), loadingDataSet.toString().toLowerCase());
        try {
            ClassPathResource classPathResource = new ClassPathResource(dataFileName);
            InputStream inputStream = classPathResource.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            return this.databaseManager.loadInitialDataset(this.toSchemaName.apply(sandbox), (Reader)reader);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error creating initial dataset. Data file reference '%s'", dataFileName), e);
        }
    }

    public boolean removeSandbox(String schemaVersion, String teamId) {
        return this.databaseManager.dropSchema(this.toSchemaName.apply(new Sandbox(teamId, schemaVersion, false)));
    }

    private String returnActiveFhirVersion() {
        if (this.profile.contains("dstu2")) {
            return "dstu2";
        }
        if (this.profile.contains("stu3")) {
            return "stu3";
        }
        if (this.profile.contains("r4")) {
            return "r4";
        }
        throw new IllegalArgumentException("No valid FHIR version profile is set.");
    }
}

