/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.service;

import java.util.Collection;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.platform.api.model.DataSet;
import org.hspconsortium.platform.api.model.Sandbox;
import org.hspconsortium.platform.api.persister.SandboxPersister;
import org.hspconsortium.platform.api.persister.SchemaNotInitializedException;
import org.hspconsortium.platform.api.security.TenantInfoRequestMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SandboxService {
    private static final Logger logger = LoggerFactory.getLogger(SandboxService.class);
    private SandboxPersister sandboxPersister;
    private TenantInfoRequestMatcher tenantInfoRequestMatcher;

    @Autowired
    public SandboxService(SandboxPersister sandboxPersister, TenantInfoRequestMatcher tenantInfoRequestMatcher) {
        this.sandboxPersister = sandboxPersister;
        this.tenantInfoRequestMatcher = tenantInfoRequestMatcher;
    }

    public void reset() {
        this.tenantInfoRequestMatcher.reset();
        logger.info("Sandbox Service reset");
    }

    public Collection<String> all() {
        return this.sandboxPersister.getSandboxes();
    }

    public Sandbox save(@NotNull Sandbox sandbox, @NotNull DataSet dataSet) {
        logger.info("Saving sandbox: " + sandbox);
        Validate.notNull((Object)sandbox, (String)"Sandbox must be provided", (Object[])new Object[0]);
        Validate.notNull((Object)sandbox.getTeamId(), (String)"Sandbox.teamId must be provided", (Object[])new Object[0]);
        sandbox.setSchemaVersion("5");
        Sandbox existing = null;
        try {
            existing = this.sandboxPersister.findSandbox(sandbox.getTeamId());
            logger.info("Existing sandbox: " + existing);
            if (existing == null && !this.sandboxPersister.isTeamIdUnique(sandbox.getTeamId())) {
                throw new RuntimeException("TeamId is not unique");
            }
        }
        catch (SchemaNotInitializedException e) {
            logger.info("SchemaNotInitializedException ignored for now");
        }
        Sandbox saved = this.sandboxPersister.saveSandbox(sandbox);
        logger.info("Saved sandbox: " + saved);
        logger.info("useStarterData: " + (Object)((Object)dataSet));
        if (existing == null) {
            this.sandboxPersister.loadInitialDataset(sandbox, dataSet);
        }
        saved = this.sandboxPersister.saveSandbox(sandbox);
        logger.info("Saved sandbox: " + saved);
        if (sandbox.isAllowOpenAccess()) {
            this.tenantInfoRequestMatcher.addOpenTeamId(saved.getTeamId());
        } else {
            this.tenantInfoRequestMatcher.removeOpenTeamId(saved.getTeamId());
        }
        return saved;
    }

    public Sandbox get(String teamId) {
        Sandbox sandbox;
        try {
            sandbox = this.sandboxPersister.findSandbox(teamId);
        }
        catch (SchemaNotInitializedException e) {
            sandbox = this.save(SandboxPersister.sandboxTemplate().setTeamId(teamId), DataSet.DEFAULT);
        }
        return sandbox;
    }

    public boolean remove(String teamId) {
        Sandbox existing = this.get(teamId);
        return existing == null || this.delete(existing);
    }

    private boolean delete(Sandbox existing) {
        if (existing != null) {
            boolean success = this.sandboxPersister.removeSandbox(existing.getSchemaVersion(), existing.getTeamId());
            this.tenantInfoRequestMatcher.removeOpenTeamId(existing.getTeamId());
            return success;
        }
        return true;
    }

    public Sandbox reset(String teamId, DataSet dataSet) {
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            throw new RuntimeException("Unable to reset sandbox because sandbox does not exist: [" + teamId + "]");
        }
        boolean deleted = this.delete(existing);
        if (!deleted) {
            throw new RuntimeException("Unable to reset sandbox because existing could not be deleted: [" + teamId + "]");
        }
        return this.save(SandboxPersister.sandboxTemplate().setTeamId(teamId), dataSet);
    }

    public Set<String> getSandboxSnapshots(String teamId) {
        logger.info("getSandboxSnapshots for: " + teamId);
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            throw new RuntimeException("Unable to take snapshot of sandbox that does not exist: [" + teamId + "]");
        }
        Set<String> results = this.sandboxPersister.getSnapshots(existing);
        logger.info("found snapshots: {" + String.join((CharSequence)", ", results) + "}");
        return results;
    }

    public String takeSnapshot(String teamId, String snapshotId) {
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            throw new RuntimeException("Unable to take snapshot of sandbox that does not exist: [" + teamId + "]");
        }
        return this.sandboxPersister.takeSnapshot(existing, snapshotId);
    }

    public String restoreSnapshot(String teamId, String snapshotId) {
        logger.info("restoreSnapshot called for " + teamId + ", " + snapshotId);
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            throw new RuntimeException("Unable to restore snapshot of sandbox that does not exist: [" + teamId + "]");
        }
        logger.info("existing: " + existing.getTeamId());
        return this.sandboxPersister.restoreSnapshot(existing, snapshotId);
    }

    public String deleteSnapshot(String teamId, String snapshotId) {
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            return null;
        }
        try {
            return this.sandboxPersister.deleteSnapshot(existing, snapshotId);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

