/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.controller;

import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.hspconsortium.platform.api.model.Sandbox;
import org.hspconsortium.platform.api.service.SandboxService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management"})
@Deprecated
public class ManagementController {
    private static final Logger logger = LoggerFactory.getLogger(ManagementController.class);
    private static final Set<String> restrictedTenants = Sets.newHashSet((Object[])new String[]{"hspc", "hspc2", "hspc3", "hspc4", "test", "management", "admin"});
    @Autowired
    private SandboxService sandboxService;

    @RequestMapping(value={"/"})
    public String management() {
        return "Management endpoint";
    }

    @RequestMapping(value={"/reset"})
    public String reset() {
        this.sandboxService.reset();
        logger.info("Management Controller reset");
        return "Management reset";
    }

    @RequestMapping(value={"/sandbox"}, method={RequestMethod.GET})
    public Collection<String> all() {
        return this.sandboxService.all();
    }

    @RequestMapping(value={"/sandbox/{teamId}"}, method={RequestMethod.PUT})
    public Sandbox create(@PathVariable String teamId, @RequestBody Sandbox sandbox) {
        this.validate(teamId);
        return this.sandboxService.save(sandbox);
    }

    @RequestMapping(value={"/sandbox/{teamId}"}, method={RequestMethod.GET})
    public Sandbox get(@PathVariable String teamId) {
        Sandbox existing = this.sandboxService.get(teamId);
        if (existing == null) {
            throw new ResourceNotFoundException("Sandbox {" + teamId + "} is not found");
        }
        return existing;
    }

    @RequestMapping(value={"/sandbox/{teamId}"}, method={RequestMethod.DELETE})
    public boolean delete(@PathVariable String teamId) {
        this.validate(teamId);
        return this.sandboxService.remove(teamId);
    }

    private void validate(String teamId) {
        if (restrictedTenants.contains(teamId)) {
            throw new ForbiddenOperationException("Sandbox {" + teamId + "} is not allowed.");
        }
    }
}

