/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.service;

import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.platform.api.model.Sandbox;
import org.hspconsortium.platform.api.persister.SandboxPersister;
import org.hspconsortium.platform.api.persister.SchemaNotInitializedException;
import org.hspconsortium.platform.api.security.TenantInfoRequestMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SandboxService {
    private static final Logger logger = LoggerFactory.getLogger(SandboxService.class);
    private SandboxPersister sandboxPersister;
    private TenantInfoRequestMatcher tenantInfoRequestMatcher;
    @Value(value="${hspc.platform.api.sandbox.useHspcStarterData:false}")
    public String useHspcStarterData;

    @Autowired
    public SandboxService(SandboxPersister sandboxPersister, TenantInfoRequestMatcher tenantInfoRequestMatcher) {
        this.sandboxPersister = sandboxPersister;
        this.tenantInfoRequestMatcher = tenantInfoRequestMatcher;
    }

    public void reset() {
        this.tenantInfoRequestMatcher.reset();
        logger.info("Sandbox Service reset");
    }

    public Collection<String> all() {
        return this.sandboxPersister.getSandboxes();
    }

    public Sandbox save(@NotNull Sandbox sandbox) {
        Validate.notNull((Object)sandbox, (String)"Sandbox must be provided", (Object[])new Object[0]);
        Validate.notNull((Object)sandbox.getTeamId(), (String)"Sandbox.teamId must be provided", (Object[])new Object[0]);
        if (sandbox.getSchemaVersion() != null) {
            Validate.isTrue((boolean)"4".equals(sandbox.getSchemaVersion()), (String)("Sandbox schema version [" + sandbox.getSchemaVersion() + "] is not expected schema version [" + "4" + "]"), (Object[])new Object[0]);
        } else {
            sandbox.setSchemaVersion("4");
        }
        Sandbox existing = null;
        try {
            existing = this.sandboxPersister.findSandbox(sandbox.getTeamId());
            if (existing == null && !this.sandboxPersister.isTeamIdUnique(sandbox.getTeamId())) {
                throw new RuntimeException("TeamID is not unique");
            }
        }
        catch (SchemaNotInitializedException schemaNotInitializedException) {
            // empty catch block
        }
        Sandbox saved = this.sandboxPersister.saveSandbox(sandbox);
        boolean useStarterData = Boolean.valueOf(this.useHspcStarterData);
        if (existing == null) {
            this.sandboxPersister.loadInitialDataset(sandbox, useStarterData);
        }
        if (sandbox.isAllowOpenAccess()) {
            this.tenantInfoRequestMatcher.addOpenTeamId(saved.getTeamId());
        } else {
            this.tenantInfoRequestMatcher.removeOpenTeamId(saved.getTeamId());
        }
        return saved;
    }

    public Sandbox get(String teamId) {
        Sandbox sandbox;
        try {
            sandbox = this.sandboxPersister.findSandbox(teamId);
        }
        catch (SchemaNotInitializedException e) {
            sandbox = this.save(SandboxPersister.sandboxTemplate().setTeamId(teamId));
        }
        return sandbox;
    }

    public boolean remove(String teamId) {
        Sandbox existing = this.get(teamId);
        return existing == null || this.delete(existing);
    }

    private boolean delete(Sandbox existing) {
        if (existing != null) {
            boolean success = this.sandboxPersister.removeSandbox(existing.getSchemaVersion(), existing.getTeamId());
            this.tenantInfoRequestMatcher.removeOpenTeamId(existing.getTeamId());
            return success;
        }
        return true;
    }

    public Sandbox reset(String teamId) {
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            throw new RuntimeException("Unable to reset sandbox because sandbox does not exist: [" + teamId + "]");
        }
        boolean deleted = this.delete(existing);
        if (!deleted) {
            throw new RuntimeException("Unable to reset sandbox because existing could not be deleted: [" + teamId + "]");
        }
        return this.save(SandboxPersister.sandboxTemplate().setTeamId(teamId));
    }

    public Sandbox takeSnapshot(String teamId, String snapshotId) {
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            throw new RuntimeException("Unable to take snapshot of sandbox that does not exist: [" + teamId + "]");
        }
        return this.sandboxPersister.takeSnapshot(existing, snapshotId);
    }

    public Sandbox restoreSnapshot(String teamId, String snapshotId) {
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            throw new RuntimeException("Unable to restore snapshot of sandbox that does not exist: [" + teamId + "]");
        }
        return this.sandboxPersister.restoreSnapshot(existing, snapshotId);
    }

    public Sandbox deleteSnapshot(String teamId, String snapshotId) {
        Sandbox existing = this.get(teamId);
        if (existing == null) {
            return null;
        }
        try {
            return this.sandboxPersister.deleteSnapshot(existing, snapshotId);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

