/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.api.authorization;

import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hspconsortium.platform.api.authorization.ScopeBasedAuthorizationParams;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"stu3"})
public class ScopeBasedAuthorizationParamsStu3
implements ScopeBasedAuthorizationParams {
    @Override
    public String getParamForResource(String resourceTypeString) {
        ResourceType resourceType = null;
        try {
            resourceType = ResourceType.fromCode((String)resourceTypeString);
        }
        catch (FHIRException e) {
            e.printStackTrace();
            throw new SecurityException("Unexpected resource type: " + resourceTypeString);
        }
        switch (resourceType) {
            case Encounter: 
            case BodySite: 
            case CarePlan: 
            case Consent: 
            case Claim: 
            case ClaimResponse: 
            case DetectedIssue: 
            case EpisodeOfCare: 
            case FamilyMemberHistory: 
            case Flag: 
            case Goal: 
            case ImagingStudy: 
            case Immunization: 
            case ImmunizationRecommendation: 
            case MeasureReport: 
            case MedicationDispense: 
            case NutritionOrder: 
            case Person: 
            case RelatedPerson: 
            case SupplyDelivery: 
            case VisionPrescription: 
            case Basic: 
            case AllergyIntolerance: 
            case AuditEvent: 
            case CareTeam: 
            case Condition: 
            case Procedure: 
            case ReferralRequest: 
            case ImagingManifest: 
            case MedicationAdministration: 
            case EligibilityRequest: 
            case ExplanationOfBenefit: {
                return "patient";
            }
            case Account: 
            case AdverseEvent: 
            case ChargeItem: 
            case DeviceUseStatement: 
            case DiagnosticReport: 
            case EnrollmentRequest: 
            case Media: 
            case MedicationStatement: 
            case RiskAssessment: 
            case Specimen: 
            case Observation: 
            case ProcedureRequest: 
            case QuestionnaireResponse: 
            case RequestGroup: 
            case ClinicalImpression: 
            case Communication: 
            case CommunicationRequest: 
            case Composition: 
            case DeviceRequest: 
            case List: 
            case DocumentManifest: 
            case DocumentReference: 
            case MedicationRequest: {
                return "subject";
            }
            case Appointment: 
            case AppointmentResponse: 
            case Schedule: {
                return "actor";
            }
            case Group: {
                return "member";
            }
            case Patient: {
                return "link";
            }
            case Provenance: {
                return "target.subject";
            }
            case ResearchSubject: {
                return "individual";
            }
            case Coverage: {
                return "policy-holder";
            }
            case SupplyRequest: {
                return "requester";
            }
        }
        return null;
    }
}

